/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.build;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.ModConstants;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.item.action.BlockClickedItemAction;
import bassebombecraft.player.PlayerDirection;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.structure.ChildStructure;
import bassebombecraft.structure.CompositeStructure;
import bassebombecraft.structure.Structure;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockColored;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class BuildRainbowRoad
implements BlockClickedItemAction {
    static final boolean USED_ITEM = true;
    static final boolean DIDNT_USED_ITEM = true;
    static final int STATE_UPDATE_FREQUENCY = 1;
    private static final int MAX_ROAD_SEGMENTS = 8;
    static final int X_SIZE = 3;
    static final int Y_SIZE = 1;
    static final int Z_SIZE = 8;
    static final int X_OFFSET = -1;
    static final int Y_OFFSET_DOWN = -1;
    static final Structure NULL_STRUCTURE = new CompositeStructure();
    Random random = new Random();
    int ticksExisted = 0;
    BlockDirectivesRepository repository = BassebombeCraft.getBassebombeCraft().getBlockDirectivesRepository();

    @Override
    public boolean onItemUse(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.ticksExisted % 1 != 0) {
            return true;
        }
        boolean isGroundBlock = PlayerUtils.isBelowPlayerYPosition(pos.func_177956_o(), playerIn);
        Structure structure = null;
        if (!isGroundBlock) {
            return true;
        }
        structure = this.createRoad();
        int yOffset = PlayerUtils.calculatePlayerFeetPosititionAsInt(playerIn);
        PlayerDirection playerDirection = PlayerUtils.getPlayerDirection(playerIn);
        BlockPos offset = new BlockPos(pos.func_177958_n(), yOffset, pos.func_177952_p());
        List<BlockDirective> directives = GeometryUtils.calculateBlockDirectives(offset, playerDirection, structure);
        this.repository.addAll(directives);
        return true;
    }

    @Override
    public void onUpdate(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    }

    Structure createRoad() {
        CompositeStructure composite = new CompositeStructure();
        int displacement = 0;
        for (int index = 0; index < 8; ++index) {
            displacement = this.calculateDisplacement(index, displacement);
            BlockPos offset = new BlockPos(displacement, -1, 8 * index);
            BlockPos size = new BlockPos(3, 1, 1);
            IBlockState state = Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.MAGENTA);
            composite.add(new ChildStructure(offset, size, Blocks.field_150325_L, state));
            offset = new BlockPos(displacement, -1, 8 * index + 1);
            size = new BlockPos(3, 1, 1);
            state = Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.PURPLE);
            composite.add(new ChildStructure(offset, size, Blocks.field_150325_L, state));
            offset = new BlockPos(displacement, -1, 8 * index + 2);
            size = new BlockPos(3, 1, 1);
            state = Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.BLUE);
            composite.add(new ChildStructure(offset, size, Blocks.field_150325_L, state));
            offset = new BlockPos(displacement, -1, 8 * index + 3);
            size = new BlockPos(3, 1, 1);
            state = Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.LIGHT_BLUE);
            composite.add(new ChildStructure(offset, size, Blocks.field_150325_L, state));
            offset = new BlockPos(displacement, -1, 8 * index + 4);
            size = new BlockPos(3, 1, 1);
            state = Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.LIME);
            composite.add(new ChildStructure(offset, size, Blocks.field_150325_L, state));
            offset = new BlockPos(displacement, -1, 8 * index + 5);
            size = new BlockPos(3, 1, 1);
            state = Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.YELLOW);
            composite.add(new ChildStructure(offset, size, Blocks.field_150325_L, state));
            offset = new BlockPos(displacement, -1, 8 * index + 6);
            size = new BlockPos(3, 1, 1);
            state = Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE);
            composite.add(new ChildStructure(offset, size, Blocks.field_150325_L, state));
            offset = new BlockPos(displacement, -1, 8 * index + 7);
            size = new BlockPos(3, 1, 1);
            state = Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.RED);
            composite.add(new ChildStructure(offset, size, Blocks.field_150325_L, state));
            offset = new BlockPos(displacement, 0, 8 * index);
            size = new BlockPos(4, 4, 8);
            composite.add(new ChildStructure(offset, size, Blocks.field_150350_a));
            BlockPos offsetLightpole = new BlockPos(offset.func_177958_n() - 1, -1, offset.func_177952_p());
            BlockPos sizeLightpole = new BlockPos(1, 1, 1);
            composite.add(new ChildStructure(offsetLightpole, sizeLightpole, Blocks.field_180407_aO));
            BlockPos offsetTorch = new BlockPos(offsetLightpole.func_177958_n(), offsetLightpole.func_177956_o() + sizeLightpole.func_177956_o(), offsetLightpole.func_177952_p());
            BlockPos sizeTorch = ModConstants.UNITY_BLOCK_SIZE;
            composite.add(new ChildStructure(offsetTorch, sizeTorch, Blocks.field_150478_aa));
        }
        return composite;
    }

    int calculateDisplacement(int index, int displacement) {
        if (index == 0) {
            return -1;
        }
        int displacementRandom = this.random.nextInt(3);
        if (displacementRandom == 1) {
            return displacement + 1;
        }
        if (displacementRandom == 2) {
            return displacement - 1;
        }
        return displacement;
    }
}

