/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.mist.entity;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.event.particle.DefaultParticleRendering;
import bassebombecraft.event.particle.ParticleRendering;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRenderingRepository;
import bassebombecraft.item.action.RightClickedItemAction;
import bassebombecraft.item.action.mist.entity.EntityMistActionStrategy;
import bassebombecraft.player.PlayerUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class GenericEntityMist
implements RightClickedItemAction {
    static final int RENDERING_FREQUENCY = 5;
    static final int EFFECT_UPDATE_FREQUENCY = 10;
    static final int INVOCATION_DIST = 4;
    static Random random = new Random();
    int ticksCounter = 0;
    Vec3 mistPos;
    EntityLivingBase entity;
    Vec3 entityLook;
    boolean isActive = false;
    EntityMistActionStrategy strategy;

    public GenericEntityMist(EntityMistActionStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public void onRightClick(World world, EntityLivingBase entity) {
        this.entity = entity;
        this.isActive = true;
        this.ticksCounter = 0;
        this.calculateMistPostition(world, entity);
    }

    void applyEffect(World world, EntityLivingBase invokingEntity) {
        int aoeRange = this.strategy.getEffectRange();
        AxisAlignedBB aabb = AxisAlignedBB.func_178781_a((double)(this.mistPos.field_72450_a - (double)aoeRange), (double)(this.mistPos.field_72448_b - (double)aoeRange), (double)(this.mistPos.field_72449_c - (double)aoeRange), (double)(this.mistPos.field_72450_a + (double)aoeRange), (double)(this.mistPos.field_72448_b + (double)aoeRange), (double)(this.mistPos.field_72449_c + (double)aoeRange));
        List entities = world.func_72872_a(EntityLivingBase.class, aabb);
        for (EntityLivingBase foundEntity : entities) {
            if (PlayerUtils.hasIdenticalUniqueID((Entity)invokingEntity, (Entity)foundEntity) && !this.strategy.isEffectAppliedToInvoker()) continue;
            this.strategy.applyEffectToEntity(foundEntity, this.mistPos);
            if (!this.strategy.isOneShootEffect()) continue;
            this.isActive = false;
            return;
        }
    }

    @Override
    public void onUpdate(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!this.isActive()) {
            return;
        }
        if (this.ticksCounter % 5 == 0) {
            this.render(worldIn);
        }
        if (this.ticksCounter % 10 == 0) {
            this.applyEffect(worldIn, this.entity);
        }
        if (this.ticksCounter > this.strategy.getEffectDuration()) {
            this.isActive = false;
            this.entity = null;
            return;
        }
        ++this.ticksCounter;
    }

    boolean isActive() {
        return this.isActive;
    }

    void calculateMistPostition(World world, EntityLivingBase entity) {
        this.entityLook = entity.func_70676_i(1.0f);
        Vec3 entityLookX4 = new Vec3(this.entityLook.field_72450_a * 4.0, this.entityLook.field_72448_b * 4.0, this.entityLook.field_72449_c * 4.0);
        Vec3 entityPos = new Vec3(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        double x = entityLookX4.field_72450_a;
        float y = entity.func_70047_e();
        double z = entityLookX4.field_72449_c;
        this.mistPos = entityPos.func_72441_c(x, (double)y, z);
    }

    void render(World world) {
        if (!this.strategy.isStationary()) {
            this.mistPos = this.mistPos.func_178787_e(this.entityLook);
        }
        ParticleRenderingRepository particleRepository = BassebombeCraft.getBassebombeCraft().getParticleRenderingRepository();
        BlockPos pos = new BlockPos(this.mistPos);
        for (ParticleRenderingInfo info : this.strategy.getRenderingInfos()) {
            ParticleRendering particle = DefaultParticleRendering.getInstance(pos, info);
            particleRepository.add(particle);
        }
    }

    public String toString() {
        return super.toString() + ", strategy=" + this.strategy;
    }
}

