/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.mist.entity;

import bassebombecraft.event.particle.DefaultParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.item.action.mist.entity.EntityMistActionStrategy;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class LightningBoltMist
implements EntityMistActionStrategy {
    static final int EFFECT_DURATION = 500;
    ParticleRenderingInfo[] infos;

    public LightningBoltMist() {
        float r = 0.75f;
        float g = 0.75f;
        float b = 0.75f;
        int numbers = 5;
        EnumParticleTypes type = EnumParticleTypes.CLOUD;
        int duration = 20;
        double speed = 0.1;
        ParticleRenderingInfo flame = DefaultParticleRenderingInfo.getInstance(type, numbers, duration, r, g, b, speed);
        r = 0.0f;
        g = 0.0f;
        b = 0.25f;
        numbers = 1;
        type = EnumParticleTypes.WATER_DROP;
        duration = 20;
        speed = 0.01;
        ParticleRenderingInfo lava = DefaultParticleRenderingInfo.getInstance(type, numbers, duration, r, g, b, speed);
        this.infos = new ParticleRenderingInfo[]{flame, lava};
    }

    @Override
    public void applyEffectToEntity(EntityLivingBase target, Vec3 mistPos) {
        World world = target.func_130014_f_();
        AxisAlignedBB aabb = target.func_174813_aQ();
        BlockPos min = new BlockPos(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
        BlockPos max = new BlockPos(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
        for (Object pos : BlockPos.func_177980_a((BlockPos)min, (BlockPos)max)) {
            BlockPos typedPos = (BlockPos)pos;
            EntityLightningBolt bolt = new EntityLightningBolt(world, (double)typedPos.func_177958_n(), (double)typedPos.func_177956_o(), (double)typedPos.func_177952_p());
            world.func_72942_c((Entity)bolt);
        }
    }

    @Override
    public int getEffectDuration() {
        return 500;
    }

    @Override
    public boolean isEffectAppliedToInvoker() {
        return false;
    }

    @Override
    public boolean isStationary() {
        return true;
    }

    @Override
    public boolean isOneShootEffect() {
        return false;
    }

    @Override
    public int getEffectRange() {
        return 5;
    }

    @Override
    public ParticleRenderingInfo[] getRenderingInfos() {
        return this.infos;
    }
}

