/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.inventory;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.event.particle.DefaultParticleRendering;
import bassebombecraft.event.particle.ParticleRendering;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRenderingRepository;
import bassebombecraft.item.action.inventory.InventoryItemActionStrategy;
import bassebombecraft.player.PlayerUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class GenericInventoryItem
extends Item {
    static final int RENDERING_FREQUENCY = 5;
    static final int EFFECT_UPDATE_FREQUENCY = 5;
    int ticksCounter = 0;
    InventoryItemActionStrategy strategy;
    ParticleRenderingRepository particleRepository;

    public GenericInventoryItem(String name, InventoryItemActionStrategy strategy) {
        this.func_77655_b(name);
        this.strategy = strategy;
        this.registerForRendering(this);
        this.particleRepository = BassebombeCraft.getBassebombeCraft().getParticleRenderingRepository();
    }

    void registerForRendering(Item item) {
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        ModelResourceLocation location = new ModelResourceLocation("bassebombecraft:" + this.func_77658_a().substring(5), "inventory");
        renderItem.func_175037_a().func_178086_a(item, 0, location);
    }

    void applyEffect(World world, EntityLivingBase invokingEntity) {
        int aoeRange = this.strategy.getEffectRange();
        AxisAlignedBB aabb = AxisAlignedBB.func_178781_a((double)(invokingEntity.field_70165_t - (double)aoeRange), (double)(invokingEntity.field_70163_u - (double)aoeRange), (double)(invokingEntity.field_70161_v - (double)aoeRange), (double)(invokingEntity.field_70165_t + (double)aoeRange), (double)(invokingEntity.field_70163_u + (double)aoeRange), (double)(invokingEntity.field_70161_v + (double)aoeRange));
        List entities = world.func_72872_a(EntityLivingBase.class, aabb);
        for (EntityLivingBase foundEntity : entities) {
            boolean isInvoker;
            if (!this.strategy.shouldApplyEffect((Entity)foundEntity, isInvoker = PlayerUtils.hasIdenticalUniqueID((Entity)invokingEntity, (Entity)foundEntity))) continue;
            this.strategy.applyEffect((Entity)foundEntity, world);
            this.renderEffect(foundEntity.func_174791_d());
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        ++this.ticksCounter;
        if (this.isWorldAtClientSide(worldIn)) {
            return;
        }
        if (!this.isInHotbar(itemSlot)) {
            return;
        }
        if (this.strategy.applyOnlyIfSelected() && !isSelected) {
            return;
        }
        if (this.ticksCounter % 5 == 0) {
            // empty if block
        }
        if (this.ticksCounter % 5 == 0) {
            if (!(entityIn instanceof EntityLivingBase)) {
                return;
            }
            this.applyEffect(worldIn, (EntityLivingBase)entityIn);
        }
    }

    boolean isInHotbar(int itemSlot) {
        if (itemSlot < 0) {
            return false;
        }
        return itemSlot <= 8;
    }

    boolean isWorldAtClientSide(World world) {
        return world.field_72995_K;
    }

    void renderEffect(Vec3 position) {
        BlockPos pos = new BlockPos(position);
        for (ParticleRenderingInfo info : this.strategy.getRenderingInfos()) {
            ParticleRendering particle = DefaultParticleRendering.getInstance(pos, info);
            this.particleRepository.add(particle);
        }
    }
}

