/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.player.pvp;

import bassebombecraft.player.PlayerUtils;
import bassebombecraft.player.pvp.DefaultPvpParticipation;
import bassebombecraft.player.pvp.PvpParticipation;
import bassebombecraft.player.pvp.PvpRepository;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;

public class DefaultPvpRepository
implements PvpRepository {
    Map<EntityPlayer, PvpParticipation> participants = Collections.synchronizedMap(new HashMap());

    @Override
    public boolean isRegisteredForPvp(EntityPlayer player) {
        return this.participants.containsKey(player);
    }

    @Override
    public void participate(EntityPlayer player) {
        if (this.isRegisteredForPvp(player)) {
            PvpParticipation participant = this.participants.get(player);
            participant.extendParticipation();
            return;
        }
        PvpParticipation participant = DefaultPvpParticipation.getInstance(player);
        this.add(participant);
    }

    void add(PvpParticipation participant) {
        if (participant == null) {
            return;
        }
        EntityPlayer player = participant.getPlayer();
        if (this.isRegisteredForPvp(player)) {
            return;
        }
        this.participants.put(player, participant);
        PlayerUtils.sendChatMessageToPlayer(player, "Player entered PVP: " + player.func_70005_c_());
    }

    @Override
    public void remove(PvpParticipation participant) {
        if (participant == null) {
            return;
        }
        EntityPlayer player = participant.getPlayer();
        this.participants.remove(player);
    }

    @Override
    public boolean isPvpActive() {
        return !this.participants.isEmpty();
    }

    @Override
    public void clear() {
        this.participants.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePlayerParticipation() {
        Map<EntityPlayer, PvpParticipation> map = this.participants;
        synchronized (map) {
            Iterator<EntityPlayer> it = this.participants.keySet().iterator();
            while (it.hasNext()) {
                EntityPlayer player = it.next();
                PvpParticipation participant = this.participants.get(player);
                participant.updateDuration();
                if (!participant.isExpired()) continue;
                it.remove();
                PlayerUtils.sendChatMessageToPlayer(player, "Player left PVP: " + player.func_70005_c_());
            }
        }
    }

    public static PvpRepository getInstance() {
        return new DefaultPvpRepository();
    }
}

