/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.structure;

import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.WorldQuery;
import bassebombecraft.structure.ChildStructure;
import bassebombecraft.structure.CompositeStructure;
import bassebombecraft.structure.Structure;
import bassebombecraft.structure.StructureFactory;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class ExplosionStaffStructureFactory
implements StructureFactory {
    private static final int MAX_RIFT_SEGMENTS = 40;
    static final int X_SIZE = 1;
    static final int Y_SIZE = 1;
    static final int Z_SIZE = 3;
    static final int Z_OFFSET = 4;
    static final int Y_OFFSET_DOWN = -2;
    static Random random = new Random();
    static Structure spike = ExplosionStaffStructureFactory.createPileOfTnt();

    @Override
    public Structure getInstance(boolean isGroundBlock, Block sourceBlock, WorldQuery worldQuery) {
        if (isGroundBlock) {
            return ExplosionStaffStructureFactory.createRiftOfTnt();
        }
        return spike;
    }

    @Override
    public boolean calculateOffsetFromPlayerFeet() {
        return true;
    }

    static Structure createRiftOfTnt() {
        CompositeStructure composite = new CompositeStructure();
        int displacement = 0;
        int riftSegments = random.nextInt(41);
        for (int index = 0; index < riftSegments; ++index) {
            displacement = ExplosionStaffStructureFactory.calculateDisplacement(index, displacement);
            BlockDirective offset = new BlockDirective(displacement, -2, 4 + 3 * index);
            BlockDirective size = new BlockDirective(1, 1, 3);
            composite.add(new ChildStructure(offset, size, Blocks.field_150335_W));
            if (index != 0) continue;
            offset = new BlockDirective(offset.getX(), offset.getY() + 1, offset.getZ());
            size = new BlockDirective(1, 1, 1);
            composite.add(new ChildStructure(offset, size, Blocks.field_150451_bX));
        }
        return composite;
    }

    static Structure createPileOfTnt() {
        CompositeStructure composite = new CompositeStructure();
        BlockDirective offset = new BlockDirective(0, 0, 0);
        BlockDirective size = new BlockDirective(1, 5, 1);
        composite.add(new ChildStructure(offset, size, Blocks.field_150335_W));
        offset = new BlockDirective(-1, 0, 0);
        size = new BlockDirective(1, 3, 1);
        composite.add(new ChildStructure(offset, size, Blocks.field_150335_W));
        offset = new BlockDirective(0, 0, 1);
        size = new BlockDirective(1, 7, 1);
        composite.add(new ChildStructure(offset, size, Blocks.field_150335_W));
        offset = new BlockDirective(1, 0, 0);
        size = new BlockDirective(1, 2, 1);
        composite.add(new ChildStructure(offset, size, Blocks.field_150451_bX));
        return composite;
    }

    static int calculateDisplacement(int index, int displacement) {
        if (index == 0) {
            return 0;
        }
        int displacementRandom = random.nextInt(3);
        if (displacementRandom == 1) {
            return displacement + 1;
        }
        if (displacementRandom == 2) {
            return displacement - 1;
        }
        return displacement;
    }
}

