/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.structure;

import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.WorldQuery;
import bassebombecraft.structure.ChildStructure;
import bassebombecraft.structure.CompositeStructure;
import bassebombecraft.structure.Structure;
import bassebombecraft.structure.StructureFactory;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class LavaStaffStructureFactory
implements StructureFactory {
    private static final int RIFT_SEGMENTS = 10;
    static final int X_SIZE = 1;
    static final int Y_SIZE = 2;
    static final int Z_SIZE = 2;
    static final int Y_OFFSET_DOWN = -1;
    static Random random = new Random();
    static Structure spike = LavaStaffStructureFactory.createSpikeOfLava();

    @Override
    public Structure getInstance(boolean isGroundBlock, Block sourceBlock, WorldQuery worldQuery) {
        if (isGroundBlock) {
            return LavaStaffStructureFactory.createRiftOfLava();
        }
        return spike;
    }

    @Override
    public boolean calculateOffsetFromPlayerFeet() {
        return true;
    }

    static Structure createRiftOfLava() {
        CompositeStructure composite = new CompositeStructure();
        int displacement = 0;
        for (int index = 0; index < 10; ++index) {
            displacement = LavaStaffStructureFactory.calculateDisplacement(index, displacement);
            BlockDirective offset = new BlockDirective(displacement, -1, 2 * index);
            BlockDirective size = new BlockDirective(1, 2, 2);
            composite.add(new ChildStructure(offset, size, (Block)Blocks.field_150353_l));
        }
        return composite;
    }

    static Structure createSpikeOfLava() {
        BlockDirective offset = new BlockDirective(0, 0, 0);
        BlockDirective size = new BlockDirective(1, 5, 1);
        return new ChildStructure(offset, size, (Block)Blocks.field_150353_l);
    }

    static int calculateDisplacement(int index, int displacement) {
        if (index == 0) {
            return 0;
        }
        int displacementRandom = random.nextInt(3);
        if (displacementRandom == 1) {
            return displacement + 1;
        }
        if (displacementRandom == 2) {
            return displacement - 1;
        }
        return displacement;
    }
}

