/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.structure;

import bassebombecraft.ModConstants;
import bassebombecraft.geom.WorldQuery;
import bassebombecraft.structure.ChildStructure;
import bassebombecraft.structure.CompositeStructure;
import bassebombecraft.structure.Structure;
import bassebombecraft.structure.StructureFactory;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;

public class ParkourStaffStructureFactory
implements StructureFactory {
    static final Block BLOCK_TYPE = Blocks.field_150423_aK;
    static Random random = new Random();
    private BlockPos offset;

    @Override
    public Structure getInstance(boolean isGroundBlock, Block sourceBlock, WorldQuery worldQuery) {
        this.offset = new BlockPos(0, 0, 0);
        CompositeStructure composite = new CompositeStructure();
        for (int counter = 0; counter < 100; ++counter) {
            int randomId = random.nextInt(4);
            composite.add(this.addStructure(randomId));
        }
        return composite;
    }

    Structure addStructure(int randomId) {
        if (randomId == 0) {
            return this.createBlock0x0x3();
        }
        if (randomId == 1) {
            return this.createBlock0x1x2();
        }
        if (randomId == 2) {
            return this.createBlock1x1x2();
        }
        if (randomId == 3) {
            return this.createBlockm1x1x2();
        }
        return this.createPlateau();
    }

    @Override
    public boolean calculateOffsetFromPlayerFeet() {
        return true;
    }

    void updateOffsetWithDelta(int x, int y, int z) {
        this.offset = this.offset.func_177982_a(x, y, z);
    }

    Structure createPlateau() {
        int plateauSize = 2;
        boolean plateau_height = true;
        BlockPos targetOffset = this.offset.func_177982_a(0, 0, 1);
        BlockPos size = new BlockPos(2, 1, 2);
        this.updateOffsetWithDelta(0, 0, 2);
        return new ChildStructure(targetOffset, size, Blocks.field_150325_L);
    }

    Structure createBlock0x0x3() {
        BlockPos targetOffset = this.offset.func_177982_a(0, 0, 4);
        this.updateOffsetWithDelta(0, 0, 4);
        return new ChildStructure(targetOffset, ModConstants.UNITY_BLOCK_SIZE, BLOCK_TYPE);
    }

    Structure createBlock0x1x2() {
        BlockPos targetOffset = this.offset.func_177982_a(0, 1, 3);
        this.updateOffsetWithDelta(0, 1, 3);
        return new ChildStructure(targetOffset, ModConstants.UNITY_BLOCK_SIZE, BLOCK_TYPE);
    }

    Structure createBlock1x1x2() {
        BlockPos targetOffset = this.offset.func_177982_a(1, 1, 3);
        this.updateOffsetWithDelta(1, 1, 3);
        return new ChildStructure(targetOffset, ModConstants.UNITY_BLOCK_SIZE, BLOCK_TYPE);
    }

    Structure createBlockm1x1x2() {
        BlockPos targetOffset = this.offset.func_177982_a(-1, 1, 3);
        this.updateOffsetWithDelta(-1, 1, 3);
        return new ChildStructure(targetOffset, ModConstants.UNITY_BLOCK_SIZE, BLOCK_TYPE);
    }
}

