/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.structure.debug;

import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.WorldQuery;
import bassebombecraft.structure.ChildStructure;
import bassebombecraft.structure.CompositeStructure;
import bassebombecraft.structure.Structure;
import bassebombecraft.structure.StructureFactory;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class DebuggingStructureFactory
implements StructureFactory {
    static final int DEBUGGING_Y_DISPLACEMENT = 20;
    static final Block DEBUGGING_BLOCK_TYPE = Blocks.field_150432_aD;
    StructureFactory factory;

    public DebuggingStructureFactory(StructureFactory factory) {
        this.factory = factory;
    }

    @Override
    public Structure getInstance(boolean isGroundBlock, Block sourceBlock, WorldQuery worldQuery) {
        Structure srcStructure = this.factory.getInstance(isGroundBlock, sourceBlock, worldQuery);
        CompositeStructure composite = new CompositeStructure();
        composite.add(srcStructure);
        composite.add(this.createDebuggingStructure(srcStructure));
        return composite;
    }

    @Override
    public boolean calculateOffsetFromPlayerFeet() {
        return true;
    }

    Structure createDebuggingStructure(Structure srcStructure) {
        if (srcStructure.isComposite()) {
            Structure[] srcChildren;
            CompositeStructure composite = new CompositeStructure();
            for (Structure srcChild : srcChildren = srcStructure.getChildren()) {
                composite.add(this.createDebuggingStructure(srcChild));
            }
            return composite;
        }
        return this.createDebuggingChildStructure(srcStructure);
    }

    Structure createDebuggingChildStructure(Structure srcStructure) {
        BlockDirective offset = new BlockDirective(srcStructure.getOffsetX(), srcStructure.getOffsetY() + 20, srcStructure.getOffsetZ(), DEBUGGING_BLOCK_TYPE);
        BlockDirective size = new BlockDirective(srcStructure.getSizeX(), srcStructure.getSizeY(), srcStructure.getSizeZ(), DEBUGGING_BLOCK_TYPE);
        return new ChildStructure(offset, size, DEBUGGING_BLOCK_TYPE);
    }
}

