/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft;

import bassebombecraft.block.BlockInitializer;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.event.block.DefaultBlockDirectiveRepository;
import bassebombecraft.event.block.ProcessBlockDirectivesEventListener;
import bassebombecraft.event.block.temporary.DefaultTemporaryBlockRepository;
import bassebombecraft.event.block.temporary.TemporaryBlockEventListener;
import bassebombecraft.event.block.temporary.TemporaryBlockRepository;
import bassebombecraft.event.charm.CharmedMobEventListener;
import bassebombecraft.event.charm.CharmedMobsRepository;
import bassebombecraft.event.charm.DefaultCharmedMobsRepository;
import bassebombecraft.event.particle.DefaultParticleRenderingRepository;
import bassebombecraft.event.particle.ParticleRenderingEventListener;
import bassebombecraft.event.particle.ParticleRenderingRepository;
import bassebombecraft.item.ItemInitializer;
import bassebombecraft.projectile.ProjectileInitializer;
import bassebombecraft.server.CommonProxy;
import bassebombecraft.tab.CreativeTabFactory;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(name="BasseBombeCraft", modid="bassebombecraft", version="1.8-1.14", acceptedMinecraftVersions="[1.8]")
public class BassebombeCraft {
    static Logger logger = LogManager.getLogger(BassebombeCraft.class);
    @Mod.Instance(value="bassebombecraft")
    public static BassebombeCraft instance;
    @SidedProxy(clientSide="bassebombecraft.client.ClientProxy", serverSide="bassebombecraft.server.CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTabs modTab;
    CharmedMobsRepository charmedMobsRepository;
    BlockDirectivesRepository blockDirectivesRepository;
    ParticleRenderingRepository particleRepository;
    TemporaryBlockRepository tempBlockRepository;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        this.charmedMobsRepository = DefaultCharmedMobsRepository.getInstance();
        this.blockDirectivesRepository = DefaultBlockDirectiveRepository.getInstance();
        this.tempBlockRepository = DefaultTemporaryBlockRepository.getInstance();
        this.particleRepository = DefaultParticleRenderingRepository.getInstance();
        this.initializeModMetadata(event);
        this.initializeCreativeTab();
        logger.info("Pre-initialized BassebombeCraft");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        logger.info("Staring to initialize BasseBombeCraft");
        ItemInitializer.getInstance().initialize(modTab);
        ProjectileInitializer.getInstance().initialize(this, modTab);
        BlockInitializer.getInstance().initialize(modTab);
        this.initializeEventListeners();
        logger.info("Initialized BasseBombeCraft");
    }

    void initializeModMetadata(FMLPreInitializationEvent event) {
        ModMetadata m = event.getModMetadata();
        m.autogenerated = false;
        m.modId = "BasseBombeCraft";
        m.version = "1.8-1.14";
        m.name = "BasseBombeCraft";
        m.description = "A collection of 40+ magical books, idols and blocks for adventuring and construction. The magic needed by BasseBombe when he plays Minecraft.";
        m.authorList.add("einheriii@gmail.com");
        m.logoFile = "assets/bassebombecraft/logo/logo.png";
        m.url = "http://minecraft.curseforge.com/projects/bassebombecraft";
        m.credits = "Allan & Andreas Thrane Andersen";
    }

    void initializeCreativeTab() {
        modTab = CreativeTabFactory.createCreativeTab("BasseBombeCraft");
    }

    void initializeEventListeners() {
        CharmedMobEventListener mobsEventListener = new CharmedMobEventListener(this.charmedMobsRepository, this.particleRepository);
        MinecraftForge.EVENT_BUS.register((Object)mobsEventListener);
        FMLCommonHandler.instance().bus().register((Object)mobsEventListener);
        ProcessBlockDirectivesEventListener directivesEventListener = new ProcessBlockDirectivesEventListener(this.blockDirectivesRepository, this.particleRepository);
        MinecraftForge.EVENT_BUS.register((Object)directivesEventListener);
        FMLCommonHandler.instance().bus().register((Object)directivesEventListener);
        TemporaryBlockEventListener tempBlockEventListener = new TemporaryBlockEventListener(this.tempBlockRepository, this.blockDirectivesRepository);
        MinecraftForge.EVENT_BUS.register((Object)tempBlockEventListener);
        FMLCommonHandler.instance().bus().register((Object)tempBlockEventListener);
        ParticleRenderingEventListener particleEventListener = new ParticleRenderingEventListener(this.particleRepository);
        MinecraftForge.EVENT_BUS.register((Object)particleEventListener);
        FMLCommonHandler.instance().bus().register((Object)particleEventListener);
        proxy.registerRenderers();
    }

    public CharmedMobsRepository getCharmedMobsRepository() {
        return this.charmedMobsRepository;
    }

    public BlockDirectivesRepository getBlockDirectivesRepository() {
        return this.blockDirectivesRepository;
    }

    public TemporaryBlockRepository getTemporaryBlockRepository() {
        return this.tempBlockRepository;
    }

    public ParticleRenderingRepository getParticleRenderingRepository() {
        return this.particleRepository;
    }

    public static BassebombeCraft getBassebombeCraft() {
        return instance;
    }
}

