/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.block;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.ModConstants;
import bassebombecraft.event.block.temporary.DefaultTemporaryBlock;
import bassebombecraft.event.block.temporary.TemporaryBlockRepository;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.WorldQuery;
import com.google.common.collect.ImmutableMap;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class BlockUtils {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final boolean DONT_HARVEST = false;

    public static void createBlock(BlockDirective blockDirective, WorldQuery worldQuery) {
        if (worldQuery.isWorldAtClientSide()) {
            return;
        }
        BlockPos blockPosition = blockDirective.getBlockPosition();
        Block block = BlockUtils.getBlockFromPosition(blockDirective, worldQuery);
        World world = worldQuery.getWorld();
        if (blockDirective.harvestBlock()) {
            IBlockState blockState = BlockUtils.getBlockStateFromPosition(blockPosition, worldQuery);
            block.func_180657_a(worldQuery.getWorld(), worldQuery.getPlayer(), blockPosition, blockState, ModConstants.NULL_TILE_ENTITY);
        }
        world.func_175656_a(blockPosition, blockDirective.getState());
    }

    public static Block getBlockFromPosition(BlockPos blockPosition, World world) {
        IBlockState blockState = world.func_180495_p(blockPosition);
        return blockState.func_177230_c();
    }

    public static Block getBlockFromPosition(BlockPos blockPosition, WorldQuery worldQuery) {
        World world = worldQuery.getWorld();
        return BlockUtils.getBlockFromPosition(blockPosition, world);
    }

    public static Block getBlockFromPosition(BlockDirective blockDirective, WorldQuery worldQuery) {
        BlockPos blockPosition = blockDirective.getBlockPosition();
        return BlockUtils.getBlockFromPosition(blockPosition, worldQuery);
    }

    public static IBlockState getBlockStateFromPosition(BlockPos blockPosition, WorldQuery worldQuery) {
        World world = worldQuery.getWorld();
        return world.func_180495_p(blockPosition);
    }

    public static IBlockState rotateBlockStateWithFacingProperty(IBlockState sourceState, double orientation) {
        if (orientation == 0.0) {
            return sourceState;
        }
        if (!BlockUtils.hasFacingProperty(sourceState)) {
            return sourceState;
        }
        ImmutableMap properties = sourceState.func_177228_b();
        Comparable facing = sourceState.func_177229_b((IProperty)FACING);
        Comparable value = BlockUtils.calculateFacingProperty(facing, orientation);
        IBlockState rotatedState = sourceState.func_177226_a((IProperty)FACING, value);
        return rotatedState;
    }

    public static Comparable calculateFacingProperty(Comparable sourceFacing, double orientation) {
        if (orientation == 0.0) {
            return sourceFacing;
        }
        if (orientation == 90.0) {
            if (sourceFacing == EnumFacing.SOUTH) {
                return EnumFacing.WEST;
            }
            if (sourceFacing == EnumFacing.WEST) {
                return EnumFacing.NORTH;
            }
            if (sourceFacing == EnumFacing.NORTH) {
                return EnumFacing.EAST;
            }
            if (sourceFacing == EnumFacing.EAST) {
                return EnumFacing.SOUTH;
            }
        }
        if (orientation == 180.0) {
            if (sourceFacing == EnumFacing.SOUTH) {
                return EnumFacing.NORTH;
            }
            if (sourceFacing == EnumFacing.WEST) {
                return EnumFacing.EAST;
            }
            if (sourceFacing == EnumFacing.NORTH) {
                return EnumFacing.SOUTH;
            }
            if (sourceFacing == EnumFacing.EAST) {
                return EnumFacing.WEST;
            }
        }
        if (orientation == 270.0) {
            if (sourceFacing == EnumFacing.SOUTH) {
                return EnumFacing.EAST;
            }
            if (sourceFacing == EnumFacing.WEST) {
                return EnumFacing.SOUTH;
            }
            if (sourceFacing == EnumFacing.NORTH) {
                return EnumFacing.WEST;
            }
            if (sourceFacing == EnumFacing.EAST) {
                return EnumFacing.NORTH;
            }
        }
        return sourceFacing;
    }

    public static boolean hasFacingProperty(IBlockState state) {
        ImmutableMap properties = state.func_177228_b();
        return properties.containsKey((Object)FACING);
    }

    public static boolean containsAirBlocksOnly(Iterable blocks, WorldQuery worldQuery) {
        for (Object blockPos : blocks) {
            BlockPos typedBlockPos = (BlockPos)blockPos;
            Block block = BlockUtils.getBlockFromPosition(typedBlockPos, worldQuery);
            if (block == Blocks.field_150350_a) continue;
            return false;
        }
        return true;
    }

    public static void setTemporaryBlock(World world, BlockPos pos, Block tempBlock, int duration) {
        BlockDirective tempDirective = new BlockDirective(pos, tempBlock, false);
        Block block = BlockUtils.getBlockFromPosition(pos, world);
        BlockDirective orgDirective = new BlockDirective(pos, block, false);
        DefaultTemporaryBlock temporaryBlock = DefaultTemporaryBlock.getInstance(duration, tempDirective, orgDirective);
        TemporaryBlockRepository tempBlockRepository = BassebombeCraft.getBassebombeCraft().getTemporaryBlockRepository();
        tempBlockRepository.add(temporaryBlock);
    }
}

