/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.entity.ai;

import bassebombecraft.entity.ai.EntityAiBuilder;
import bassebombecraft.entity.ai.task.CompanionAttack;
import bassebombecraft.entity.ai.task.FollowClosestPlayer;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearest;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;

public class CharmedMobAiBuilder
implements EntityAiBuilder {
    static final boolean DONT_CALL_FOR_HELP = false;
    static final boolean NEARBY_ONLY = true;
    static final boolean SHOULD_CHECK_SIGHT = true;
    static final double MOVEMENT_SPEED = 1.5;
    static final float MINIMUM_DIST = 6.0f;
    static final float WATCH_DIST = 10.0f;

    @Override
    public void build(EntityLiving entity) {
        entity.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(entity));
        entity.field_70714_bg.func_75776_a(1, (EntityAIBase)new CompanionAttack(entity));
        entity.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest(entity, EntityMob.class, 10.0f));
        entity.field_70714_bg.func_75776_a(3, (EntityAIBase)new FollowClosestPlayer(entity, 6.0f, 1.5));
        entity.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle(entity));
        if (entity instanceof EntityCreature) {
            EntityCreature entityCreature = (EntityCreature)EntityCreature.class.cast(entity);
            entity.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget(entityCreature, false, new Class[0]));
            entity.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget(entityCreature, EntityMob.class, true, true));
        } else {
            entity.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIFindEntityNearest(entity, EntityMob.class));
        }
    }

    @Override
    public void build(EntityLiving entity, EntityLivingBase owner) {
        entity.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(entity));
        entity.field_70714_bg.func_75776_a(1, (EntityAIBase)new CompanionAttack(entity));
        entity.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest(entity, EntityMob.class, 10.0f));
        entity.field_70714_bg.func_75776_a(3, (EntityAIBase)new FollowClosestPlayer(entity, 6.0f, 1.5));
        entity.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle(entity));
        if (entity instanceof EntityCreature) {
            EntityCreature entityCreature = (EntityCreature)EntityCreature.class.cast(entity);
            entity.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget(entityCreature, false, new Class[0]));
            entity.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget(entityCreature, EntityLiving.class, true, true));
        } else {
            entity.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIFindEntityNearest(entity, EntityMob.class));
        }
    }
}

