/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.block;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.geom.BlockDirective;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultBlockDirectiveRepository
implements BlockDirectivesRepository {
    static Logger logger = LogManager.getLogger(BassebombeCraft.class);
    BlockingQueue<BlockDirective> queue = new LinkedBlockingQueue<BlockDirective>();

    @Override
    public void add(BlockDirective directive) {
        if (directive == null) {
            return;
        }
        try {
            this.queue.put(directive);
        }
        catch (InterruptedException e) {
            logger.error("Failed to add block directive: " + directive + " due to exception: " + e);
        }
    }

    @Override
    public void addAll(List<BlockDirective> directives) {
        if (directives == null) {
            return;
        }
        this.queue.addAll(directives);
    }

    @Override
    public boolean containsDirectives() {
        return !this.queue.isEmpty();
    }

    @Override
    public BlockDirective getNext() throws Exception {
        if (this.queue.isEmpty()) {
            return null;
        }
        return this.queue.take();
    }

    public static BlockDirectivesRepository getInstance() {
        return new DefaultBlockDirectiveRepository();
    }
}

