/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.charm;

import bassebombecraft.entity.ai.AiUtils;
import bassebombecraft.event.charm.CharmedMob;
import bassebombecraft.event.charm.CharmedMobsRepository;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.EntityLiving;

public class DefaultCharmedMobsRepository
implements CharmedMobsRepository {
    static final int EFFECT_DURATION = 1000;
    Map<EntityLiving, CharmedMob> charmedMobs = new ConcurrentHashMap<EntityLiving, CharmedMob>();

    @Override
    public void add(EntityLiving entity) {
        CharmedMob charmedMob = new CharmedMob(entity, 1000);
        AiUtils.clearAiTasks(entity);
        AiUtils.buildCharmedMobAi(entity);
        this.charmedMobs.put(entity, charmedMob);
    }

    @Override
    public void remove(EntityLiving entity) {
        if (!this.contains(entity)) {
            return;
        }
        CharmedMob charmedMob = this.charmedMobs.get(entity);
        AiUtils.clearAiTasks(entity);
        entity.field_70714_bg.field_75782_a = charmedMob.getTasks();
        entity.field_70715_bh.field_75782_a = charmedMob.getTargetTasks();
        this.charmedMobs.remove(entity);
    }

    @Override
    public void update(EntityLiving entity) {
        if (!this.contains(entity)) {
            return;
        }
        CharmedMob charmedMob = this.charmedMobs.get(entity);
        charmedMob.update();
        if (charmedMob.isCharmExpired()) {
            this.remove(entity);
        }
    }

    @Override
    public boolean contains(EntityLiving entity) {
        return this.charmedMobs.containsKey(entity);
    }

    public static CharmedMobsRepository getInstance() {
        return new DefaultCharmedMobsRepository();
    }
}

