/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.particle;

import bassebombecraft.event.particle.ParticleRendering;
import bassebombecraft.event.particle.ParticleRenderingRepository;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ParticleRenderingEventListener {
    static final int RENDERING_FREQUENCY = 10;
    int ticksCounter = 0;
    ParticleRenderingRepository repository;
    Random random = new Random();

    public ParticleRenderingEventListener(ParticleRenderingRepository repository) {
        this.repository = repository;
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ++this.ticksCounter;
        this.repository.updateParticleDuration();
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        if (world == null) {
            return;
        }
        if (!world.field_72995_K) {
            return;
        }
        if (this.ticksCounter % 10 != 0) {
            return;
        }
        this.render(world);
    }

    void render(World world) {
        ParticleRendering[] particles;
        for (ParticleRendering particle : particles = this.repository.getParticles()) {
            for (int i = 0; i < particle.getNumber(); ++i) {
                if (this.renderWithCustomColor(particle)) {
                    this.renderParticleWithCustomColor(world, particle);
                    continue;
                }
                this.renderParticle(world, particle);
            }
        }
    }

    boolean renderWithCustomColor(ParticleRendering particle) {
        EnumParticleTypes type = particle.getParticleType();
        return type == EnumParticleTypes.SPELL_MOB;
    }

    void renderParticle(World world, ParticleRendering particle) {
        double speed = particle.getSpeed();
        double d0 = this.calculateRandomSpeed(speed);
        double d1 = this.calculateRandomSpeed(speed);
        double d2 = this.calculateRandomSpeed(speed);
        double x = (double)particle.getPosition().func_177958_n() + 0.5;
        double y = particle.getPosition().func_177956_o() + 1;
        double z = (double)particle.getPosition().func_177952_p() + 0.5;
        world.func_175688_a(particle.getParticleType(), x, y, z, d0, d1, d2, new int[0]);
    }

    void renderParticleWithCustomColor(World world, ParticleRendering particle) {
        float r = particle.getRedColorComponent(this.random);
        float g = particle.getGreenColorComponent(this.random);
        float b = particle.getBlueColorComponent(this.random);
        double x = (double)particle.getPosition().func_177958_n() + 0.5;
        double y = particle.getPosition().func_177956_o() + 1;
        double z = (double)particle.getPosition().func_177952_p() + 0.5;
        world.func_175688_a(particle.getParticleType(), x, y, z, (double)r, (double)g, (double)b, new int[0]);
    }

    double calculateRandomSpeed(double speed) {
        return (this.random.nextDouble() * 2.0 - 1.0) * speed;
    }
}

