/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.geom;

import bassebombecraft.ModConstants;
import bassebombecraft.block.BlockUtils;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.WorldQuery;
import bassebombecraft.player.PlayerDirection;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.structure.Structure;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class GeometryUtils {
    public static final int DEGREES_0 = 0;
    public static final int DEGREES_90 = 90;
    public static final int DEGREES_180 = 180;
    public static final int DEGREES_270 = 270;

    public static List<BlockDirective> captureBlockDirectives(Iterable blockPosSet, WorldQuery worldQuery) {
        ArrayList<BlockDirective> result = new ArrayList<BlockDirective>();
        for (Object blockPos : blockPosSet) {
            BlockPos typedBlockPos = (BlockPos)blockPos;
            Block block = BlockUtils.getBlockFromPosition(typedBlockPos, worldQuery);
            IBlockState blockState = BlockUtils.getBlockStateFromPosition(typedBlockPos, worldQuery);
            BlockDirective directive = new BlockDirective(typedBlockPos, block, false);
            directive.setState(blockState);
            result.add(directive);
        }
        return result;
    }

    public static List<BlockDirective> calculateBlockDirectives(Iterable blockPosSet, Block block, IBlockState blockState) {
        ArrayList<BlockDirective> result = new ArrayList<BlockDirective>();
        for (Object blockPos : blockPosSet) {
            BlockPos typedBlockPos = (BlockPos)blockPos;
            BlockDirective directive = new BlockDirective(typedBlockPos, block, true);
            directive.setState(blockState);
            result.add(directive);
        }
        return result;
    }

    public static List<BlockDirective> rotateCoordinatesAroundYAxis(BlockPos offset, double angle, List<BlockDirective> source) {
        ArrayList<BlockDirective> result = new ArrayList<BlockDirective>();
        AffineTransform transform = AffineTransform.getRotateInstance(Math.toRadians(angle), offset.func_177958_n(), offset.func_177952_p());
        for (BlockDirective sourceDirective : source) {
            double[] rotationPoint = new double[]{sourceDirective.getBlockPosition().func_177958_n(), sourceDirective.getBlockPosition().func_177952_p()};
            transform.transform(rotationPoint, 0, rotationPoint, 0, 1);
            BlockPos RotatedPosition = new BlockPos((int)rotationPoint[0], sourceDirective.getBlockPosition().func_177956_o(), (int)rotationPoint[1]);
            BlockDirective rotatedDirective = new BlockDirective(RotatedPosition, sourceDirective.block);
            IBlockState sourceState = sourceDirective.getState();
            IBlockState rotatedState = BlockUtils.rotateBlockStateWithFacingProperty(sourceState, angle);
            rotatedDirective.setState(rotatedState);
            result.add(rotatedDirective);
        }
        return result;
    }

    public static List<BlockDirective> rotateCoordinatesAroundYAxisAtOrigin(double angle, List<BlockDirective> source) {
        return GeometryUtils.rotateCoordinatesAroundYAxis(ModConstants.ORIGIN_BLOCK_POS, angle, source);
    }

    public static Vec3 rotateUnitVectorAroundYAxisAtOrigin(double angle, Vec3 vector) {
        double originX = 0.0;
        double originZ = 0.0;
        AffineTransform transform = AffineTransform.getRotateInstance(Math.toRadians(angle), originX, originZ);
        double[] rotationPoint = new double[]{vector.field_72450_a, vector.field_72449_c};
        transform.transform(rotationPoint, 0, rotationPoint, 0, 1);
        return new Vec3(rotationPoint[0], vector.field_72448_b, rotationPoint[1]);
    }

    private static List<BlockDirective> calculateBlockDirectivesFromChildStructure(BlockPos offset, PlayerDirection playerDirection, Structure structure) {
        if (structure.isComposite()) {
            return new ArrayList<BlockDirective>();
        }
        BlockPos from = offset.func_177982_a(structure.getOffsetX(), structure.getOffsetY(), structure.getOffsetZ());
        int xTo = structure.getSizeX() - 1;
        int yTo = structure.getSizeY() - 1;
        int zTo = structure.getSizeZ() - 1;
        BlockPos to = from.func_177982_a(xTo, yTo, zTo);
        Iterable blockPosSet = BlockPos.func_177980_a((BlockPos)from, (BlockPos)to);
        List<BlockDirective> directives = GeometryUtils.calculateBlockDirectives(blockPosSet, structure.getBlock(), structure.getBlockState());
        int rotationDegrees = GeometryUtils.calculateDegreesFromPlayerDirection(playerDirection);
        List<BlockDirective> rotatedDirectives = GeometryUtils.rotateCoordinatesAroundYAxis(offset, rotationDegrees, directives);
        return rotatedDirectives;
    }

    public static List<BlockDirective> calculateBlockDirectives(BlockPos offset, PlayerDirection playerDirection, Structure structure) {
        if (!structure.isComposite()) {
            return GeometryUtils.calculateBlockDirectivesFromChildStructure(offset, playerDirection, structure);
        }
        ArrayList<BlockDirective> compositeResult = new ArrayList<BlockDirective>();
        for (Structure child : structure.getChildren()) {
            compositeResult.addAll(GeometryUtils.calculateBlockDirectives(offset, playerDirection, child));
        }
        return compositeResult;
    }

    public static int calculateDegreesFromPlayerDirection(PlayerDirection playerDirection) {
        switch (playerDirection) {
            case South: {
                return 0;
            }
            case West: {
                return 90;
            }
            case North: {
                return 180;
            }
            case East: {
                return 270;
            }
        }
        return 0;
    }

    public static int calculateYOffsetFromBlock(EntityPlayer player, BlockPos blockPosition) {
        int yFeetPosition = PlayerUtils.calculatePlayerFeetPosititionAsInt(player);
        int offset = blockPosition.func_177956_o() - yFeetPosition;
        return offset;
    }

    public static List<BlockDirective> captureRectangle(BlockPos offset, BlockPos size, WorldQuery worldQuery) {
        ArrayList<BlockDirective> result = new ArrayList<BlockDirective>();
        int yCounter = 0;
        while (true) {
            int layerZDelta;
            int layerYDelta;
            int layerXDelta;
            BlockPos to;
            int currentY = yCounter + offset.func_177956_o();
            BlockPos from = new BlockPos(offset.func_177958_n(), currentY, offset.func_177952_p());
            Iterable blockPosSet = BlockPos.func_177980_a((BlockPos)from, (BlockPos)(to = from.func_177982_a(layerXDelta = size.func_177958_n() - 1, layerYDelta = 0, layerZDelta = size.func_177952_p() - 1)));
            if (BlockUtils.containsAirBlocksOnly(blockPosSet, worldQuery)) {
                return result;
            }
            result.addAll(GeometryUtils.captureBlockDirectives(blockPosSet, worldQuery));
            ++yCounter;
        }
    }

    public static List<BlockDirective> translate(BlockPos translationVector, List<BlockDirective> directives) {
        ArrayList<BlockDirective> translated = new ArrayList<BlockDirective>();
        for (BlockDirective directive : directives) {
            BlockDirective translatedDirective = new BlockDirective(directive);
            translatedDirective.translate(translationVector);
            translated.add(translatedDirective);
        }
        return translated;
    }

    public static List<BlockPos> calculateSpiral(int maxX, int maxY) {
        ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
        int x = 0;
        int y = 0;
        int dx = 0;
        int dy = -1;
        int t = Math.max(maxX, maxY);
        int maxI = t * t;
        for (int i = 0; i < maxI; ++i) {
            if (-maxX / 2 <= x && x <= maxX / 2 && -maxY / 2 <= y && y <= maxY / 2) {
                BlockPos pos = new BlockPos(x, 0, y);
                coords.add(pos);
            }
            if (x == y || x < 0 && x == -y || x > 0 && x == 1 - y) {
                t = dx;
                dx = -dy;
                dy = t;
            }
            x += dx;
            y += dy;
        }
        return coords;
    }

    public static BlockPos locateGroundBlockPos(BlockPos target, int iterations, World world) {
        if (iterations == 0) {
            return target;
        }
        if (iterations < 0) {
            return target;
        }
        int newIterations = iterations - 1;
        if (!GeometryUtils.isUsefullAirTypeBlock(target.func_177984_a(), world)) {
            return GeometryUtils.locateGroundBlockPos(target.func_177984_a(), newIterations, world);
        }
        if (!GeometryUtils.isUsefulGroundBlock(target, world)) {
            return GeometryUtils.locateGroundBlockPos(target.func_177977_b(), newIterations, world);
        }
        return target;
    }

    static boolean isUsefulGroundBlock(BlockPos target, World world) {
        Block candidateBlock = BlockUtils.getBlockFromPosition(target, world);
        Material material = candidateBlock.func_149688_o();
        return material.func_76220_a();
    }

    static boolean isUsefullAirTypeBlock(BlockPos target, World world) {
        Block candidateBlock = BlockUtils.getBlockFromPosition(target, world);
        Material material = candidateBlock.func_149688_o();
        return !material.func_76220_a();
    }

    public static BlockDirective createFlowerDirective(BlockPos position, Random random) {
        int flowerType = random.nextInt(6);
        switch (flowerType) {
            case 0: {
                BlockDirective yellow = new BlockDirective(position, (Block)Blocks.field_150327_N, false);
                return yellow;
            }
        }
        BlockDirective red = new BlockDirective(position, (Block)Blocks.field_150328_O, false);
        red.setState(GeometryUtils.selectRedFlowerType(random));
        return red;
    }

    static IBlockState selectRedFlowerType(Random random) {
        int flowerType = random.nextInt(7);
        switch (flowerType) {
            case 0: {
                return Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.ALLIUM);
            }
            case 1: {
                return Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.BLUE_ORCHID);
            }
            case 2: {
                return Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.HOUSTONIA);
            }
            case 3: {
                return Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.ORANGE_TULIP);
            }
            case 4: {
                return Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.OXEYE_DAISY);
            }
            case 5: {
                return Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.PINK_TULIP);
            }
            case 6: {
                return Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.POPPY);
            }
            case 7: {
                return Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.WHITE_TULIP);
            }
        }
        return Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.POPPY);
    }
}

