/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item;

import bassebombecraft.block.BlockUtils;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.geom.WorldQueryImpl;
import bassebombecraft.player.PlayerDirection;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.structure.Structure;
import bassebombecraft.structure.StructureFactory;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class GenericStaff
extends Item {
    private StructureFactory structureFactory;

    public GenericStaff(String itemName, StructureFactory factory) {
        this.func_77655_b(itemName);
        this.structureFactory = factory;
        this.registerForRendering(this);
    }

    void registerForRendering(Item item) {
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        ModelResourceLocation location = new ModelResourceLocation("bassebombecraft:" + this.func_77658_a().substring(5), "inventory");
        renderItem.func_175037_a().func_178086_a(item, 0, location);
    }

    public boolean canHarvestBlock(Block par1Block, ItemStack itemStack) {
        return true;
    }

    public boolean func_77644_a(ItemStack itemStack, EntityLivingBase entityTarget, EntityLivingBase entityUser) {
        return false;
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.apply(pos, playerIn);
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        return super.func_77659_a(itemStackIn, worldIn, playerIn);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return super.onLeftClickEntity(stack, player, entity);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos blockPosition, EntityPlayer player) {
        return super.onBlockStartBreak(itemstack, blockPosition, player);
    }

    boolean apply(BlockPos blockPosition, EntityPlayer player) {
        World world = player.func_130014_f_();
        Block block = BlockUtils.getBlockFromPosition(blockPosition, world);
        boolean HitLiquids = false;
        MovingObjectPosition pos = this.func_77621_a(world, player, false);
        if (pos == null) {
            return false;
        }
        if (pos.func_178782_a().func_177958_n() != blockPosition.func_177958_n()) {
            return false;
        }
        if (pos.func_178782_a().func_177956_o() != blockPosition.func_177956_o()) {
            return false;
        }
        if (pos.func_178782_a().func_177952_p() != blockPosition.func_177952_p()) {
            return false;
        }
        boolean isGroundBlock = PlayerUtils.isBelowPlayerYPosition(blockPosition.func_177956_o(), player);
        PlayerDirection playerDirection = PlayerUtils.getPlayerDirection(player);
        WorldQueryImpl worldQuery = new WorldQueryImpl(player, blockPosition);
        Structure structure = this.structureFactory.getInstance(isGroundBlock, block, worldQuery);
        int yOffset = PlayerUtils.calculatePlayerFeetPosititionAsInt(player);
        BlockPos offset = new BlockPos(blockPosition.func_177958_n(), yOffset, blockPosition.func_177952_p());
        List<BlockDirective> directives = GeometryUtils.calculateBlockDirectives(offset, playerDirection, structure);
        for (BlockDirective blockDirective : directives) {
            BlockUtils.createBlock(blockDirective, worldQuery);
        }
        return true;
    }
}

