/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.structure;

import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.WorldQuery;
import bassebombecraft.structure.ChildStructure;
import bassebombecraft.structure.CompositeStructure;
import bassebombecraft.structure.Structure;
import bassebombecraft.structure.StructureFactory;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class GardenStructureFactory
implements StructureFactory {
    static Random random = new Random();
    static Structure aboveGroundRoom = GardenStructureFactory.createAboveGroundRoom();
    static Structure enclosure = GardenStructureFactory.createEnclosure();
    static Structure flowerBed = GardenStructureFactory.createVegetables();

    @Override
    public Structure getInstance(boolean isGroundBlock, Block sourceBlock, WorldQuery worldQuery) {
        if (isGroundBlock) {
            return GardenStructureFactory.createEnclosure();
        }
        return flowerBed;
    }

    @Override
    public boolean calculateOffsetFromPlayerFeet() {
        return true;
    }

    static Structure createAboveGroundRoom() {
        BlockDirective offset = new BlockDirective(0, 0, 0);
        BlockDirective size = new BlockDirective(2, 1, 6);
        return new ChildStructure(offset, size, Blocks.field_150458_ak);
    }

    static Structure createEnclosure() {
        CompositeStructure composite = new CompositeStructure();
        BlockDirective offset = new BlockDirective(1, 0, 0);
        BlockDirective size = new BlockDirective(4, 2, 1);
        composite.add(new ChildStructure(offset, size, (Block)Blocks.field_150361_u));
        offset = new BlockDirective(-5, 0, 0);
        size = new BlockDirective(4, 2, 1);
        composite.add(new ChildStructure(offset, size, (Block)Blocks.field_150361_u));
        offset = new BlockDirective(1, 2, 0);
        size = new BlockDirective(1, 1, 1);
        composite.add(new ChildStructure(offset, size, (Block)Blocks.field_150362_t));
        offset = new BlockDirective(-2, 2, 0);
        size = new BlockDirective(1, 1, 1);
        composite.add(new ChildStructure(offset, size, (Block)Blocks.field_150362_t));
        offset = new BlockDirective(-1, 3, 0);
        size = new BlockDirective(2, 1, 1);
        composite.add(new ChildStructure(offset, size, (Block)Blocks.field_150362_t));
        offset = new BlockDirective(4, 0, 1);
        size = new BlockDirective(1, 2, 9);
        composite.add(new ChildStructure(offset, size, (Block)Blocks.field_150361_u));
        offset = new BlockDirective(-5, 0, 1);
        size = new BlockDirective(1, 2, 9);
        composite.add(new ChildStructure(offset, size, (Block)Blocks.field_150361_u));
        offset = new BlockDirective(-5, 0, 10);
        size = new BlockDirective(10, 2, 1);
        composite.add(new ChildStructure(offset, size, (Block)Blocks.field_150361_u));
        offset = new BlockDirective(-3, 0, 4);
        size = new BlockDirective(6, 1, 6);
        composite.add(new ChildStructure(offset, size, GardenStructureFactory.calculateFlower()));
        offset = new BlockDirective(-1, -1, 0);
        size = new BlockDirective(2, 1, 4);
        composite.add(new ChildStructure(offset, size, Blocks.field_150322_A));
        return composite;
    }

    static Block calculateFlower() {
        int flowerId = random.nextInt(2);
        if (flowerId == 0) {
            return Blocks.field_150328_O;
        }
        if (flowerId == 1) {
            return Blocks.field_150327_N;
        }
        if (flowerId == 1) {
            return Blocks.field_150327_N;
        }
        return Blocks.field_150375_by;
    }

    static Structure createVegetables() {
        CompositeStructure composite = new CompositeStructure();
        BlockDirective offset = new BlockDirective(-4, 0, 0);
        BlockDirective size = new BlockDirective(2, 1, 8);
        composite.add(new ChildStructure(offset, size, Blocks.field_150458_ak));
        offset = new BlockDirective(-4, 0, 0);
        size = new BlockDirective(2, 2, 8);
        composite.add(new ChildStructure(offset, size, Blocks.field_150459_bM));
        offset = new BlockDirective(0, 0, 0);
        size = new BlockDirective(2, 1, 8);
        composite.add(new ChildStructure(offset, size, Blocks.field_150458_ak));
        offset = new BlockDirective(0, 0, 0);
        size = new BlockDirective(2, 2, 8);
        composite.add(new ChildStructure(offset, size, Blocks.field_150469_bN));
        offset = new BlockDirective(-2, -1, 0);
        size = new BlockDirective(2, 1, 8);
        composite.add(new ChildStructure(offset, size, Blocks.field_150322_A));
        offset = new BlockDirective(-5, 0, 0);
        size = new BlockDirective(1, 1, 9);
        composite.add(new ChildStructure(offset, size, Blocks.field_180407_aO));
        offset = new BlockDirective(2, 0, 0);
        size = new BlockDirective(1, 1, 9);
        composite.add(new ChildStructure(offset, size, Blocks.field_180407_aO));
        offset = new BlockDirective(-4, 0, 8);
        size = new BlockDirective(6, 1, 1);
        composite.add(new ChildStructure(offset, size, Blocks.field_180407_aO));
        return composite;
    }
}

