/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.biomes;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.class_1143;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3864;
import net.minecraft.class_4761;
import net.minecraft.class_4763;
import net.minecraft.class_4967;
import net.minecraft.class_4968;
import net.minecraft.class_5312;
import net.minecraft.class_5463;
import net.minecraft.class_5464;
import net.minecraft.class_5470;
import net.minecraft.class_5471;
import net.minecraft.class_5483;
import net.minecraft.class_5485;
import paulevs.betternether.MHelper;
import paulevs.betternether.config.Config;

public class BiomeDefinition {
    private final List<class_5312<?, ?>> structures = Lists.newArrayList();
    private final List<FeatureInfo> features = Lists.newArrayList();
    private final List<SpawnInfo> mobs = Lists.newArrayList();
    private class_4761 particleConfig;
    private class_4967 additions;
    private class_4968 mood;
    private class_3414 music;
    private class_3414 loop;
    private int waterFogColor = 329011;
    private int waterColor = 4159204;
    private int fogColor = 0x330808;
    private boolean defaultOres = true;
    private boolean defaultMobs = true;
    private boolean defaultFeatures = true;
    private boolean defaultStructureFeatures = true;
    private boolean stalactites = true;
    private boolean bnStructures = true;
    private final class_2960 id;

    public BiomeDefinition(String name) {
        this.id = new class_2960("betternether", name.replace(' ', '_').toLowerCase());
    }

    public BiomeDefinition(class_2960 id) {
        this.id = id;
    }

    public BiomeDefinition setStalactites(boolean value) {
        this.stalactites = value;
        return this;
    }

    public BiomeDefinition setBNStructures(boolean value) {
        this.bnStructures = value;
        return this;
    }

    public BiomeDefinition setDefaultOres(boolean value) {
        this.defaultOres = value;
        return this;
    }

    public BiomeDefinition setDefaultStructureFeatures(boolean value) {
        this.defaultStructureFeatures = value;
        return this;
    }

    public BiomeDefinition setDefaultFeatures(boolean value) {
        this.defaultFeatures = value;
        return this;
    }

    public BiomeDefinition setDefaultMobs(boolean value) {
        this.defaultMobs = value;
        return this;
    }

    public BiomeDefinition setParticleConfig(class_4761 config) {
        this.particleConfig = config;
        return this;
    }

    public BiomeDefinition addMobSpawn(class_1299<?> type, int weight, int minGroupSize, int maxGroupSize) {
        class_2960 eID = class_2378.field_11145.method_10221(type);
        if (eID != class_2378.field_11145.method_10137()) {
            String path = "generator.biome." + this.id.method_12836() + "." + this.id.method_12832() + ".mobs." + eID.method_12836() + "." + eID.method_12832();
            SpawnInfo info = new SpawnInfo();
            info.type = type;
            info.weight = Config.getInt(path, "weight", weight);
            info.minGroupSize = Config.getInt(path, "min_group_size", minGroupSize);
            info.maxGroupSize = Config.getInt(path, "max_group_size", maxGroupSize);
            this.mobs.add(info);
        }
        return this;
    }

    public BiomeDefinition addStructureFeature(class_5312<?, ?> feature) {
        System.out.println("Structure " + feature);
        this.structures.add(feature);
        return this;
    }

    public BiomeDefinition addFeature(class_2893.class_2895 featureStep, class_2975<?, ?> feature) {
        FeatureInfo info = new FeatureInfo();
        info.featureStep = featureStep;
        info.feature = feature;
        this.features.add(info);
        return this;
    }

    public BiomeDefinition setFogColor(int r, int g, int b) {
        String path = "generator.biome." + this.id.method_12836() + "." + this.id.method_12832() + ".fog_color";
        r = class_3532.method_15340((int)Config.getInt(path, "red", r), (int)0, (int)255);
        g = class_3532.method_15340((int)Config.getInt(path, "green", g), (int)0, (int)255);
        b = class_3532.method_15340((int)Config.getInt(path, "blue", b), (int)0, (int)255);
        this.fogColor = MHelper.color(r, g, b);
        return this;
    }

    public BiomeDefinition setWaterColor(int r, int g, int b) {
        String path = "generator.biome." + this.id.method_12836() + "." + this.id.method_12832() + ".water_color";
        r = class_3532.method_15340((int)Config.getInt(path, "red", r), (int)0, (int)255);
        g = class_3532.method_15340((int)Config.getInt(path, "green", g), (int)0, (int)255);
        b = class_3532.method_15340((int)Config.getInt(path, "blue", b), (int)0, (int)255);
        this.waterColor = MHelper.color(r, g, b);
        return this;
    }

    public BiomeDefinition setWaterFogColor(int r, int g, int b) {
        String path = "generator.biome." + this.id.method_12836() + "." + this.id.method_12832() + ".water_fog_color";
        r = class_3532.method_15340((int)Config.getInt(path, "red", r), (int)0, (int)255);
        g = class_3532.method_15340((int)Config.getInt(path, "green", g), (int)0, (int)255);
        b = class_3532.method_15340((int)Config.getInt(path, "blue", b), (int)0, (int)255);
        this.waterFogColor = MHelper.color(r, g, b);
        return this;
    }

    public BiomeDefinition setLoop(class_3414 loop) {
        this.loop = loop;
        return this;
    }

    public BiomeDefinition setMood(class_3414 mood) {
        this.mood = new class_4968(mood, 6000, 8, 2.0);
        return this;
    }

    public BiomeDefinition setAdditions(class_3414 additions) {
        this.additions = new class_4967(additions, 0.0111);
        return this;
    }

    public BiomeDefinition setMusic(class_3414 music) {
        this.music = music;
        return this;
    }

    public class_1959 build() {
        class_5483.class_5496 spawnSettings = new class_5483.class_5496();
        class_5485.class_5495 generationSettings = new class_5485.class_5495();
        class_4763.class_4764 effects = new class_4763.class_4764();
        if (this.defaultMobs) {
            this.addDefaultMobs(spawnSettings);
        }
        this.mobs.forEach(spawn -> spawnSettings.method_31011(spawn.type.method_5891(), new class_5483.class_1964(spawn.type, spawn.weight, spawn.minGroupSize, spawn.maxGroupSize)));
        generationSettings.method_30996(class_5471.field_26332);
        this.structures.forEach(structure -> generationSettings.method_30995(structure));
        this.features.forEach(info -> generationSettings.method_30992(info.featureStep, info.feature));
        if (this.defaultOres) {
            class_3864.method_24382((class_5485.class_5495)generationSettings);
        }
        if (this.defaultStructureFeatures) {
            this.addDefaultStructures(generationSettings);
        }
        if (this.defaultFeatures) {
            this.addDefaultFeatures(generationSettings);
        }
        effects.method_30820(this.fogColor).method_24395(this.waterColor).method_24397(this.waterFogColor).method_24392(this.fogColor);
        if (this.loop != null) {
            effects.method_24942(this.loop);
        }
        if (this.mood != null) {
            effects.method_24943(this.mood);
        }
        if (this.additions != null) {
            effects.method_24944(this.additions);
        }
        if (this.particleConfig != null) {
            effects.method_24393(this.particleConfig);
        }
        effects.method_27346(class_1143.method_27283((class_3414)(this.music != null ? this.music : class_3417.field_23794)));
        return new class_1959.class_1960().method_8735(class_1959.class_1963.field_9384).method_8738(class_1959.class_1961.field_9366).method_8740(0.1f).method_8743(0.2f).method_8747(2.0f).method_8727(0.0f).method_24379(effects.method_24391()).method_30974(spawnSettings.method_31007()).method_30973(generationSettings.method_30987()).method_30972();
    }

    private void addDefaultStructures(class_5485.class_5495 generationSettings) {
        generationSettings.method_30995(class_5470.field_26291);
        generationSettings.method_30995(class_5470.field_26306);
        generationSettings.method_30995(class_5470.field_26310);
        generationSettings.method_30991(class_2893.class_2894.field_13169, class_5463.field_25947);
        generationSettings.method_30992(class_2893.class_2895.field_13178, class_5464.field_26003);
    }

    private void addDefaultFeatures(class_5485.class_5495 generationSettings) {
        generationSettings.method_30992(class_2893.class_2895.field_13177, class_5464.field_26007);
        generationSettings.method_30992(class_2893.class_2895.field_13177, class_5464.field_26014);
        generationSettings.method_30992(class_2893.class_2895.field_13177, class_5464.field_26015);
        generationSettings.method_30992(class_2893.class_2895.field_13177, class_5464.field_26127);
        generationSettings.method_30992(class_2893.class_2895.field_13177, class_5464.field_26128);
        generationSettings.method_30992(class_2893.class_2895.field_13177, class_5464.field_25996);
        generationSettings.method_30992(class_2893.class_2895.field_13177, class_5464.field_25997);
        generationSettings.method_30992(class_2893.class_2895.field_13177, class_5464.field_26059);
        generationSettings.method_30992(class_2893.class_2895.field_13177, class_5464.field_26005);
    }

    private void addDefaultMobs(class_5483.class_5496 spawnSettings) {
        spawnSettings.method_31011(class_1311.field_6302, new class_5483.class_1964(class_1299.field_6107, 50, 4, 4));
        spawnSettings.method_31011(class_1311.field_6302, new class_5483.class_1964(class_1299.field_6050, 100, 4, 4));
        spawnSettings.method_31011(class_1311.field_6302, new class_5483.class_1964(class_1299.field_6102, 2, 4, 4));
        spawnSettings.method_31011(class_1311.field_6302, new class_5483.class_1964(class_1299.field_6091, 1, 4, 4));
        spawnSettings.method_31011(class_1311.field_6302, new class_5483.class_1964(class_1299.field_22281, 15, 4, 4));
        spawnSettings.method_31011(class_1311.field_6294, new class_5483.class_1964(class_1299.field_23214, 60, 1, 2));
    }

    public class_2960 getID() {
        return this.id;
    }

    public boolean hasStalactites() {
        return this.stalactites;
    }

    public boolean hasBNStructures() {
        return this.bnStructures;
    }

    private static final class FeatureInfo {
        class_2893.class_2895 featureStep;
        class_2975<?, ?> feature;

        private FeatureInfo() {
        }
    }

    private static final class SpawnInfo {
        class_1299<?> type;
        int weight;
        int minGroupSize;
        int maxGroupSize;

        private SpawnInfo() {
        }
    }
}

