/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.blockentities.render;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.HashMap;
import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2618;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4732;
import net.minecraft.class_4737;
import net.minecraft.class_4739;
import net.minecraft.class_630;
import net.minecraft.class_824;
import net.minecraft.class_827;
import paulevs.betternether.blockentities.BNChestBlockEntity;
import paulevs.betternether.blocks.BNChest;
import paulevs.betternether.registry.BlocksRegistry;

public class BNChestBlockEntityRenderer
extends class_827<BNChestBlockEntity> {
    private static final HashMap<Integer, class_1921[]> LAYERS = Maps.newHashMap();
    private static class_1921[] defaultLayer = new class_1921[]{class_1921.method_23572((class_2960)new class_2960("betternether", "entity/chest/normal.png")), class_1921.method_23572((class_2960)new class_2960("betternether", "entity/chest/normal_left.png")), class_1921.method_23572((class_2960)new class_2960("betternether", "entity/chest/normal_right.png"))};
    private static final int ID_NORMAL = 0;
    private static final int ID_LEFT = 1;
    private static final int ID_RIGHT = 2;
    private final class_630 partA;
    private final class_630 partC = new class_630(64, 64, 0, 19);
    private final class_630 partB;
    private final class_630 partRightA;
    private final class_630 partRightC;
    private final class_630 partRightB;
    private final class_630 partLeftA;
    private final class_630 partLeftC;
    private final class_630 partLeftB;

    public BNChestBlockEntityRenderer(class_824 blockEntityRenderDispatcher) {
        super(blockEntityRenderDispatcher);
        this.partC.method_2856(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f, 0.0f);
        this.partA = new class_630(64, 64, 0, 0);
        this.partA.method_2856(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f, 0.0f);
        this.partA.field_3656 = 9.0f;
        this.partA.field_3655 = 1.0f;
        this.partB = new class_630(64, 64, 0, 0);
        this.partB.method_2856(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f, 0.0f);
        this.partB.field_3656 = 8.0f;
        this.partRightC = new class_630(64, 64, 0, 19);
        this.partRightC.method_2856(1.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f, 0.0f);
        this.partRightA = new class_630(64, 64, 0, 0);
        this.partRightA.method_2856(1.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f, 0.0f);
        this.partRightA.field_3656 = 9.0f;
        this.partRightA.field_3655 = 1.0f;
        this.partRightB = new class_630(64, 64, 0, 0);
        this.partRightB.method_2856(15.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f, 0.0f);
        this.partRightB.field_3656 = 8.0f;
        this.partLeftC = new class_630(64, 64, 0, 19);
        this.partLeftC.method_2856(0.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f, 0.0f);
        this.partLeftA = new class_630(64, 64, 0, 0);
        this.partLeftA.method_2856(0.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f, 0.0f);
        this.partLeftA.field_3656 = 9.0f;
        this.partLeftA.field_3655 = 1.0f;
        this.partLeftB = new class_630(64, 64, 0, 0);
        this.partLeftB.method_2856(0.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f, 0.0f);
        this.partLeftB.field_3656 = 8.0f;
    }

    public void render(BNChestBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_1937 world = entity.method_10997();
        boolean worldExists = world != null;
        class_2680 blockState = worldExists ? entity.method_11010() : (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)class_2350.field_11035);
        class_2745 chestType = blockState.method_28498((class_2769)class_2281.field_10770) ? (class_2745)blockState.method_11654((class_2769)class_2281.field_10770) : class_2745.field_12569;
        class_2248 block = blockState.method_26204();
        if (block instanceof class_4739) {
            class_4739 abstractChestBlock = (class_4739)block;
            boolean isDouble = chestType != class_2745.field_12569;
            float f = ((class_2350)blockState.method_11654((class_2769)class_2281.field_10768)).method_10144();
            matrices.method_22903();
            matrices.method_22904(0.5, 0.5, 0.5);
            matrices.method_22907(class_1160.field_20705.method_23214(-f));
            matrices.method_22904(-0.5, -0.5, -0.5);
            class_4732.class_4734 propertySource = worldExists ? abstractChestBlock.method_24167(blockState, world, entity.method_11016(), true) : class_4732.class_3923::method_24174;
            float pitch = ((Float2FloatFunction)propertySource.apply(class_2281.method_24166((class_2618)entity))).get(tickDelta);
            pitch = 1.0f - pitch;
            pitch = 1.0f - pitch * pitch * pitch;
            int blockLight = ((Int2IntFunction)propertySource.apply((class_4732.class_3923)new class_4737())).applyAsInt(light);
            class_4588 vertexConsumer = BNChestBlockEntityRenderer.getConsumer(vertexConsumers, block, chestType);
            if (isDouble) {
                if (chestType == class_2745.field_12574) {
                    this.renderParts(matrices, vertexConsumer, this.partLeftA, this.partLeftB, this.partLeftC, pitch, blockLight, overlay);
                } else {
                    this.renderParts(matrices, vertexConsumer, this.partRightA, this.partRightB, this.partRightC, pitch, blockLight, overlay);
                }
            } else {
                this.renderParts(matrices, vertexConsumer, this.partA, this.partB, this.partC, pitch, blockLight, overlay);
            }
            matrices.method_22909();
        }
    }

    private void renderParts(class_4587 matrices, class_4588 vertices, class_630 modelPart, class_630 modelPart2, class_630 modelPart3, float pitch, int light, int overlay) {
        modelPart2.field_3654 = modelPart.field_3654 = -(pitch * 1.5707964f);
        modelPart.method_22698(matrices, vertices, light, overlay);
        modelPart2.method_22698(matrices, vertices, light, overlay);
        modelPart3.method_22698(matrices, vertices, light, overlay);
    }

    private static class_1921 getChestTexture(class_2745 type, class_1921[] layers) {
        switch (type) {
            case field_12574: {
                return layers[1];
            }
            case field_12571: {
                return layers[2];
            }
        }
        return layers[0];
    }

    public static class_4588 getConsumer(class_4597 provider, class_2248 block, class_2745 chestType) {
        class_1921[] layers = LAYERS.getOrDefault(class_2248.method_9507((class_2680)block.method_9564()), defaultLayer);
        return provider.getBuffer(BNChestBlockEntityRenderer.getChestTexture(chestType, layers));
    }

    static {
        BlocksRegistry.getPossibleBlocks().forEach(name -> {
            class_2248 block = (class_2248)class_2378.field_11146.method_10223(new class_2960("betternether", name));
            if (block instanceof BNChest) {
                LAYERS.put(class_2248.method_9507((class_2680)block.method_9564()), new class_1921[]{class_1921.method_23572((class_2960)new class_2960("betternether", "textures/entity/chest/" + name + ".png")), class_1921.method_23572((class_2960)new class_2960("betternether", "textures/entity/chest/" + name + "_left.png")), class_1921.method_23572((class_2960)new class_2960("betternether", "textures/entity/chest/" + name + "_right.png"))});
            }
        });
    }
}

