/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public class Config {
    private static JsonObject config;
    private static boolean rewrite;

    private static void load() {
        if (config == null) {
            File file = Config.getFolder();
            if (!file.exists()) {
                file.mkdirs();
            }
            if ((file = Config.getFile()).exists()) {
                Gson gson = new Gson();
                try {
                    FileReader reader = new FileReader(file);
                    config = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                    if (config == null) {
                        config = new JsonObject();
                        rewrite = true;
                    } else {
                        boolean rewrite = Config.getBooleanLoad("config", "rewrite_on_version_update", true);
                        if (rewrite) {
                            ModContainer mod = (ModContainer)FabricLoader.getInstance().getModContainer("betternether").get();
                            String versionActual = mod.getMetadata().getVersion().getFriendlyString();
                            String version = Config.getStringLoad("config", "mod_version");
                            if (!version.equals(versionActual) || version.equals("${version}")) {
                                config = new JsonObject();
                                rewrite = true;
                                Config.setStringLoad("config", "mod_version", versionActual);
                            }
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    config = new JsonObject();
                    rewrite = true;
                }
            } else {
                config = new JsonObject();
                rewrite = true;
            }
        }
    }

    public static void save() {
        if (rewrite) {
            File file = Config.getFolder();
            if (!file.exists()) {
                file.mkdirs();
            }
            file = Config.getFile();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try {
                FileWriter writer = new FileWriter(file);
                String gstring = gson.toJson((JsonElement)config);
                writer.write(gstring);
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static File getFile() {
        return new File(String.format("./config/%s.json", "betternether"));
    }

    private static File getFolder() {
        return new File("./config/");
    }

    public static boolean getBoolean(String groups, String name, boolean def) {
        Config.load();
        name = name + "[def: " + def + "]";
        JsonObject group = Config.getGroup(groups);
        JsonElement element = group.get(name);
        if (element != null) {
            return element.getAsBoolean();
        }
        group.addProperty(name, Boolean.valueOf(def));
        rewrite = true;
        return def;
    }

    private static boolean getBooleanLoad(String groups, String name, boolean def) {
        name = name + "[def: " + def + "]";
        JsonObject group = Config.getGroup(groups);
        JsonElement element = group.get(name);
        if (element != null) {
            return element.getAsBoolean();
        }
        group.addProperty(name, Boolean.valueOf(def));
        rewrite = true;
        return def;
    }

    private static String getStringLoad(String groups, String name) {
        JsonObject group = Config.getGroup(groups);
        JsonElement element = group.get(name);
        if (element != null) {
            return element.getAsString();
        }
        return "";
    }

    public static void setBoolean(String groups, String name, boolean def, boolean value) {
        name = name + "[def: " + def + "]";
        JsonObject group = Config.getGroup(groups);
        group.addProperty(name, Boolean.valueOf(value));
        rewrite = true;
    }

    public static float getFloat(String groups, String name, float def) {
        Config.load();
        name = name + "[def: " + def + "]";
        JsonObject group = Config.getGroup(groups);
        JsonElement element = group.get(name);
        if (element != null) {
            return element.getAsFloat();
        }
        group.addProperty(name, (Number)Float.valueOf(def));
        rewrite = true;
        return def;
    }

    public static void setFloat(String groups, String name, float def, float value) {
        name = name + "[def: " + def + "]";
        JsonObject group = Config.getGroup(groups);
        group.addProperty(name, (Number)Float.valueOf(value));
        rewrite = true;
    }

    public static int getInt(String groups, String name, int def) {
        Config.load();
        name = name + "[def: " + def + "]";
        JsonObject group = Config.getGroup(groups);
        JsonElement element = group.get(name);
        if (element != null) {
            return element.getAsInt();
        }
        group.addProperty(name, (Number)def);
        rewrite = true;
        return def;
    }

    public static String getString(String groups, String name, String def) {
        Config.load();
        name = name + "[def: " + def + "]";
        JsonObject group = Config.getGroup(groups);
        JsonElement element = group.get(name);
        if (element != null) {
            return element.getAsString();
        }
        group.addProperty(name, def);
        rewrite = true;
        return def;
    }

    public static void setInt(String groups, String name, int def, int value) {
        name = name + "[def: " + def + "]";
        JsonObject group = Config.getGroup(groups);
        group.addProperty(name, (Number)value);
        rewrite = true;
    }

    public static void setStringLoad(String groups, String name, String value) {
        JsonObject group = Config.getGroup(groups);
        group.addProperty(name, value);
    }

    public static String[] getStringArray(String groups, String name, String[] def) {
        Config.load();
        JsonObject group = Config.getGroup(groups);
        JsonElement element = group.get(name);
        if (element != null) {
            return Config.toStringArray(element.getAsJsonArray());
        }
        group.add(name, (JsonElement)Config.toJsonArray(def));
        rewrite = true;
        return def;
    }

    private static String[] toStringArray(JsonArray array) {
        Config.load();
        String[] result = new String[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            result[i] = array.get(i).getAsString();
        }
        return result;
    }

    private static JsonArray toJsonArray(String[] array) {
        Config.load();
        JsonArray result = new JsonArray();
        for (String s : array) {
            result.add(s);
        }
        return result;
    }

    public static JsonObject getGroup(String groups) {
        String[] groupsArr;
        JsonObject obj = config;
        for (String group : groupsArr = groups.split("\\.")) {
            JsonObject jGroup = obj.getAsJsonObject(group);
            if (jGroup == null) {
                jGroup = new JsonObject();
                obj.add(group, (JsonElement)jGroup);
            }
            obj = jGroup;
        }
        return obj;
    }

    public static List<String> getBaseGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        Iterator<Map.Entry> iterator = config.entrySet().iterator();
        iterator.forEachRemaining(element -> groups.add((String)element.getKey()));
        return groups;
    }

    public static List<Map.Entry<String, JsonElement>> getGroupMembers(JsonObject group) {
        ArrayList<Map.Entry<String, JsonElement>> result = new ArrayList<Map.Entry<String, JsonElement>>();
        result.addAll(group.entrySet());
        return result;
    }

    public static void markToSave() {
        rewrite = true;
    }

    static {
        rewrite = false;
    }
}

