/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.entity.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.class_1297;
import net.minecraft.class_3879;
import net.minecraft.class_4592;
import net.minecraft.class_630;
import paulevs.betternether.entity.EntityNaga;

public class ModelNaga
extends class_4592<EntityNaga> {
    public class_630 head;
    public class_630 body;
    public class_630[] tail;
    public class_630[] spikes;
    private float pitch;
    private float maxAngle = 0.1f;

    public ModelNaga() {
        this.field_17139 = 64;
        this.field_17138 = 64;
        this.head = new class_630((class_3879)this, 0, 0);
        this.head.method_2844(-5.0f, -10.0f, -7.0f, 10.0f, 10.0f, 10.0f);
        this.head.method_2851(0.0f, -9.0f, 0.0f);
        this.body = new class_630((class_3879)this, 40, 0);
        this.body.method_2844(-2.0f, 0.0f, -1.0f, 4.0f, 20.0f, 2.0f);
        this.body.method_2850(0, 20);
        this.body.method_2844(-5.0f, 3.0f, -6.0f, 10.0f, 16.0f, 6.0f);
        this.body.method_2851(0.0f, -10.0f, 0.0f);
        this.spikes = new class_630[8];
        this.spikes[0] = new class_630((class_3879)this, 33, 25);
        this.spikes[0].method_2844(0.0f, 0.0f, 0.0f, 10.0f, 18.0f, 0.0f);
        this.spikes[0].method_2851(0.0f, 0.0f, 0.0f);
        this.spikes[0].field_3675 = (float)Math.toRadians(-40.0);
        this.body.method_2845(this.spikes[0]);
        this.spikes[1] = new class_630((class_3879)this, 33, 25);
        this.spikes[1].method_2844(0.0f, 0.0f, 0.0f, 10.0f, 18.0f, 0.0f);
        this.spikes[1].method_2851(0.0f, 0.0f, 0.0f);
        this.spikes[1].field_3675 = (float)Math.toRadians(-140.0);
        this.body.method_2845(this.spikes[1]);
        this.tail = new class_630[4];
        int last = this.tail.length - 1;
        for (int i = 0; i < this.tail.length; ++i) {
            int width;
            int height = (this.tail.length - i) * 4 / this.tail.length;
            if (height < 2) {
                height = 2;
            }
            if ((width = Math.round((float)height / 2.0f)) < 1) {
                width = 1;
            }
            this.tail[i] = new class_630((class_3879)this, 40, 0);
            this.tail[i].method_2844((float)(-height) * 0.5f, 0.0f, (float)(-width) * 0.5f, (float)height, 20.0f, (float)width);
            this.tail[i].method_2851(0.0f, 19.0f, 0.0f);
            if (i < last) {
                int px = 32 + (12 - height * 3);
                int index = (i << 1) + 2;
                this.spikes[index] = new class_630((class_3879)this, px, 22);
                this.spikes[index].method_2844(0.0f, 0.0f, 0.0f, (float)(height * 3), 20.0f, 0.0f);
                this.spikes[index].method_2851(0.0f, 0.0f, 0.0f);
                this.spikes[index].field_3675 = (float)Math.toRadians(-60.0);
                this.tail[i].method_2845(this.spikes[index]);
                this.spikes[++index] = new class_630((class_3879)this, px, 22);
                this.spikes[index].method_2844(0.0f, 0.0f, 0.0f, (float)(height * 3), 20.0f, 0.0f);
                this.spikes[index].method_2851(0.0f, 0.0f, 0.0f);
                this.spikes[index].field_3675 = (float)Math.toRadians(-120.0);
                this.tail[i].method_2845(this.spikes[index]);
            }
            if (i == 0) {
                this.body.method_2845(this.tail[i]);
                continue;
            }
            this.tail[i - 1].method_2845(this.tail[i]);
        }
        this.tail[0].field_3654 = (float)Math.toRadians(45.0);
        this.tail[1].field_3654 = (float)Math.toRadians(45.0);
    }

    protected Iterable<class_630> method_22946() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<class_630> method_22948() {
        return ImmutableList.of((Object)this.body);
    }

    public void animateModel(EntityNaga livingEntity, float f, float g, float h) {
        this.pitch = livingEntity.method_6024(h);
        super.method_2816((class_1297)livingEntity, f, g, h);
    }

    public void setAngles(EntityNaga entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        int i;
        float angle;
        boolean rollTooBig = entity.method_6003() > 4;
        boolean isSwimming = entity.method_20232();
        this.head.field_3675 = headYaw * ((float)Math.PI / 180);
        this.head.field_3654 = rollTooBig ? -0.7853982f : (this.pitch > 0.0f ? (isSwimming ? this.lerpAngle(this.head.field_3654, -0.7853982f, this.pitch) : this.lerpAngle(this.head.field_3654, headPitch * ((float)Math.PI / 180), this.pitch)) : headPitch * ((float)Math.PI / 180));
        double speed = entity.method_24828() && (entity.method_18798().field_1352 != 0.0 || entity.method_18798().field_1350 != 0.0) && !entity.method_5765() ? 6.0 : 0.5;
        this.maxAngle = this.lerpAngle(this.maxAngle, speed > 1.0 ? 0.1f : 0.5f, 0.03f);
        double animation = (double)animationProgress * speed / 20.0;
        float start_angle = angle = (float)Math.sin(animation) * this.maxAngle * 0.3f;
        this.tail[0].field_3675 = angle;
        for (i = 1; i < this.tail.length; ++i) {
            angle = (float)Math.atan(Math.sin((double)i * 1.7 + animation)) * this.maxAngle;
            this.tail[i].field_3674 = angle - start_angle;
            start_angle += angle;
        }
        for (i = 0; i < this.spikes.length; ++i) {
            float yaw;
            this.spikes[i].field_3675 = yaw = (i & 1) == 0 ? (float)Math.toRadians(-50.0 + Math.sin(animation * 0.4 + (double)(i / 2)) * 10.0) : (float)Math.toRadians(-110.0 - Math.sin(animation * 0.4 + (double)(i / 2)) * 10.0);
        }
    }

    protected float lerpAngle(float from, float to, float position) {
        float angle = (to - from) % ((float)Math.PI * 2);
        if (angle < (float)(-Math.PI)) {
            angle += (float)Math.PI * 2;
        }
        if (angle >= (float)Math.PI) {
            angle -= (float)Math.PI * 2;
        }
        return from + position * angle;
    }
}

