/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.registry;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import paulevs.betternether.biomes.CrimsonGlowingWoods;
import paulevs.betternether.biomes.CrimsonPinewood;
import paulevs.betternether.biomes.FloodedDeltas;
import paulevs.betternether.biomes.NetherBiome;
import paulevs.betternether.biomes.NetherBiomeWrapper;
import paulevs.betternether.biomes.NetherBoneReef;
import paulevs.betternether.biomes.NetherGrasslands;
import paulevs.betternether.biomes.NetherGravelDesert;
import paulevs.betternether.biomes.NetherJungle;
import paulevs.betternether.biomes.NetherMagmaLand;
import paulevs.betternether.biomes.NetherMushroomForest;
import paulevs.betternether.biomes.NetherMushroomForestEdge;
import paulevs.betternether.biomes.NetherPoorGrasslands;
import paulevs.betternether.biomes.NetherSoulPlain;
import paulevs.betternether.biomes.NetherSulfuricBoneReef;
import paulevs.betternether.biomes.NetherSwampland;
import paulevs.betternether.biomes.NetherSwamplandTerraces;
import paulevs.betternether.biomes.NetherWartForest;
import paulevs.betternether.biomes.NetherWartForestEdge;
import paulevs.betternether.biomes.OldFungiwoods;
import paulevs.betternether.biomes.OldSwampland;
import paulevs.betternether.biomes.OldWarpedWoods;
import paulevs.betternether.biomes.UpsideDownForest;
import paulevs.betternether.config.Config;

public class BiomesRegistry {
    private static final ArrayList<NetherBiome> REGISTRY = new ArrayList();
    private static final ArrayList<NetherBiome> ALL_BIOMES = new ArrayList();
    private static final HashMap<NetherBiome, class_5321<class_1959>> KEYS = Maps.newHashMap();
    public static final HashMap<class_1959, NetherBiome> MUTABLE = Maps.newHashMap();
    private static final HashMap<NetherBiome, Float> DEF_CHANCES_MAIN = Maps.newHashMap();
    private static final HashMap<NetherBiome, Float> DEF_CHANCES_SUB = Maps.newHashMap();
    private static final HashMap<NetherBiome, Integer> DEF_SIZE_EDGE = Maps.newHashMap();
    public static final NetherBiome BIOME_EMPTY_NETHER = new NetherBiomeWrapper(new class_2960("nether_wastes"));
    public static final NetherBiome BIOME_CRIMSON_FOREST = new NetherBiomeWrapper(new class_2960("crimson_forest"));
    public static final NetherBiome BIOME_WARPED_FOREST = new NetherBiomeWrapper(new class_2960("warped_forest"));
    public static final NetherBiome BIOME_BASALT_DELTAS = new NetherBiomeWrapper(new class_2960("basalt_deltas"));
    public static final NetherBiome BIOME_GRAVEL_DESERT = new NetherGravelDesert("Gravel Desert");
    public static final NetherBiome BIOME_NETHER_JUNGLE = new NetherJungle("Nether Jungle");
    public static final NetherBiome BIOME_WART_FOREST = new NetherWartForest("Wart Forest");
    public static final NetherBiome BIOME_GRASSLANDS = new NetherGrasslands("Nether Grasslands");
    public static final NetherBiome BIOME_MUSHROOM_FOREST = new NetherMushroomForest("Nether Mushroom Forest");
    public static final NetherBiome BIOME_MUSHROOM_FOREST_EDGE = new NetherMushroomForestEdge("Nether Mushroom Forest Edge");
    public static final NetherBiome BIOME_WART_FOREST_EDGE = new NetherWartForestEdge("Wart Forest Edge");
    public static final NetherBiome BIOME_BONE_REEF = new NetherBoneReef("Bone Reef");
    public static final NetherBiome BIOME_SULFURIC_BONE_REEF = new NetherSulfuricBoneReef("Sulfuric Bone Reef");
    public static final NetherBiome BIOME_POOR_GRASSLANDS = new NetherPoorGrasslands("Poor Nether Grasslands");
    public static final NetherBiome NETHER_SWAMPLAND = new NetherSwampland("Nether Swampland");
    public static final NetherBiome NETHER_SWAMPLAND_TERRACES = new NetherSwamplandTerraces("Nether Swampland Terraces");
    public static final NetherBiome MAGMA_LAND = new NetherMagmaLand("Magma Land");
    public static final NetherBiome SOUL_PLAIN = new NetherSoulPlain("Soul Plain");
    public static final NetherBiome CRIMSON_GLOWING_WOODS = new CrimsonGlowingWoods("Crimson Glowing Woods");
    public static final NetherBiome OLD_WARPED_WOODS = new OldWarpedWoods("Old Warped Woods");
    public static final NetherBiome CRIMSON_PINEWOOD = new CrimsonPinewood("Crimson Pinewood");
    public static final NetherBiome OLD_FUNGIWOODS = new OldFungiwoods("Old Fungiwoods");
    public static final NetherBiome FLOODED_DELTAS = new FloodedDeltas("Flooded Deltas");
    public static final NetherBiome UPSIDE_DOWN_FOREST = new UpsideDownForest("Upside Down Forest");
    public static final NetherBiome OLD_SWAMPLAND = new OldSwampland("Old Swampland");
    private static int maxChance = 0;
    private static boolean registered = false;

    public static void register() {
        BiomesRegistry.registerBiome(BIOME_GRAVEL_DESERT);
        BiomesRegistry.registerBiome(BIOME_NETHER_JUNGLE);
        BiomesRegistry.registerBiome(BIOME_WART_FOREST);
        BiomesRegistry.registerBiome(BIOME_GRASSLANDS);
        BiomesRegistry.registerBiome(BIOME_MUSHROOM_FOREST);
        BiomesRegistry.registerEdgeBiome(BIOME_MUSHROOM_FOREST_EDGE, BIOME_MUSHROOM_FOREST, 2);
        BiomesRegistry.registerEdgeBiome(BIOME_WART_FOREST_EDGE, BIOME_WART_FOREST, 2);
        BiomesRegistry.registerBiome(BIOME_BONE_REEF);
        BiomesRegistry.registerSubBiome(BIOME_SULFURIC_BONE_REEF, BIOME_BONE_REEF, 0.3f);
        BiomesRegistry.registerSubBiome(BIOME_POOR_GRASSLANDS, BIOME_GRASSLANDS, 0.3f);
        BiomesRegistry.registerBiome(NETHER_SWAMPLAND);
        BiomesRegistry.registerSubBiome(NETHER_SWAMPLAND_TERRACES, NETHER_SWAMPLAND, 1.0f);
        BiomesRegistry.registerBiome(MAGMA_LAND);
        BiomesRegistry.registerSubBiome(SOUL_PLAIN, BIOME_WART_FOREST, 1.0f);
        BiomesRegistry.registerSubBiome(CRIMSON_GLOWING_WOODS, BIOME_CRIMSON_FOREST, 0.3f);
        BiomesRegistry.registerSubBiome(OLD_WARPED_WOODS, BIOME_WARPED_FOREST, 1.0f);
        BiomesRegistry.registerSubBiome(CRIMSON_PINEWOOD, BIOME_CRIMSON_FOREST, 0.3f);
        BiomesRegistry.registerSubBiome(OLD_FUNGIWOODS, BIOME_MUSHROOM_FOREST, 0.3f);
        BiomesRegistry.registerSubBiome(FLOODED_DELTAS, BIOME_BASALT_DELTAS, 1.0f);
        BiomesRegistry.registerBiome(UPSIDE_DOWN_FOREST);
        BiomesRegistry.registerSubBiome(OLD_SWAMPLAND, NETHER_SWAMPLAND, 1.0f);
        BiomesRegistry.registerDefaultWrapped(BIOME_EMPTY_NETHER);
        BiomesRegistry.registerDefaultWrapped(BIOME_CRIMSON_FOREST);
        BiomesRegistry.registerDefaultWrapped(BIOME_WARPED_FOREST);
        BiomesRegistry.registerDefaultWrapped(BIOME_BASALT_DELTAS);
        BiomesRegistry.registerMinecraftBiomes();
    }

    public static void registerAllOtherBiomes() {
        if (!registered) {
            for (class_1959 biome : class_5458.field_25933) {
                float chance;
                if (biome.method_8688() != class_1959.class_1961.field_9366 || BiomesRegistry.hasLink(biome)) continue;
                class_2960 id = class_5458.field_25933.method_10221((Object)biome);
                String name = id.method_12832();
                String group = id.method_12836();
                if (group.equals("betternether") || !((chance = Config.getFloat("biomes." + group, name + "_chance", 1.0f)) > 0.0f)) continue;
                NetherBiomeWrapper wrapper = new NetherBiomeWrapper(id);
                maxChance = (int)((float)maxChance + chance);
                wrapper.setGenChance(maxChance);
                wrapper.build();
                REGISTRY.add(wrapper);
                BiomesRegistry.makeLink(wrapper);
                DEF_CHANCES_MAIN.put(wrapper, Float.valueOf(chance));
            }
            registered = true;
            Config.markToSave();
            Config.save();
        }
    }

    private static void registerMinecraftBiomes() {
        for (class_1959 biome : class_5458.field_25933) {
            class_2960 id;
            if (biome.method_8688() != class_1959.class_1961.field_9366 || BiomesRegistry.hasLink(biome) || !(id = class_5458.field_25933.method_10221((Object)biome)).method_12836().equals("minecraft")) continue;
            NetherBiomeWrapper wrapper = new NetherBiomeWrapper(id);
            BiomesRegistry.registerDefaultWrapped(wrapper);
        }
    }

    private static void registerDefaultWrapped(NetherBiome biome) {
        float chance = Config.getFloat("biomes.minecraft.main", biome.getRegistryName() + "_chance", 1.0f);
        if (chance > 0.0f) {
            maxChance = (int)((float)maxChance + chance);
            biome.setGenChance(maxChance);
            biome.setPlantDensity(Config.getFloat("generator.biome." + biome.getRegistryName(), "plants_and_structures_density", 1.0f));
            biome.build();
            REGISTRY.add(biome);
            BiomesRegistry.makeLink(biome);
            ALL_BIOMES.add(biome);
            DEF_CHANCES_MAIN.put(biome, Float.valueOf(1.0f));
        }
    }

    private static void registerBiomeDirect(String regName, NetherBiome biome) {
        class_2378.method_10230((class_2378)class_5458.field_25933, (class_2960)biome.getID(), (Object)biome.getBiome());
        BiomesRegistry.makeLink(biome);
    }

    public static void registerBiome(NetherBiome biome) {
        String regName = biome.getRegistryName();
        float chance = Config.getFloat("biomes.betternether.main", regName + "_chance", 1.0f);
        if (chance > 0.0f) {
            maxChance = (int)((float)maxChance + chance);
            biome.setPlantDensity(Config.getFloat("generator.biome." + biome.getRegistryName(), "plants_and_structures_density", 1.0f));
            biome.setGenChance(maxChance);
            biome.build();
            REGISTRY.add(biome);
            ALL_BIOMES.add(biome);
            DEF_CHANCES_MAIN.put(biome, Float.valueOf(chance));
            BiomesRegistry.registerBiomeDirect(regName, biome);
        }
    }

    public static void registerEdgeBiome(NetherBiome biome, NetherBiome mainBiome, int size) {
        String regName = biome.getRegistryName();
        int sizeConf = Config.getInt("biomes.betternether.edge", regName + "_size", size);
        if ((float)sizeConf > 0.0f) {
            biome.setPlantDensity(Config.getFloat("generator.biome." + biome.getRegistryName(), "plants_and_structures_density", 1.0f));
            mainBiome.setEdge(biome);
            mainBiome.setEdgeSize(sizeConf);
            biome.build();
            DEF_SIZE_EDGE.put(biome, sizeConf);
            ALL_BIOMES.add(biome);
            BiomesRegistry.registerBiomeDirect(regName, biome);
        }
    }

    public static void registerSubBiome(NetherBiome biome, NetherBiome mainBiome, float chance) {
        String regName = biome.getRegistryName();
        chance = Config.getFloat("biomes.betternether.variation", regName + "_chance", chance);
        if (chance > 0.0f) {
            biome.setPlantDensity(Config.getFloat("generator.biome." + biome.getRegistryName(), "plants_and_structures_density", 1.0f));
            mainBiome.addSubBiome(biome, chance);
            biome.build();
            DEF_CHANCES_SUB.put(biome, Float.valueOf(chance));
            ALL_BIOMES.add(biome);
            BiomesRegistry.registerBiomeDirect(regName, biome);
        }
    }

    public static NetherBiome getBiome(Random random) {
        float chance = random.nextFloat() * (float)maxChance;
        for (NetherBiome biome : REGISTRY) {
            if (!biome.canGenerate(chance)) continue;
            return biome;
        }
        return REGISTRY.get(0);
    }

    private static boolean hasLink(class_1959 biome) {
        Optional optional = class_5458.field_25933.method_29113((Object)biome);
        if (!optional.isPresent()) {
            return false;
        }
        class_2960 id = ((class_5321)optional.get()).method_29177();
        for (class_5321<class_1959> key : KEYS.values()) {
            if (!id.equals((Object)key.method_29177())) continue;
            return true;
        }
        return false;
    }

    private static void makeLink(NetherBiome netherBiome) {
        Optional optional = class_5458.field_25933.method_29113((Object)netherBiome.getBiome());
        class_5321 key = optional.isPresent() ? (class_5321)optional.get() : class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)netherBiome.getID());
        KEYS.put(netherBiome, (class_5321<class_1959>)key);
    }

    public static NetherBiome getFromBiome(class_1959 biome) {
        return MUTABLE.getOrDefault(biome, BIOME_EMPTY_NETHER);
    }

    public static ArrayList<NetherBiome> getRegisteredBiomes() {
        return REGISTRY;
    }

    public static void registerModBiome(NetherBiome biome, float chance) {
        String regName = biome.getRegistryName();
        float genChance = Config.getFloat("biomes." + biome.getNamespace() + ".main", regName + "_chance", chance);
        if (genChance > 0.0f) {
            maxChance = (int)((float)maxChance + genChance);
            biome.setPlantDensity(Config.getFloat("generator.biome." + biome.getNamespace() + "." + regName, "plants_and_structures_density", 1.0f));
            biome.setGenChance(maxChance);
            biome.build();
            REGISTRY.add(biome);
            ALL_BIOMES.add(biome);
            DEF_CHANCES_MAIN.put(biome, Float.valueOf(chance));
            BiomesRegistry.registerBiomeDirect(regName, biome);
        }
    }

    public static void registerModEdgeBiome(NetherBiome biome, NetherBiome mainBiome, int size) {
        String regName = biome.getRegistryName();
        int sizeConf = Config.getInt("biomes." + biome.getNamespace() + ".edge", regName + "_size", size);
        if (sizeConf > 0) {
            biome.setPlantDensity(Config.getFloat("generator.biome." + biome.getNamespace() + "." + regName, "plants_and_structures_density", 1.0f));
            mainBiome.setEdge(biome);
            mainBiome.setEdgeSize(sizeConf);
            biome.build();
            DEF_SIZE_EDGE.put(biome, sizeConf);
            ALL_BIOMES.add(biome);
            BiomesRegistry.registerBiomeDirect(regName, biome);
        }
    }

    public static void registerModSubBiome(NetherBiome biome, NetherBiome mainBiome, float chance) {
        String regName = biome.getRegistryName();
        chance = Config.getFloat("biomes." + biome.getNamespace() + ".variation", regName + "_chance", chance);
        if (chance > 0.0f) {
            biome.setPlantDensity(Config.getFloat("generator.biome." + biome.getNamespace() + "." + regName, "plants_and_structures_density", 1.0f));
            mainBiome.addSubBiome(biome, chance);
            biome.build();
            DEF_CHANCES_SUB.put(biome, Float.valueOf(chance));
            ALL_BIOMES.add(biome);
            BiomesRegistry.registerBiomeDirect(regName, biome);
        }
    }

    public static float getDefaultMainChance(NetherBiome biome) {
        Float val = DEF_CHANCES_MAIN.get(biome);
        return val == null ? 1.0f : val.floatValue();
    }

    public static float getDefaultSubChance(NetherBiome biome) {
        Float val = DEF_CHANCES_SUB.get(biome);
        return val == null ? 1.0f : val.floatValue();
    }

    public static int getDefaultEdgeSize(NetherBiome biome) {
        Integer val = DEF_SIZE_EDGE.get(biome);
        return val == null ? 1 : val;
    }

    public static ArrayList<NetherBiome> getAllBiomes() {
        return ALL_BIOMES;
    }

    public static class_5321<class_1959> getBiomeKey(NetherBiome biome) {
        return KEYS.get(biome);
    }
}

