/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.structures;

import java.util.Random;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_5425;
import paulevs.betternether.BlocksHelper;
import paulevs.betternether.noise.OpenSimplexNoise;
import paulevs.betternether.structures.IStructure;

public class StructureRoad
implements IStructure {
    private static final boolean[][][] MASK = new boolean[16][64][16];
    private static final class_2338.class_2339 B_POS = new class_2338.class_2339();
    private static final int OFFSET = 32;
    private OpenSimplexNoise heightNoise;
    private OpenSimplexNoise rigidNoise;
    private OpenSimplexNoise distortX;
    private OpenSimplexNoise distortY;

    public StructureRoad(long seed) {
        Random random = new Random(seed);
        this.heightNoise = new OpenSimplexNoise(random.nextLong());
        this.rigidNoise = new OpenSimplexNoise(random.nextLong());
        this.distortX = new OpenSimplexNoise(random.nextLong());
        this.distortY = new OpenSimplexNoise(random.nextLong());
    }

    @Override
    public void generate(class_5425 world, class_2338 pos, Random random) {
        int wz;
        int z;
        int wx;
        int x;
        for (x = 0; x < 16; ++x) {
            wx = pos.method_10263() + x;
            for (z = 0; z < 16; ++z) {
                wz = pos.method_10260() + z;
                double height = this.getHeight(wx, wz);
                double rigid = this.getRigid(wx, wz);
                for (int y = 0; y < 64; ++y) {
                    int wy = 32 + y;
                    double hRigid = Math.abs((double)wy - height);
                    double sdf = -this.opSmoothUnion(-hRigid / 80.0, -rigid, 0.1);
                    StructureRoad.MASK[x][y][z] = sdf < 0.1 && (double)wy > height;
                }
            }
        }
        for (x = 0; x < 16; ++x) {
            wx = pos.method_10263() + x;
            for (z = 0; z < 16; ++z) {
                wz = pos.method_10260() + z;
                for (int y = 62; y >= 1; --y) {
                    boolean slab;
                    int wy = 32 + y;
                    B_POS.method_10103(wx, wy, wz);
                    if (MASK[x][y][z]) {
                        if (world.method_22347((class_2338)B_POS)) continue;
                        BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)B_POS, class_2246.field_10124.method_9564());
                        continue;
                    }
                    if (!MASK[x][y + 1][z]) continue;
                    boolean bl = slab = this.getHeight(wx, wz) - (double)wy > 0.5;
                    if (slab) {
                        BlocksHelper.setWithoutUpdate((class_1936)world, B_POS.method_10084(), class_2246.field_10390.method_9564());
                    }
                    BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)B_POS, class_2246.field_10266.method_9564());
                    if (!world.method_22347(B_POS.method_10074()) && !world.method_22347(B_POS.method_10087(2))) continue;
                    for (int py = 5; py < wy; ++py) {
                        B_POS.method_10099(py);
                        BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)B_POS, class_2246.field_10266.method_9564());
                    }
                }
            }
        }
    }

    private double getHeight(int x, int z) {
        return this.heightNoise.eval((double)x * 0.01, (double)z * 0.01) * 16.0 + 64.0;
    }

    private double getRigid(int x, int z) {
        return Math.abs(this.rigidNoise.eval((double)x * 0.002 + this.distortX.eval((double)x * 0.01, (double)z * 0.01) * 0.001, (double)z * 0.002 + this.distortY.eval((double)x * 0.01, (double)z * 0.01) * 0.001)) * 10.0;
    }

    private double mix(double dist1, double dist2, double blend) {
        return dist1 * (1.0 - blend) + dist2 * blend;
    }

    private double opSmoothUnion(double dist1, double dist2, double blend) {
        double h = 0.5 + 0.5 * (dist2 - dist1) / blend;
        h = h > 1.0 ? 1.0 : (h < 0.0 ? 0.0 : h);
        return this.mix(dist2, dist1, h) - blend * h * (1.0 - h);
    }
}

