/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.structures.plants;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5425;
import paulevs.betternether.BlocksHelper;
import paulevs.betternether.MHelper;
import paulevs.betternether.blocks.BlockAnchorTreeVine;
import paulevs.betternether.blocks.shapes.TripleShape;
import paulevs.betternether.registry.BlocksRegistry;
import paulevs.betternether.structures.IStructure;

public class StructureAnchorTreeBranch
implements IStructure {
    private static final float[] CURVE_X = new float[]{9.0f, 7.0f, 1.5f, 0.5f, 3.0f, 7.0f};
    private static final float[] CURVE_Y = new float[]{-20.0f, -17.0f, -12.0f, -4.0f, 0.0f, 2.0f};
    private static final int MIDDLE_Y = 10;
    private static final Set<class_2338> POINTS = new HashSet<class_2338>();
    private static final Set<class_2338> MIDDLE = new HashSet<class_2338>();
    private static final Set<class_2338> TOP = new HashSet<class_2338>();
    private static final class_2338.class_2339 POS = new class_2338.class_2339();

    @Override
    public void generate(class_5425 world, class_2338 pos, Random random) {
        if (pos.method_10264() < 96) {
            return;
        }
        this.grow(world, pos, random, true);
    }

    public void grow(class_5425 world, class_2338 pos, Random random, boolean natural) {
        world.method_8652(pos, class_2246.field_10124.method_9564(), 0);
        float scale = MHelper.randRange(0.5f, 1.0f, random);
        int minCount = (double)scale < 0.75 ? 3 : 4;
        int maxCount = (double)scale < 0.75 ? 5 : 7;
        int count = MHelper.randRange(minCount, maxCount, random);
        for (int n = 0; n < count; ++n) {
            float branchSize = MHelper.randRange(0.5f, 0.8f, random) * scale;
            float angle = (float)n * ((float)Math.PI * 2) / (float)count;
            float radius = CURVE_X[0] * branchSize;
            int x1 = Math.round((float)pos.method_10263() + radius * (float)Math.cos(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            int y1 = Math.round((float)pos.method_10264() + CURVE_Y[0] * branchSize + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            int z1 = Math.round((float)pos.method_10260() + radius * (float)Math.sin(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            float crownR = 9.0f * branchSize;
            if (crownR < 1.5f) {
                crownR = 1.5f;
            }
            this.crown((class_1936)world, new class_2338(x1, y1 + 1, z1), crownR, random);
            int middle = Math.round((float)pos.method_10264() + (float)(10 + MHelper.randRange(-2, 2, random)) * branchSize);
            boolean generate = true;
            for (int i = 1; i < CURVE_X.length && generate; ++i) {
                radius = CURVE_X[i] * branchSize;
                int x2 = Math.round((float)pos.method_10263() + radius * (float)Math.cos(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
                int y2 = Math.round((float)pos.method_10264() + CURVE_Y[i] * branchSize + (CURVE_Y[i] > 0.0f ? MHelper.randRange(-2.0f, 2.0f, random) * branchSize : 0.0f));
                int z2 = Math.round((float)pos.method_10260() + radius * (float)Math.sin(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
                if (CURVE_Y[i] >= 0.0f && this.canReplace(world.method_8320((class_2338)POS.method_10103(x2, y2, z2)))) {
                    boolean noGround = true;
                    for (int d = 1; d < 3; ++d) {
                        if (this.canReplace(world.method_8320((class_2338)POS.method_10103(x2, y2 - d, z2)))) continue;
                        y2 -= d;
                        noGround = false;
                        break;
                    }
                    if (noGround) {
                        x2 = pos.method_10263();
                        y2 = pos.method_10264();
                        generate = false;
                    }
                }
                this.line((class_1936)world, x1, y1, z1, x2, y2, z2, middle);
                x1 = x2;
                y1 = y2;
                z1 = z2;
            }
        }
        Iterator<class_2338> iterator = TOP.iterator();
        while (iterator.hasNext()) {
            class_2338 bpos = iterator.next();
            if (bpos == null || !POINTS.contains(bpos.method_10084()) || TOP.contains(bpos.method_10084())) continue;
            iterator.remove();
        }
        iterator = MIDDLE.iterator();
        while (iterator.hasNext()) {
            class_2338 bpos = iterator.next();
            if (bpos != null) {
                class_2338 up = bpos.method_10084();
                if (!MIDDLE.contains(up) && (TOP.contains(up) || !POINTS.contains(up))) continue;
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
        for (class_2338 bpos : POINTS) {
            class_2680 state = POINTS.contains(bpos.method_10084()) && POINTS.contains(bpos.method_10074()) ? BlocksRegistry.ANCHOR_TREE.log.method_9564() : BlocksRegistry.ANCHOR_TREE.bark.method_9564();
            BlocksHelper.setWithoutUpdate((class_1936)world, bpos, state);
        }
        POINTS.clear();
        MIDDLE.clear();
        TOP.clear();
    }

    private void line(class_1936 world, int x1, int y1, int z1, int x2, int y2, int z2, int middleY) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int mx = Math.max(Math.max(Math.abs(dx), Math.abs(dy)), Math.abs(dz));
        float fdx = (float)dx / (float)mx;
        float fdy = (float)dy / (float)mx;
        float fdz = (float)dz / (float)mx;
        float px = x1;
        float py = y1;
        float pz = z1;
        class_2338 pos = POS.method_10103(x1, y1, z1).method_10062();
        POINTS.add(pos);
        if (pos.method_10264() == middleY) {
            MIDDLE.add(pos);
        } else if (pos.method_10264() > middleY) {
            TOP.add(pos);
        }
        pos = POS.method_10103(x2, y2, z2).method_10062();
        POINTS.add(pos);
        if (pos.method_10264() == middleY) {
            MIDDLE.add(pos);
        } else if (pos.method_10264() > middleY) {
            TOP.add(pos);
        }
        for (int i = 0; i < mx; ++i) {
            POS.method_10103(Math.round(px += fdx), Math.round(py += fdy), Math.round(pz += fdz));
            pos = POS.method_10062();
            POINTS.add(pos);
            if (POS.method_10264() == middleY) {
                MIDDLE.add(pos);
                continue;
            }
            if (POS.method_10264() <= middleY) continue;
            TOP.add(pos);
        }
    }

    private void crown(class_1936 world, class_2338 pos, float radius, Random random) {
        int start;
        class_2680 leaves = BlocksRegistry.ANCHOR_TREE_LEAVES.method_9564();
        class_2680 vine = BlocksRegistry.ANCHOR_TREE_VINE.method_9564();
        float halfR = radius * 0.5f;
        float r2 = radius * radius;
        int cy = start = (int)Math.floor(-radius);
        while ((float)cy <= radius) {
            int cy2_out = cy * cy;
            float cy2_in = (float)cy + halfR;
            cy2_in *= cy2_in;
            POS.method_10099((int)((float)(pos.method_10264() + cy) - halfR));
            int cx = start;
            while ((float)cx <= radius) {
                int cx2 = cx * cx;
                POS.method_20787(pos.method_10263() + cx);
                int cz = start;
                while ((float)cz <= radius) {
                    int cz2 = cz * cz;
                    if ((float)(cx2 + cy2_out + cz2) < r2 && (float)cx2 + cy2_in + (float)cz2 > r2) {
                        POS.method_20788(pos.method_10260() + cz);
                        if (world.method_8320((class_2338)POS).method_26207().method_15800()) {
                            int length = BlocksHelper.downRay(world, (class_2338)POS, 17);
                            if (length < 5) {
                                BlocksHelper.setWithoutUpdate(world, (class_2338)POS, leaves);
                            } else {
                                if (length > 15) {
                                    length = MHelper.randRange(12, 15, random);
                                } else if (length > 12) {
                                    length = MHelper.randRange(12, length, random);
                                }
                                for (int i = 1; i < length - 2; ++i) {
                                    BlocksHelper.setWithoutUpdate(world, POS.method_10087(i), vine);
                                }
                                BlocksHelper.setWithoutUpdate(world, POS.method_10087(length - 2), (class_2680)vine.method_11657(BlockAnchorTreeVine.SHAPE, (Comparable)((Object)TripleShape.MIDDLE)));
                                BlocksHelper.setWithoutUpdate(world, POS.method_10087(length - 1), (class_2680)vine.method_11657(BlockAnchorTreeVine.SHAPE, (Comparable)((Object)TripleShape.BOTTOM)));
                                BlocksHelper.setWithoutUpdate(world, (class_2338)POS, leaves);
                            }
                        }
                    }
                    ++cz;
                }
                ++cx;
            }
            ++cy;
        }
    }

    private boolean canReplace(class_2680 state) {
        return BlocksHelper.isNetherGround(state) || state.method_26207().method_15800();
    }
}

