/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.structures.plants;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_5425;
import paulevs.betternether.BlocksHelper;
import paulevs.betternether.MHelper;
import paulevs.betternether.blocks.BlockPlantWall;
import paulevs.betternether.blocks.BlockWillowBranch;
import paulevs.betternether.blocks.BlockWillowLeaves;
import paulevs.betternether.registry.BlocksRegistry;
import paulevs.betternether.structures.StructureFuncScatter;

public class StructureOldWillow
extends StructureFuncScatter {
    private static final float[] CURVE_X = new float[]{9.0f, 7.0f, 1.5f, 0.5f, 3.0f, 7.0f};
    private static final float[] CURVE_Y = new float[]{20.0f, 17.0f, 12.0f, 4.0f, 0.0f, -2.0f};
    private static final Set<class_2338> BLOCKS = new HashSet<class_2338>();
    private class_2248[] wallPlants;

    public StructureOldWillow() {
        super(13);
    }

    @Override
    public void grow(class_5425 world, class_2338 pos, Random random) {
        this.grow(world, pos, random, true);
    }

    public void grow(class_5425 world, class_2338 pos, Random random, boolean natural) {
        world.method_8652(pos, class_2246.field_10124.method_9564(), 0);
        float scale = MHelper.randRange(0.7f, 1.3f, random);
        int minCount = scale < 1.0f ? 3 : 4;
        int maxCount = scale < 1.0f ? 5 : 7;
        int count = MHelper.randRange(minCount, maxCount, random);
        for (int n = 0; n < count; ++n) {
            float branchSize = MHelper.randRange(0.5f, 1.0f, random) * scale;
            float angle = (float)n * ((float)Math.PI * 2) / (float)count;
            float radius = CURVE_X[0] * branchSize;
            int x1 = Math.round((float)pos.method_10263() + radius * (float)Math.cos(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            int y1 = Math.round((float)pos.method_10264() + CURVE_Y[0] * branchSize + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            int z1 = Math.round((float)pos.method_10260() + radius * (float)Math.sin(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            float crownR = 10.0f * branchSize;
            if (crownR < 1.5f) {
                crownR = 1.5f;
            }
            this.crown((class_1936)world, new class_2338(x1, y1 + 1, z1), crownR, random);
            boolean generate = true;
            for (int i = 1; i < CURVE_X.length && generate; ++i) {
                radius = CURVE_X[i] * branchSize;
                int x2 = Math.round((float)pos.method_10263() + radius * (float)Math.cos(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
                int y2 = Math.round((float)pos.method_10264() + CURVE_Y[i] * branchSize + (CURVE_Y[i] > 0.0f ? MHelper.randRange(-2.0f, 2.0f, random) * branchSize : 0.0f));
                int z2 = Math.round((float)pos.method_10260() + radius * (float)Math.sin(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
                if (CURVE_Y[i] <= 0.0f && !this.isGround(world.method_8320((class_2338)POS.method_10103(x2, y2, z2)))) {
                    boolean noGround = true;
                    for (int d = 1; d < 3; ++d) {
                        if (!this.isGround(world.method_8320((class_2338)POS.method_10103(x2, y2 - d, z2)))) continue;
                        y2 -= d;
                        noGround = false;
                        break;
                    }
                    if (noGround) {
                        x2 = pos.method_10263();
                        y2 = pos.method_10264();
                        generate = false;
                    }
                }
                this.line((class_1936)world, x1, y1, z1, x2, y2, z2, pos.method_10264());
                x1 = x2;
                y1 = y2;
                z1 = z2;
            }
        }
        if (this.wallPlants == null) {
            this.wallPlants = new class_2248[]{BlocksRegistry.WALL_MOSS, BlocksRegistry.WALL_MOSS, BlocksRegistry.WALL_MUSHROOM_BROWN, BlocksRegistry.WALL_MUSHROOM_RED};
        }
        for (class_2338 bpos : BLOCKS) {
            class_2680 state = world.method_8320(bpos);
            if (!BlocksHelper.isNetherGround(state) && !state.method_26207().method_15800()) continue;
            if (!BLOCKS.contains(bpos.method_10084()) || !BLOCKS.contains(bpos.method_10074())) {
                BlocksHelper.setWithoutUpdate((class_1936)world, bpos, BlocksRegistry.WILLOW_BARK.method_9564());
            } else {
                BlocksHelper.setWithoutUpdate((class_1936)world, bpos, BlocksRegistry.WILLOW_LOG.method_9564());
            }
            if (random.nextInt(8) != 0) continue;
            state = this.wallPlants[random.nextInt(this.wallPlants.length)].method_9564();
            if (random.nextInt(8) == 0 && !BLOCKS.contains(bpos.method_10095()) && world.method_22347(bpos.method_10095())) {
                BlocksHelper.setWithoutUpdate((class_1936)world, bpos.method_10095(), (class_2680)state.method_11657((class_2769)BlockPlantWall.FACING, (Comparable)class_2350.field_11043));
            }
            if (random.nextInt(8) == 0 && !BLOCKS.contains(bpos.method_10072()) && world.method_22347(bpos.method_10072())) {
                BlocksHelper.setWithoutUpdate((class_1936)world, bpos.method_10072(), (class_2680)state.method_11657((class_2769)BlockPlantWall.FACING, (Comparable)class_2350.field_11035));
            }
            if (random.nextInt(8) == 0 && !BLOCKS.contains(bpos.method_10078()) && world.method_22347(bpos.method_10078())) {
                BlocksHelper.setWithoutUpdate((class_1936)world, bpos.method_10078(), (class_2680)state.method_11657((class_2769)BlockPlantWall.FACING, (Comparable)class_2350.field_11034));
            }
            if (random.nextInt(8) != 0 || BLOCKS.contains(bpos.method_10067()) || !world.method_22347(bpos.method_10067())) continue;
            BlocksHelper.setWithoutUpdate((class_1936)world, bpos.method_10067(), (class_2680)state.method_11657((class_2769)BlockPlantWall.FACING, (Comparable)class_2350.field_11039));
        }
        BLOCKS.clear();
    }

    @Override
    public void generate(class_5425 world, class_2338 pos, Random random) {
        int length = BlocksHelper.upRay((class_1936)world, pos, 27);
        if (length >= 25) {
            super.generate(world, pos, random);
        }
    }

    @Override
    protected boolean isStructure(class_2680 state) {
        return state.method_26204() == BlocksRegistry.RUBEUS_LOG;
    }

    @Override
    protected boolean isGround(class_2680 state) {
        return BlocksHelper.isNetherGround(state);
    }

    private void line(class_1936 world, int x1, int y1, int z1, int x2, int y2, int z2, int startY) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int mx = Math.max(Math.max(Math.abs(dx), Math.abs(dy)), Math.abs(dz));
        float fdx = (float)dx / (float)mx;
        float fdy = (float)dy / (float)mx;
        float fdz = (float)dz / (float)mx;
        float px = x1;
        float py = y1;
        float pz = z1;
        class_2338 pos = POS.method_10103(x1, y1, z1).method_10062();
        BLOCKS.add(pos);
        pos = POS.method_10103(x2, y2, z2).method_10062();
        BLOCKS.add(pos);
        for (int i = 0; i < mx; ++i) {
            POS.method_10103(Math.round(px += fdx), Math.round(py += fdy), Math.round(pz += fdz));
            double delta = POS.method_10264() - startY;
            this.sphere((class_2338)POS, class_3532.method_15350((double)(2.3 - Math.abs(delta) * (delta > 0.0 ? 0.1 : 0.3)), (double)0.5, (double)2.3));
        }
    }

    private void sphere(class_2338 pos, double radius) {
        int x1 = MHelper.floor((double)pos.method_10263() - radius);
        int y1 = MHelper.floor((double)pos.method_10264() - radius);
        int z1 = MHelper.floor((double)pos.method_10260() - radius);
        int x2 = MHelper.floor((double)pos.method_10263() + radius + 1.0);
        int y2 = MHelper.floor((double)pos.method_10264() + radius + 1.0);
        int z2 = MHelper.floor((double)pos.method_10260() + radius + 1.0);
        radius *= radius;
        for (int x = x1; x <= x2; ++x) {
            int px2 = x - pos.method_10263();
            px2 *= px2;
            for (int z = z1; z <= z2; ++z) {
                int pz2 = z - pos.method_10260();
                pz2 *= pz2;
                for (int y = y1; y <= y2; ++y) {
                    int py2 = y - pos.method_10264();
                    if (!((double)(px2 + pz2 + (py2 *= py2)) <= radius)) continue;
                    BLOCKS.add(new class_2338(x, y, z));
                }
            }
        }
    }

    private void crown(class_1936 world, class_2338 pos, float radius, Random random) {
        int start;
        class_2680 leaves = (class_2680)BlocksRegistry.WILLOW_LEAVES.method_9564().method_11657((class_2769)BlockWillowLeaves.NATURAL, (Comparable)Boolean.valueOf(false));
        class_2680 vine = BlocksRegistry.WILLOW_BRANCH.method_9564();
        float halfR = radius * 0.5f;
        float r2 = radius * radius;
        int cy = start = (int)Math.floor(-radius);
        while ((float)cy <= radius) {
            int cy2_out = cy * cy;
            float cy2_in = (float)cy + halfR;
            cy2_in *= cy2_in;
            POS.method_10099((int)((float)(pos.method_10264() + cy) - halfR));
            int cx = start;
            while ((float)cx <= radius) {
                int cx2 = cx * cx * 2;
                POS.method_20787(pos.method_10263() + cx);
                int cz = start;
                while ((float)cz <= radius) {
                    block5: {
                        block8: {
                            block6: {
                                int length;
                                block7: {
                                    int cz2 = cz * cz * 2;
                                    if (!((float)(cx2 + cy2_out + cz2) < r2) || !((float)cx2 + cy2_in + (float)cz2 > r2)) break block5;
                                    POS.method_20788(pos.method_10260() + cz);
                                    if (!world.method_8320((class_2338)POS).method_26207().method_15800()) break block5;
                                    if (!random.nextBoolean()) break block6;
                                    length = BlocksHelper.downRay(world, (class_2338)POS, 12);
                                    if (length >= 3) break block7;
                                    BlocksHelper.setWithoutUpdate(world, (class_2338)POS, leaves);
                                    break block5;
                                }
                                length = MHelper.randRange(3, length, random);
                                for (int i = 1; i < length - 1; ++i) {
                                    BlocksHelper.setWithoutUpdate(world, POS.method_10087(i), vine);
                                }
                                BlocksHelper.setWithoutUpdate(world, POS.method_10087(length - 1), (class_2680)vine.method_11657(BlockWillowBranch.SHAPE, (Comparable)((Object)BlockWillowBranch.WillowBranchShape.END)));
                                break block8;
                            }
                            if (random.nextBoolean() && world.method_8320(POS.method_10074()).method_26207().method_15800()) {
                                BlocksHelper.setWithoutUpdate(world, POS.method_10074(), leaves);
                            }
                        }
                        BlocksHelper.setWithoutUpdate(world, (class_2338)POS, leaves);
                    }
                    ++cz;
                }
                ++cx;
            }
            ++cy;
        }
    }
}

