/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5505;
import paulevs.betternether.biomes.NetherBiome;
import paulevs.betternether.registry.BiomesRegistry;
import paulevs.betternether.world.BNWorldGenerator;
import paulevs.betternether.world.BiomeMap;

public class NetherBiomeSource
extends class_1966 {
    public static final Codec<NetherBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5505.method_31148((class_5321)class_2378.field_25114).forGetter(theEndBiomeSource -> theEndBiomeSource.biomeRegistry), (App)Codec.LONG.fieldOf("seed").stable().forGetter(theEndBiomeSource -> theEndBiomeSource.seed)).apply((Applicative)instance, instance.stable(NetherBiomeSource::new)));
    private BiomeMap map;
    private final long seed;
    private final class_2378<class_1959> biomeRegistry;

    public NetherBiomeSource(class_2378<class_1959> biomeRegistry, long seed) {
        super(Collections.emptyList());
        this.seed = seed;
        this.map = new BiomeMap(seed, BNWorldGenerator.biomeSizeXZ, BNWorldGenerator.biomeSizeY, BNWorldGenerator.volumetric);
        this.biomeRegistry = biomeRegistry;
        for (NetherBiome netherBiome : BiomesRegistry.getAllBiomes()) {
            BiomesRegistry.MUTABLE.put((class_1959)biomeRegistry.method_31140(BiomesRegistry.getBiomeKey(netherBiome)), netherBiome);
        }
    }

    public class_1959 method_16359(int biomeX, int biomeY, int biomeZ) {
        NetherBiome netherBiome = this.map.getBiome(biomeX << 2, biomeY << 2, biomeZ << 2);
        if (biomeX == 0 && biomeZ == 0) {
            this.map.clearCache();
        }
        return (class_1959)this.biomeRegistry.method_31140(BiomesRegistry.getBiomeKey(netherBiome));
    }

    public class_1966 method_27985(long seed) {
        return new NetherBiomeSource(this.biomeRegistry, seed);
    }

    protected Codec<? extends class_1966> method_28442() {
        return CODEC;
    }

    public static void register() {
        class_2378.method_10230((class_2378)class_2378.field_25096, (class_2960)new class_2960("betternether", "nether_biome_source"), CODEC);
    }
}

