/*
 * Decompiled with CFR 0.152.
 */
package com.yanis48.betterworldlist;

import com.google.common.hash.Hashing;
import com.mojang.blaze3d.systems.RenderSystem;
import com.yanis48.betterworldlist.mixin.SelectWorldScreenAccessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1940;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_29;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_31;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_327;
import net.minecraft.class_33;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_34;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_403;
import net.minecraft.class_405;
import net.minecraft.class_410;
import net.minecraft.class_421;
import net.minecraft.class_4280;
import net.minecraft.class_435;
import net.minecraft.class_437;
import net.minecraft.class_524;
import net.minecraft.class_525;
import net.minecraft.class_526;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public class GridWorldListWidget
extends class_4280<Entry> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat();
    private static final class_2960 UNKNOWN_SERVER_TEXTURE = new class_2960("textures/misc/unknown_server.png");
    private static final class_2960 WORLD_SELECTION_TEXTURE = new class_2960("textures/gui/world_selection.png");
    private final class_526 parent;
    private List<class_34> levels;
    private boolean scrolling;

    public GridWorldListWidget(class_526 parent, class_310 client, int width, int height, int top, int bottom, int itemHeight, Supplier<String> searchFilter, GridWorldListWidget list) {
        super(client, width, height, top, bottom, itemHeight);
        this.parent = parent;
        if (list != null) {
            this.levels = list.levels;
        }
        this.filter(searchFilter, false);
    }

    public void filter(Supplier<String> supplier, boolean load) {
        this.clearEntries();
        class_32 levelStorage = this.minecraft.method_1586();
        if (this.levels == null || load) {
            try {
                this.levels = levelStorage.method_235();
            }
            catch (class_33 e) {
                LOGGER.error("Couldn't load level list", (Throwable)e);
                this.minecraft.method_1507((class_437)new class_421((class_2561)new class_2588("selectWorld.unable_to_load", new Object[0]), e.getMessage()));
                return;
            }
            Collections.sort(this.levels);
        }
        if (!this.levels.isEmpty()) {
            String string = supplier.get().toLowerCase(Locale.ROOT);
            Iterator<class_34> var5 = this.levels.iterator();
            while (true) {
                if (!var5.hasNext()) {
                    return;
                }
                class_34 levelSummary = var5.next();
                if (!levelSummary.method_252().toLowerCase(Locale.ROOT).contains(string) && !levelSummary.method_248().toLowerCase(Locale.ROOT).contains(string)) continue;
                this.addEntry((class_350.class_351)new Entry(this, levelSummary, this.minecraft.method_1586()));
            }
        }
        this.minecraft.method_1507((class_437)new class_525((class_437)null));
    }

    protected void renderList(int x, int y, int mouseX, int mouseY, float delta) {
        int count = this.getItemCount();
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        for (int index = 0; index < count; ++index) {
            int v;
            int rowTop = this.getRowTop(index);
            int rowBottom = this.getRowBottom(index);
            if (rowBottom < this.field_19085 || rowTop > this.field_19086) continue;
            int q = index % 2 == 0 ? y + index / 2 * this.itemHeight + this.headerHeight : y + (index - 1) / 2 * this.itemHeight + this.headerHeight;
            int height = this.itemHeight - 4;
            Entry entry = (Entry)this.getEntry(index);
            int width = this.getRowWidth();
            if (this.renderSelection && this.isSelectedItem(index)) {
                int u;
                if (index % 2 == 0) {
                    v = this.field_19088 + this.width / 2 - width / 2;
                    u = this.field_19088 + this.width / 2 - 4;
                } else {
                    v = this.field_19088 + this.width / 2 + 4;
                    u = this.field_19088 + this.width / 2 + width / 2;
                }
                RenderSystem.disableTexture();
                float f = this.isFocused() ? 1.0f : 0.5f;
                RenderSystem.color4f((float)f, (float)f, (float)f, (float)1.0f);
                bufferBuilder.method_1328(7, class_290.field_1592);
                bufferBuilder.method_22912((double)v, (double)(q + height + 2), 0.0).method_1344();
                bufferBuilder.method_22912((double)u, (double)(q + height + 2), 0.0).method_1344();
                bufferBuilder.method_22912((double)u, (double)(q - 2), 0.0).method_1344();
                bufferBuilder.method_22912((double)v, (double)(q - 2), 0.0).method_1344();
                tessellator.method_1350();
                RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                bufferBuilder.method_1328(7, class_290.field_1592);
                bufferBuilder.method_22912((double)(v + 1), (double)(q + height + 1), 0.0).method_1344();
                bufferBuilder.method_22912((double)(u - 1), (double)(q + height + 1), 0.0).method_1344();
                bufferBuilder.method_22912((double)(u - 1), (double)(q - 1), 0.0).method_1344();
                bufferBuilder.method_22912((double)(v + 1), (double)(q - 1), 0.0).method_1344();
                tessellator.method_1350();
                RenderSystem.enableTexture();
            }
            v = this.getRowLeft(index);
            entry.render(index, rowTop, v, width, height, mouseX, mouseY, this.isMouseOver(mouseX, mouseY) && Objects.equals(this.getEntryAt(mouseX, mouseY), entry), delta);
        }
    }

    protected int getRowLeft(int index) {
        int rowLeft = index % 2 == 0 ? this.field_19088 + this.width / 2 - this.getRowWidth() / 2 + 2 : this.field_19088 + this.width / 2 + 6;
        return rowLeft;
    }

    protected int getRowTop(int index) {
        int rowTop = index % 2 == 0 ? this.field_19085 + 4 - (int)this.getScrollAmount() + index / 2 * this.itemHeight + this.headerHeight : this.field_19085 + 4 - (int)this.getScrollAmount() + (index - 1) / 2 * this.itemHeight + this.headerHeight;
        return rowTop;
    }

    private int getRowBottom(int i) {
        return this.getRowTop(i) + this.itemHeight;
    }

    public int getRowWidth() {
        return super.getRowWidth() + 52;
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 20;
    }

    protected int getMaxPosition() {
        if (this.getItemCount() % 2 == 0) {
            return this.getItemCount() / 2 * this.itemHeight + this.headerHeight;
        }
        return (this.getItemCount() / 2 + 1) * this.itemHeight + this.headerHeight;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.updateScrollingState(mouseX, mouseY, button);
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        Entry entry = this.getEntryAt(mouseX, mouseY);
        if (entry != null) {
            if (entry.mouseClicked(mouseX, mouseY, button)) {
                this.setFocused((class_364)entry);
                this.setDragging(true);
                return true;
            }
        } else if (button == 0) {
            this.clickedHeader((int)(mouseX - (double)(this.field_19088 + this.width / 2 - this.getRowWidth() / 2)), (int)(mouseY - (double)this.field_19085) + (int)this.getScrollAmount() - 4);
            return true;
        }
        return this.scrolling;
    }

    protected final Entry getEntryAt(double x, double y) {
        int rowMiddle = this.getRowWidth() / 2;
        int middle = this.field_19088 + this.width / 2;
        int left = middle - rowMiddle;
        int right = middle + rowMiddle;
        int height = class_3532.method_15357((double)(y - (double)this.field_19085)) - this.headerHeight + (int)this.getScrollAmount() - 4;
        int n = height / this.itemHeight;
        if (x < (double)this.getScrollbarPosition() && n >= 0 && height >= 0) {
            if (x >= (double)left && x <= (double)middle) {
                return n + n < this.getItemCount() ? (Entry)this.children().get(n * 2) : null;
            }
            if (x >= (double)middle && x <= (double)right) {
                return n + n + 1 < this.getItemCount() ? (Entry)this.children().get(n * 2 + 1) : null;
            }
        }
        return null;
    }

    protected boolean isFocused() {
        return this.parent.getFocused() == this;
    }

    public void setSelected(Entry entry) {
        super.setSelected((class_350.class_351)entry);
        if (entry != null) {
            class_34 levelSummary = entry.level;
            class_333.field_2054.method_19788(new class_2588("narrator.select", new Object[]{new class_2588("narrator.select.world", new Object[]{levelSummary.method_252(), new Date(levelSummary.method_249()), levelSummary.method_257() ? new class_2588("gameMode.hardcore", new Object[0]) : new class_2588("gameMode." + levelSummary.method_247().method_8381(), new Object[0]), levelSummary.method_259() ? new class_2588("selectWorld.cheats", new Object[0]) : "", levelSummary.method_258()})}).getString());
        }
    }

    protected void moveSelection(int amount) {
        super.moveSelection(amount);
        this.parent.method_19940(true);
    }

    public Optional<Entry> method_20159() {
        return Optional.ofNullable((Entry)this.getSelected());
    }

    public class_526 getParent() {
        return this.parent;
    }

    @Environment(value=EnvType.CLIENT)
    public final class Entry
    extends class_4280.class_4281<Entry>
    implements AutoCloseable {
        private final class_310 client;
        private final class_526 screen;
        private final class_34 level;
        private final class_2960 iconLocation;
        private File iconFile;
        private final class_1043 icon;
        private long time;

        public Entry(GridWorldListWidget levelList, class_34 level, class_32 levelStorage) {
            this.screen = levelList.getParent();
            this.level = level;
            this.client = class_310.method_1551();
            this.iconLocation = new class_2960("worlds/" + Hashing.sha1().hashUnencodedChars((CharSequence)level.method_248()) + "/icon");
            this.iconFile = levelStorage.method_239(level.method_248(), "icon.png");
            if (!this.iconFile.isFile()) {
                this.iconFile = null;
            }
            this.icon = this.getIconTexture();
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            return Objects.equals(GridWorldListWidget.this.getEntryAt(mouseX, mouseY), this);
        }

        public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            String displayName = this.level.method_252();
            String name = this.level.method_248();
            String lastPlayed = "(" + DATE_FORMAT.format(new Date(this.level.method_249())) + ")";
            class_2561 gameMode = this.level.method_257() ? new class_2588("gameMode.hardcore", new Object[0]).method_10854(class_124.field_1079) : this.level.method_247().method_8383();
            class_2561 cheats = new class_2588("selectWorld.cheats", new Object[0]).method_10854(class_124.field_1076);
            class_2561 version = this.getVersionText();
            if (StringUtils.isEmpty((CharSequence)displayName)) {
                displayName = class_1074.method_4662((String)"selectWorld.world", (Object[])new Object[0]) + " " + (index + 1);
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.client.method_1531().method_22813(this.icon != null ? this.iconLocation : UNKNOWN_SERVER_TEXTURE);
            RenderSystem.enableBlend();
            class_332.blit((int)x, (int)y, (float)0.0f, (float)0.0f, (int)128, (int)64, (int)128, (int)64);
            RenderSystem.disableBlend();
            class_327 textRenderer = this.client.field_1772;
            int x2 = x + 3;
            int y2 = y + 64 + 3;
            textRenderer.method_1729(displayName, (float)x2, (float)y2, 0xFFFFFF);
            textRenderer.method_1729(name, (float)x2, (float)(y2 += 9), 0x808080);
            textRenderer.method_1729(lastPlayed, (float)x2, (float)(y2 += 9), 0x808080);
            textRenderer.method_1729(gameMode.method_10863(), (float)x2, (float)(y2 += 9), 0xFFFF55);
            if (this.level.method_259()) {
                textRenderer.method_1729(cheats.method_10863(), (float)x2, (float)(y2 += 9), 0x808080);
            }
            textRenderer.method_1729(version.method_10863(), (float)x2, (float)(y2 += 9), 0x808080);
            if (this.client.field_1690.field_1854 || hovered) {
                int k;
                this.client.method_1531().method_22813(WORLD_SELECTION_TEXTURE);
                int arrowX = mouseX - x;
                int arrowY = mouseY - y;
                boolean arrowHovered = arrowX > 0 && arrowX < 32 && arrowY > 0 && arrowY < 32;
                int n = k = arrowHovered ? 32 : 0;
                if (this.level.method_256()) {
                    class_332.blit((int)x, (int)y, (float)32.0f, (float)k, (int)32, (int)32, (int)256, (int)256);
                    if (this.level.method_253()) {
                        class_332.blit((int)x, (int)y, (float)96.0f, (float)k, (int)32, (int)32, (int)256, (int)256);
                        if (arrowHovered) {
                            class_2561 tooltipText = new class_2588("selectWorld.tooltip.unsupported", new Object[]{this.level.method_258()}).method_10854(class_124.field_1061);
                            this.screen.method_2739(this.client.field_1772.method_1722(tooltipText.method_10863(), 175));
                        }
                    } else if (this.level.method_260()) {
                        class_332.blit((int)x, (int)y, (float)96.0f, (float)k, (int)32, (int)32, (int)256, (int)256);
                        if (arrowHovered) {
                            this.screen.method_2739(class_124.field_1061 + class_1074.method_4662((String)"selectWorld.tooltip.fromNewerVersion1", (Object[])new Object[0]) + "\n" + class_124.field_1061 + class_1074.method_4662((String)"selectWorld.tooltip.fromNewerVersion2", (Object[])new Object[0]));
                        }
                    } else if (!class_155.method_16673().isStable()) {
                        class_332.blit((int)x, (int)y, (float)64.0f, (float)k, (int)32, (int)32, (int)256, (int)256);
                        if (arrowHovered) {
                            this.screen.method_2739(class_124.field_1065 + class_1074.method_4662((String)"selectWorld.tooltip.snapshot1", (Object[])new Object[0]) + "\n" + class_124.field_1065 + class_1074.method_4662((String)"selectWorld.tooltip.snapshot2", (Object[])new Object[0]));
                        }
                    }
                } else {
                    class_332.blit((int)x, (int)y, (float)0.0f, (float)k, (int)32, (int)32, (int)256, (int)256);
                }
            }
        }

        private class_2561 getVersionText() {
            class_2561 version = this.level.method_258();
            class_2561 text = new class_2588("selectWorld.version", new Object[0]).method_10864(" ");
            if (this.level.method_256()) {
                text.method_10852(version.method_10856(new class_124[]{this.level.method_260() ? class_124.field_1061 : class_124.field_1075, class_124.field_1056}));
            } else {
                text.method_10852(version.method_10854(class_124.field_1075));
            }
            return text;
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            GridWorldListWidget.this.setSelected(this);
            this.screen.method_19940(GridWorldListWidget.this.method_20159().isPresent());
            int rowMiddle = GridWorldListWidget.this.getRowWidth() / 2;
            int middle = GridWorldListWidget.this.field_19088 + GridWorldListWidget.this.width / 2;
            int left = middle - rowMiddle;
            int right = middle + rowMiddle;
            int height = class_3532.method_15357((double)(mouseY - (double)GridWorldListWidget.this.field_19085)) - GridWorldListWidget.this.headerHeight + (int)GridWorldListWidget.this.getScrollAmount() - 4;
            int n = height / GridWorldListWidget.this.itemHeight;
            boolean validX = false;
            boolean validY = false;
            if (mouseX >= (double)left && mouseX <= (double)middle) {
                validX = mouseX - (double)GridWorldListWidget.this.getRowLeft(n * 2) <= 32.0;
                validY = mouseY - (double)GridWorldListWidget.this.getRowTop(n * 2) <= 32.0;
            } else if (mouseX >= (double)middle && mouseX <= (double)right) {
                validX = mouseX - (double)GridWorldListWidget.this.getRowLeft(n * 2 + 1) <= 32.0;
                boolean bl = validY = mouseY - (double)GridWorldListWidget.this.getRowTop(n * 2 + 1) <= 32.0;
            }
            if (validX && validY) {
                this.play();
                return true;
            }
            if (class_156.method_658() - this.time < 250L) {
                this.play();
                return true;
            }
            this.time = class_156.method_658();
            return false;
        }

        public void play() {
            if (!this.level.method_254() && !this.level.method_253()) {
                if (this.level.method_260()) {
                    this.client.method_1507((class_437)new class_410(bl -> {
                        if (bl) {
                            try {
                                this.start();
                            }
                            catch (Exception var3) {
                                LOGGER.error("Failure to open 'future world'", (Throwable)var3);
                                this.client.method_1507((class_437)new class_403(() -> this.client.method_1507((class_437)this.screen), (class_2561)new class_2588("selectWorld.futureworld.error.title", new Object[0]), (class_2561)new class_2588("selectWorld.futureworld.error.text", new Object[0])));
                            }
                        } else {
                            this.client.method_1507((class_437)this.screen);
                        }
                    }, (class_2561)new class_2588("selectWorld.versionQuestion", new Object[0]), (class_2561)new class_2588("selectWorld.versionWarning", new Object[]{this.level.method_258().method_10863()}), class_1074.method_4662((String)"selectWorld.versionJoinButton", (Object[])new Object[0]), class_1074.method_4662((String)"gui.cancel", (Object[])new Object[0])));
                } else {
                    this.start();
                }
            } else {
                class_2588 text = new class_2588("selectWorld.backupQuestion", new Object[0]);
                class_2588 text2 = new class_2588("selectWorld.backupWarning", new Object[]{this.level.method_258().method_10863(), class_155.method_16673().getName()});
                if (this.level.method_253()) {
                    text = new class_2588("selectWorld.backupQuestion.customized", new Object[0]);
                    text2 = new class_2588("selectWorld.backupWarning.customized", new Object[0]);
                }
                this.client.method_1507((class_437)new class_405((class_437)this.screen, (bl, bl2) -> {
                    if (bl) {
                        String string = this.level.method_248();
                        class_524.method_2701((class_32)this.client.method_1586(), (String)string);
                    }
                    this.start();
                }, (class_2561)text, (class_2561)text2, false));
            }
        }

        public void delete() {
            this.client.method_1507((class_437)new class_410(bl -> {
                if (bl) {
                    this.client.method_1507((class_437)new class_435());
                    class_32 levelStorage = this.client.method_1586();
                    levelStorage.method_233(this.level.method_248());
                    GridWorldListWidget.this.filter(() -> ((SelectWorldScreenAccessor)this.screen).getSearchBox().method_1882(), true);
                }
                this.client.method_1507((class_437)this.screen);
            }, (class_2561)new class_2588("selectWorld.deleteQuestion", new Object[0]), (class_2561)new class_2588("selectWorld.deleteWarning", new Object[]{this.level.method_252()}), class_1074.method_4662((String)"selectWorld.deleteButton", (Object[])new Object[0]), class_1074.method_4662((String)"gui.cancel", (Object[])new Object[0])));
        }

        public void edit() {
            this.client.method_1507((class_437)new class_524(bl -> {
                if (bl) {
                    GridWorldListWidget.this.filter(() -> ((SelectWorldScreenAccessor)this.screen).getSearchBox().method_1882(), true);
                }
                this.client.method_1507((class_437)this.screen);
            }, this.level.method_248()));
        }

        public void recreate() {
            try {
                this.client.method_1507((class_437)new class_435());
                class_525 createWorldScreen = new class_525((class_437)this.screen);
                class_29 worldSaveHandler = this.client.method_1586().method_242(this.level.method_248(), (MinecraftServer)null);
                class_31 levelProperties = worldSaveHandler.method_133();
                if (levelProperties != null) {
                    createWorldScreen.method_2737(levelProperties);
                    if (this.level.method_253()) {
                        this.client.method_1507((class_437)new class_410(bl -> this.client.method_1507((class_437)(bl ? createWorldScreen : this.screen)), (class_2561)new class_2588("selectWorld.recreate.customized.title", new Object[0]), (class_2561)new class_2588("selectWorld.recreate.customized.text", new Object[0]), class_1074.method_4662((String)"gui.proceed", (Object[])new Object[0]), class_1074.method_4662((String)"gui.cancel", (Object[])new Object[0])));
                    } else {
                        this.client.method_1507((class_437)createWorldScreen);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Unable to recreate world", (Throwable)e);
                this.client.method_1507((class_437)new class_403(() -> this.client.method_1507((class_437)this.screen), (class_2561)new class_2588("selectWorld.recreate.error.title", new Object[0]), (class_2561)new class_2588("selectWorld.recreate.error.text", new Object[0])));
            }
        }

        private void start() {
            this.client.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
            if (this.client.method_1586().method_230(this.level.method_248())) {
                this.client.method_1559(this.level.method_248(), this.level.method_252(), (class_1940)null);
            }
        }

        private class_1043 getIconTexture() {
            boolean validFile;
            boolean bl = validFile = this.iconFile != null && this.iconFile.isFile();
            if (validFile) {
                try {
                    class_1043 var6;
                    try (FileInputStream inputStream = new FileInputStream(this.iconFile);){
                        class_1011 nativeImage = class_1011.method_4309((InputStream)inputStream);
                        Validate.validState((nativeImage.method_4307() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                        Validate.validState((nativeImage.method_4323() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                        class_1043 nativeImageBackedTexture = new class_1043(nativeImage);
                        this.client.method_1531().method_4616(this.iconLocation, (class_1044)nativeImageBackedTexture);
                        var6 = nativeImageBackedTexture;
                    }
                    return var6;
                }
                catch (Throwable var18) {
                    LOGGER.error("Invalid icon for world {}", (Object)this.level.method_248(), (Object)var18);
                    this.iconFile = null;
                    return null;
                }
            }
            this.client.method_1531().method_4615(this.iconLocation);
            return null;
        }

        @Override
        public void close() {
            if (this.icon != null) {
                this.icon.close();
            }
        }
    }
}

