/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.blocklayering;

import com.lothrazar.blocklayering.block.BlockLayering;
import com.lothrazar.blocklayering.registry.LayeringRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@Mod(value="blocklayering")
public class ModBlockLayers {
    public static final String MODID = "blocklayering";
    @ObjectHolder(value="blocklayering:layer_hay")
    public static final Block icon = null;
    public static LayeringRegistry registry;
    public static ItemGroup tab;

    public ModBlockLayers() {
        registry = new LayeringRegistry();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
    }

    private void setup(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)LayeringRegistry.grass, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)LayeringRegistry.leaves_oak, (RenderType)RenderType.func_228639_c_());
        RenderTypeLookup.setRenderLayer((Block)LayeringRegistry.leaves_acacia, (RenderType)RenderType.func_228639_c_());
        RenderTypeLookup.setRenderLayer((Block)LayeringRegistry.leaves_birch, (RenderType)RenderType.func_228639_c_());
        RenderTypeLookup.setRenderLayer((Block)LayeringRegistry.leaves_jun, (RenderType)RenderType.func_228639_c_());
        RenderTypeLookup.setRenderLayer((Block)LayeringRegistry.leaves_spruce, (RenderType)RenderType.func_228639_c_());
        RenderTypeLookup.setRenderLayer((Block)LayeringRegistry.leaves_dark, (RenderType)RenderType.func_228639_c_());
    }

    static {
        tab = new ItemGroup(MODID){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)icon);
            }
        };
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void registerBlockColors(ColorHandlerEvent.Block event) {
            BlockColors blockColors = event.getBlockColors();
            blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> {
                if (pos == null || worldIn == null) {
                    return 0;
                }
                tintIndex = BiomeColors.func_228358_a_((ILightReader)worldIn, (BlockPos)pos);
                return tintIndex;
            }, LayeringRegistry.blockBiomeColours.toArray(new Block[0]));
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void registerItemColors(ColorHandlerEvent.Item event) {
            ArrayList<Item> items = new ArrayList<Item>();
            for (Block b : LayeringRegistry.blockBiomeColours) {
                items.add(Item.func_150898_a((Block)b));
            }
            ItemColors blockColors = event.getItemColors();
            blockColors.func_199877_a((stack, tintIndex) -> {
                tintIndex = 5279782;
                return tintIndex;
            }, (IItemProvider[])items.toArray(new Item[0]));
        }

        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
            IForgeRegistry r = event.getRegistry();
            r.register((IForgeRegistryEntry)registry.createLayer(Blocks.field_150435_aG, "clay"));
            r.register((IForgeRegistryEntry)registry.createLayer(Blocks.field_150354_m, "sand"));
            r.register((IForgeRegistryEntry)registry.createLayer(Blocks.field_196611_F, "red_sand"));
            r.register((IForgeRegistryEntry)registry.createLayer(Blocks.field_150351_n, "gravel"));
            r.register((IForgeRegistryEntry)registry.createLayer(Blocks.field_150407_cf, "hay"));
            r.register((IForgeRegistryEntry)registry.createLayer(Blocks.field_150425_aM, "soulsand"));
            r.register((IForgeRegistryEntry)registry.createLayer(Blocks.field_150346_d, "dirt"));
            r.register((IForgeRegistryEntry)registry.createLayer(Blocks.field_196660_k, "coarse_dirt"));
            r.register((IForgeRegistryEntry)registry.createLayer(Blocks.field_196661_l, "podzol"));
            r.register((IForgeRegistryEntry)registry.createLayer(Blocks.field_150391_bh, "mycelium"));
            r.register((IForgeRegistryEntry)registry.registerColour(registry.createLayer(Blocks.field_150349_c, "grass")));
            r.register((IForgeRegistryEntry)registry.createLayer(Blocks.field_185774_da, "path"));
            r.register((IForgeRegistryEntry)registry.createLayer(Blocks.field_196884_jh, "concrete_powder_black"));
            r.register((IForgeRegistryEntry)registry.createLayer(Blocks.field_196884_jh, "concrete_powder_blue"));
            r.register((IForgeRegistryEntry)registry.createLayer(Blocks.field_196884_jh, "concrete_powder_brown"));
            r.register((IForgeRegistryEntry)registry.createLayer(Blocks.field_196884_jh, "concrete_powder_cyan"));
            r.register((IForgeRegistryEntry)registry.createLayer(Blocks.field_196884_jh, "concrete_powder_gray"));
            r.register((IForgeRegistryEntry)registry.createLayer(Blocks.field_196884_jh, "concrete_powder_green"));
            r.register((IForgeRegistryEntry)registry.createLayer(Blocks.field_196884_jh, "concrete_powder_light_blue"));
            r.register((IForgeRegistryEntry)registry.createLayer(Blocks.field_196884_jh, "concrete_powder_lime"));
            r.register((IForgeRegistryEntry)registry.createLayer(Blocks.field_196884_jh, "concrete_powder_magenta"));
            r.register((IForgeRegistryEntry)registry.createLayer(Blocks.field_196884_jh, "concrete_powder_orange"));
            r.register((IForgeRegistryEntry)registry.createLayer(Blocks.field_196884_jh, "concrete_powder_pink"));
            r.register((IForgeRegistryEntry)registry.createLayer(Blocks.field_196884_jh, "concrete_powder_purple"));
            r.register((IForgeRegistryEntry)registry.createLayer(Blocks.field_196884_jh, "concrete_powder_red"));
            r.register((IForgeRegistryEntry)registry.createLayer(Blocks.field_196884_jh, "concrete_powder_silver"));
            r.register((IForgeRegistryEntry)registry.createLayer(Blocks.field_196884_jh, "concrete_powder_white"));
            r.register((IForgeRegistryEntry)registry.createLayer(Blocks.field_196884_jh, "concrete_powder_yellow"));
            r.register((IForgeRegistryEntry)registry.registerColour(registry.createLeaves(Blocks.field_196642_W, "leaves_oak")));
            r.register((IForgeRegistryEntry)registry.registerColour(registry.createLeaves(Blocks.field_196647_Y, "leaves_birch")));
            r.register((IForgeRegistryEntry)registry.registerColour(registry.createLeaves(Blocks.field_196645_X, "leaves_spruce")));
            r.register((IForgeRegistryEntry)registry.registerColour(registry.createLeaves(Blocks.field_196648_Z, "leaves_jungle")));
            r.register((IForgeRegistryEntry)registry.registerColour(registry.createLeaves(Blocks.field_196574_ab, "leaves_big_oak")));
            r.register((IForgeRegistryEntry)registry.registerColour(registry.createLeaves(Blocks.field_196572_aa, "leaves_acacia")));
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
            IForgeRegistry r = event.getRegistry();
            Item.Properties properties = new Item.Properties().func_200916_a(tab);
            for (BlockLayering b : LayeringRegistry.blocks) {
                r.register(new BlockItem((Block)b, properties).setRegistryName(b.rawName()));
            }
        }
    }
}

