/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.api.wire.redstone;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.wire.redstone.IInsulatedRedstoneDevice;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;

public class CapabilityRedstoneDevice {
    @CapabilityInject(value=IInsulatedRedstoneDevice.class)
    public static Capability<IInsulatedRedstoneDevice> INSULATED_CAPABILITY = null;
    @CapabilityInject(value=IRedstoneDevice.class)
    public static Capability<IRedstoneDevice> UNINSULATED_CAPABILITY = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IInsulatedRedstoneDevice.class, new DefaultInsulatedDevice(), () -> {
            throw new UnsupportedOperationException();
        });
        CapabilityManager.INSTANCE.register(IRedstoneDevice.class, new DefaultRedstoneDevice(), () -> {
            throw new UnsupportedOperationException();
        });
    }

    private static class DefaultRedstoneDevice<T extends IRedstoneDevice>
    implements Capability.IStorage<T> {
        private DefaultRedstoneDevice() {
        }

        @Nullable
        public INBT writeNBT(Capability<T> capability, T instance, Direction direction) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74774_a("power", instance.getRedstonePower(direction));
            return nbt;
        }

        public void readNBT(Capability<T> capability, T instance, Direction side, INBT nbt) {
            CompoundNBT tags = (CompoundNBT)nbt;
            byte power = tags.func_74771_c("power");
            instance.setRedstonePower(side, power);
        }
    }

    private static class DefaultInsulatedDevice<T extends IInsulatedRedstoneDevice>
    implements Capability.IStorage<T> {
        private DefaultInsulatedDevice() {
        }

        @Nullable
        public INBT writeNBT(Capability<T> capability, T instance, Direction direction) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a("color", instance.getInsulationColor(direction).name());
            nbt.func_74774_a("power", instance.getRedstonePower(direction));
            return nbt;
        }

        public void readNBT(Capability<T> capability, T instance, Direction side, INBT nbt) {
            CompoundNBT tags = (CompoundNBT)nbt;
            byte power = tags.func_74771_c("power");
            instance.setInsulationColor(MinecraftColor.valueOf(tags.func_74779_i("color")));
            instance.setRedstonePower(side, power);
        }
    }
}

