/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block;

import com.bluepowermod.api.block.IAdvancedSilkyRemovable;
import com.bluepowermod.block.BlockBase;
import com.bluepowermod.init.BPItems;
import com.bluepowermod.tile.TileBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockContainerBase
extends BlockBase
implements IAdvancedSilkyRemovable {
    private Class<? extends TileBase> tileEntityClass;
    private boolean isRedstoneEmitter;
    private boolean isSilkyRemoving;

    public BlockContainerBase(Material material, Class<? extends TileBase> tileEntityClass) {
        super(material);
        this.setTileEntityClass(tileEntityClass);
    }

    public BlockContainerBase(AbstractBlock.Properties properties, Class<? extends TileBase> tileEntityClass) {
        super(properties);
        this.setTileEntityClass(tileEntityClass);
    }

    public BlockContainerBase setTileEntityClass(Class<? extends TileBase> tileEntityClass) {
        this.tileEntityClass = tileEntityClass;
        return this;
    }

    public BlockContainerBase emitsRedstone() {
        this.isRedstoneEmitter = true;
        return this;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List drops = super.func_220076_a(state, builder);
        drops.add(new ItemStack((IItemProvider)this));
        return drops;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof TileBase) {
                InventoryHelper.func_219961_a((World)worldIn, (BlockPos)pos, ((TileBase)tileentity).getDrops());
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        try {
            return this.getTileEntity().newInstance();
        }
        catch (Exception e) {
            return super.createTileEntity(state, world);
        }
    }

    protected Class<? extends TileEntity> getTileEntity() {
        return this.tileEntityClass;
    }

    protected TileBase get(IBlockReader w, BlockPos pos) {
        TileEntity te = w.func_175625_s(pos);
        if (te == null || !(te instanceof TileBase)) {
            return null;
        }
        return (TileBase)te;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean bool) {
        TileBase tileEntity;
        super.func_220069_a(state, world, pos, blockIn, fromPos, bool);
        if (!world.field_72995_K && (tileEntity = this.get((IBlockReader)world, pos)) != null) {
            tileEntity.onBlockNeighbourChanged();
        }
    }

    public boolean func_149744_f(BlockState state) {
        return this.isRedstoneEmitter;
    }

    public int func_180656_a(BlockState blockState, IBlockReader par1IBlockReader, BlockPos pos, Direction side) {
        TileBase te = this.get(par1IBlockReader, pos);
        if (te instanceof TileBase) {
            TileBase tileBase = te;
            return tileBase.getOutputtingRedstone();
        }
        return 0;
    }

    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_213453_ef() && !player.func_184586_b(hand).func_190926_b() && player.func_184586_b(hand).func_77973_b() == BPItems.screwdriver) {
            return ActionResultType.FAIL;
        }
        if (player.func_213453_ef()) {
            return ActionResultType.FAIL;
        }
        if (!world.field_72995_K && world.func_175625_s(pos) instanceof INamedContainerProvider) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)world.func_175625_s(pos)));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    protected boolean canRotateVertical() {
        return true;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Override
    public boolean preSilkyRemoval(World world, BlockPos pos) {
        this.isSilkyRemoving = true;
        return true;
    }

    @Override
    public void postSilkyRemoval(World world, BlockPos pos) {
        this.isSilkyRemoving = false;
    }

    @Override
    public boolean writeSilkyData(World world, BlockPos pos, CompoundNBT tag) {
        world.func_175625_s(pos).func_189515_b(tag);
        return false;
    }

    @Override
    public void readSilkyData(World world, BlockPos pos, CompoundNBT tag) {
        world.func_175625_s(pos).func_230337_a_(world.func_180495_p(pos), tag);
    }
}

