/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.power;

import com.bluepowermod.api.power.CapabilityBlutricity;
import com.bluepowermod.block.BlockContainerBase;
import com.bluepowermod.tile.TileBPMultipart;
import com.bluepowermod.tile.tier3.TileBlulectricCable;
import com.bluepowermod.util.AABBUtils;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;

public class BlockBlulectricCable
extends BlockContainerBase
implements IWaterLoggable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    private static final BooleanProperty CONNECTED_FRONT = BooleanProperty.func_177716_a((String)"connected_front");
    private static final BooleanProperty CONNECTED_BACK = BooleanProperty.func_177716_a((String)"connected_back");
    private static final BooleanProperty CONNECTED_LEFT = BooleanProperty.func_177716_a((String)"connected_left");
    private static final BooleanProperty CONNECTED_RIGHT = BooleanProperty.func_177716_a((String)"connected_right");
    private static final BooleanProperty JOIN_FRONT = BooleanProperty.func_177716_a((String)"join_front");
    private static final BooleanProperty JOIN_BACK = BooleanProperty.func_177716_a((String)"join_back");
    private static final BooleanProperty JOIN_LEFT = BooleanProperty.func_177716_a((String)"join_left");
    private static final BooleanProperty JOIN_RIGHT = BooleanProperty.func_177716_a((String)"join_right");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected final VoxelShape[] shapes = this.makeShapes();

    public BlockBlulectricCable() {
        super(Material.field_151573_f, TileBlulectricCable.class);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.UP)).func_206870_a((Property)CONNECTED_FRONT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)CONNECTED_BACK, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)CONNECTED_LEFT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)JOIN_FRONT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)JOIN_BACK, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)JOIN_LEFT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)JOIN_RIGHT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.setRegistryName("bluepower:blulectric_cable");
    }

    @Override
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
        FACING.func_177700_c().forEach(f -> {
            BlockPos neighborPos = pos.func_177972_a(f).func_177972_a(((Direction)state.func_177229_b((Property)FACING)).func_176734_d());
            worldIn.func_180495_p(neighborPos).func_215697_a(worldIn, neighborPos, state.func_177230_c(), pos, isMoving);
        });
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity p_180633_4_, ItemStack p_180633_5_) {
        super.func_180633_a(worldIn, pos, state, p_180633_4_, p_180633_5_);
        FACING.func_177700_c().forEach(f -> {
            BlockPos neighborPos = pos.func_177972_a(f).func_177972_a(((Direction)state.func_177229_b((Property)FACING)).func_176734_d());
            worldIn.func_180495_p(neighborPos).func_215697_a(worldIn, neighborPos, state.func_177230_c(), pos, false);
        });
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return world.func_180495_p(pos.func_177972_a(((Direction)state.func_177229_b((Property)FACING)).func_176734_d())).func_200132_m();
    }

    protected VoxelShape[] makeShapes() {
        float width = 2.0f;
        float gap = 0.0f;
        float height = 2.0f;
        float f = 8.0f - width;
        float f1 = 8.0f + width;
        float f2 = 8.0f - width;
        float f3 = 8.0f + width;
        VoxelShape voxelshape = Block.func_208617_a((double)f, (double)0.0, (double)f, (double)f1, (double)height, (double)f1);
        VoxelShape voxelshape1 = Block.func_208617_a((double)f2, (double)gap, (double)0.0, (double)f3, (double)height, (double)f3);
        VoxelShape voxelshape2 = Block.func_208617_a((double)f2, (double)gap, (double)f2, (double)f3, (double)height, (double)16.0);
        VoxelShape voxelshape3 = Block.func_208617_a((double)0.0, (double)gap, (double)f2, (double)f3, (double)height, (double)f3);
        VoxelShape voxelshape4 = Block.func_208617_a((double)f2, (double)gap, (double)f2, (double)16.0, (double)height, (double)f3);
        VoxelShape voxelshape5 = VoxelShapes.func_197872_a((VoxelShape)voxelshape1, (VoxelShape)voxelshape4);
        VoxelShape voxelshape6 = VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape3);
        VoxelShape[] avoxelshape = new VoxelShape[]{VoxelShapes.func_197880_a(), voxelshape2, voxelshape3, voxelshape6, voxelshape1, VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape1), VoxelShapes.func_197872_a((VoxelShape)voxelshape3, (VoxelShape)voxelshape1), VoxelShapes.func_197872_a((VoxelShape)voxelshape6, (VoxelShape)voxelshape1), voxelshape4, VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape4), VoxelShapes.func_197872_a((VoxelShape)voxelshape3, (VoxelShape)voxelshape4), VoxelShapes.func_197872_a((VoxelShape)voxelshape6, (VoxelShape)voxelshape4), voxelshape5, VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape5), VoxelShapes.func_197872_a((VoxelShape)voxelshape3, (VoxelShape)voxelshape5), VoxelShapes.func_197872_a((VoxelShape)voxelshape6, (VoxelShape)voxelshape5)};
        for (int i = 0; i < 16; ++i) {
            avoxelshape[i] = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)avoxelshape[i]);
        }
        return avoxelshape;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AABBUtils.rotate(this.shapes[this.getShapeIndex(state)], (Direction)state.func_177229_b((Property)FACING));
    }

    private int getShapeIndex(BlockState state) {
        int i = 0;
        if (((Boolean)state.func_177229_b((Property)CONNECTED_FRONT)).booleanValue()) {
            i |= BlockBlulectricCable.getMask(Direction.NORTH);
        }
        if (((Boolean)state.func_177229_b((Property)CONNECTED_BACK)).booleanValue()) {
            i |= BlockBlulectricCable.getMask(Direction.SOUTH);
        }
        if (((Boolean)state.func_177229_b((Property)CONNECTED_LEFT)).booleanValue()) {
            i |= BlockBlulectricCable.getMask(Direction.WEST);
        }
        if (((Boolean)state.func_177229_b((Property)CONNECTED_RIGHT)).booleanValue()) {
            i |= BlockBlulectricCable.getMask(Direction.EAST);
        }
        return i;
    }

    private static int getMask(Direction facing) {
        return 1 << facing.func_176736_b();
    }

    @Override
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean bool) {
        TileEntity te = world.func_175625_s(pos);
        BlockState newState = this.getStateForPos(world, pos, (BlockState)this.func_176223_P().func_206870_a((Property)FACING, state.func_177229_b((Property)FACING)), (Direction)state.func_177229_b((Property)FACING));
        if (!(te instanceof TileBPMultipart)) {
            world.func_180501_a(pos, newState, 2);
        } else {
            ((TileBPMultipart)te).changeState(state, newState);
        }
        state = newState;
        if (!world.func_180495_p(pos.func_177972_a(((Direction)state.func_177229_b((Property)FACING)).func_176734_d())).func_200132_m()) {
            if (te instanceof TileBPMultipart) {
                ((TileBPMultipart)te).removeState(state);
                if (world instanceof ServerWorld) {
                    NonNullList drops = NonNullList.func_191196_a();
                    drops.add((Object)new ItemStack((IItemProvider)this));
                    InventoryHelper.func_219961_a((World)world, (BlockPos)pos, (NonNullList)drops);
                }
            } else {
                world.func_175655_b(pos, true);
            }
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, CONNECTED_FRONT, CONNECTED_BACK, CONNECTED_LEFT, CONNECTED_RIGHT, JOIN_FRONT, JOIN_BACK, JOIN_LEFT, JOIN_RIGHT, WATERLOGGED});
    }

    private BlockState getStateForPos(World world, BlockPos pos, BlockState state, Direction face) {
        ArrayList<Direction> directions = new ArrayList<Direction>(FACING.func_177700_c());
        TileEntity ownTile = world.func_175625_s(pos);
        if (ownTile instanceof TileBPMultipart) {
            directions.removeIf(d -> ((TileBPMultipart)ownTile).isSideBlocked((Capability)CapabilityBlutricity.BLUTRICITY_CAPABILITY, (Direction)d));
        }
        directions.removeIf(d -> world.func_180495_p(pos.func_177972_a(d)).func_177230_c() instanceof BlockBlulectricCable && world.func_180495_p(pos.func_177972_a(d)).func_177229_b((Property)FACING) != face);
        for (Direction d2 : directions) {
            TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(d2));
            boolean join = false;
            Block dBlock = world.func_180495_p(pos.func_177972_a(d2)).func_177230_c();
            if (dBlock == Blocks.field_150350_a || dBlock == Blocks.field_150355_j) {
                TileEntity tileEntity2 = world.func_175625_s(pos.func_177972_a(d2).func_177972_a(face.func_176734_d()));
                BlockState blockstate2 = world.func_180495_p(pos.func_177972_a(d2).func_177972_a(face.func_176734_d()));
                if (blockstate2.func_177230_c() instanceof BlockBlulectricCable && blockstate2.func_177229_b((Property)FACING) == d2 || tileEntity2 instanceof TileBPMultipart && ((TileBPMultipart)tileEntity2).getStates().stream().anyMatch(s -> s.func_177230_c() instanceof BlockBlulectricCable && s.func_177229_b((Property)FACING) == d2)) {
                    tileEntity = tileEntity2;
                    join = true;
                }
            }
            if (tileEntity == null) continue;
            block0 : switch ((Direction)state.func_177229_b((Property)FACING)) {
                case UP: 
                case DOWN: {
                    switch (d2) {
                        case EAST: {
                            state = (BlockState)state.func_206870_a((Property)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            state = (BlockState)state.func_206870_a((Property)JOIN_RIGHT, (Comparable)Boolean.valueOf(join && tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            break block0;
                        }
                        case WEST: {
                            state = (BlockState)state.func_206870_a((Property)CONNECTED_LEFT, (Comparable)Boolean.valueOf(tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            state = (BlockState)state.func_206870_a((Property)JOIN_LEFT, (Comparable)Boolean.valueOf(join && tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            break block0;
                        }
                        case NORTH: {
                            state = (BlockState)state.func_206870_a((Property)CONNECTED_FRONT, (Comparable)Boolean.valueOf(tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            state = (BlockState)state.func_206870_a((Property)JOIN_FRONT, (Comparable)Boolean.valueOf(join && tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            break block0;
                        }
                        case SOUTH: {
                            state = (BlockState)state.func_206870_a((Property)CONNECTED_BACK, (Comparable)Boolean.valueOf(tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            state = (BlockState)state.func_206870_a((Property)JOIN_BACK, (Comparable)Boolean.valueOf(join && tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                        }
                    }
                    break;
                }
                case NORTH: {
                    switch (d2) {
                        case WEST: {
                            state = (BlockState)state.func_206870_a((Property)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            state = (BlockState)state.func_206870_a((Property)JOIN_RIGHT, (Comparable)Boolean.valueOf(join && tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            break block0;
                        }
                        case EAST: {
                            state = (BlockState)state.func_206870_a((Property)CONNECTED_LEFT, (Comparable)Boolean.valueOf(tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            state = (BlockState)state.func_206870_a((Property)JOIN_LEFT, (Comparable)Boolean.valueOf(join && tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            break block0;
                        }
                        case UP: {
                            state = (BlockState)state.func_206870_a((Property)CONNECTED_FRONT, (Comparable)Boolean.valueOf(tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            state = (BlockState)state.func_206870_a((Property)JOIN_FRONT, (Comparable)Boolean.valueOf(join && tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            break block0;
                        }
                        case DOWN: {
                            state = (BlockState)state.func_206870_a((Property)CONNECTED_BACK, (Comparable)Boolean.valueOf(tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            state = (BlockState)state.func_206870_a((Property)JOIN_BACK, (Comparable)Boolean.valueOf(join && tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                        }
                    }
                    break;
                }
                case SOUTH: {
                    switch (d2) {
                        case EAST: {
                            state = (BlockState)state.func_206870_a((Property)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            state = (BlockState)state.func_206870_a((Property)JOIN_RIGHT, (Comparable)Boolean.valueOf(join && tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            break block0;
                        }
                        case WEST: {
                            state = (BlockState)state.func_206870_a((Property)CONNECTED_LEFT, (Comparable)Boolean.valueOf(tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            state = (BlockState)state.func_206870_a((Property)JOIN_LEFT, (Comparable)Boolean.valueOf(join && tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            break block0;
                        }
                        case UP: {
                            state = (BlockState)state.func_206870_a((Property)CONNECTED_FRONT, (Comparable)Boolean.valueOf(tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            state = (BlockState)state.func_206870_a((Property)JOIN_FRONT, (Comparable)Boolean.valueOf(join && tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            break block0;
                        }
                        case DOWN: {
                            state = (BlockState)state.func_206870_a((Property)CONNECTED_BACK, (Comparable)Boolean.valueOf(tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            state = (BlockState)state.func_206870_a((Property)JOIN_BACK, (Comparable)Boolean.valueOf(join && tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                        }
                    }
                    break;
                }
                case EAST: {
                    switch (d2) {
                        case NORTH: {
                            state = (BlockState)state.func_206870_a((Property)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            state = (BlockState)state.func_206870_a((Property)JOIN_RIGHT, (Comparable)Boolean.valueOf(join && tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            break block0;
                        }
                        case SOUTH: {
                            state = (BlockState)state.func_206870_a((Property)CONNECTED_LEFT, (Comparable)Boolean.valueOf(tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            state = (BlockState)state.func_206870_a((Property)JOIN_LEFT, (Comparable)Boolean.valueOf(join && tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            break block0;
                        }
                        case UP: {
                            state = (BlockState)state.func_206870_a((Property)CONNECTED_FRONT, (Comparable)Boolean.valueOf(tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            state = (BlockState)state.func_206870_a((Property)JOIN_FRONT, (Comparable)Boolean.valueOf(join && tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            break block0;
                        }
                        case DOWN: {
                            state = (BlockState)state.func_206870_a((Property)CONNECTED_BACK, (Comparable)Boolean.valueOf(tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            state = (BlockState)state.func_206870_a((Property)JOIN_BACK, (Comparable)Boolean.valueOf(join && tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                        }
                    }
                    break;
                }
                case WEST: {
                    switch (d2) {
                        case SOUTH: {
                            state = (BlockState)state.func_206870_a((Property)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            state = (BlockState)state.func_206870_a((Property)JOIN_RIGHT, (Comparable)Boolean.valueOf(join && tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            break block0;
                        }
                        case NORTH: {
                            state = (BlockState)state.func_206870_a((Property)CONNECTED_LEFT, (Comparable)Boolean.valueOf(tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            state = (BlockState)state.func_206870_a((Property)JOIN_LEFT, (Comparable)Boolean.valueOf(join && tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            break block0;
                        }
                        case UP: {
                            state = (BlockState)state.func_206870_a((Property)CONNECTED_FRONT, (Comparable)Boolean.valueOf(tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            state = (BlockState)state.func_206870_a((Property)JOIN_FRONT, (Comparable)Boolean.valueOf(join && tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            break block0;
                        }
                        case DOWN: {
                            state = (BlockState)state.func_206870_a((Property)CONNECTED_BACK, (Comparable)Boolean.valueOf(tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                            state = (BlockState)state.func_206870_a((Property)JOIN_BACK, (Comparable)Boolean.valueOf(join && tileEntity.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, d2.func_176734_d()).isPresent()));
                        }
                    }
                }
            }
        }
        FluidState fluidstate = world.func_204610_c(pos);
        return (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getStateForPos(context.func_195991_k(), context.func_195995_a(), (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196000_l()), context.func_196000_l());
    }

    public VoxelShape getOcclusionShape(BlockState state) {
        return AABBUtils.rotate(this.shapes[this.getShapeIndex(state)], (Direction)state.func_177229_b((Property)FACING));
    }
}

