/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.init;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.multipart.IBPPartBlock;
import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.block.BlockBPMicroblock;
import com.bluepowermod.block.BlockBPMultipart;
import com.bluepowermod.block.BlockBase;
import com.bluepowermod.block.BlockContainerBase;
import com.bluepowermod.block.BlockContainerFacingBase;
import com.bluepowermod.block.BlockContainerHorizontalFacingBase;
import com.bluepowermod.block.gates.BlockGateBase;
import com.bluepowermod.block.machine.BlockAlloyFurnace;
import com.bluepowermod.block.machine.BlockAlloyWire;
import com.bluepowermod.block.machine.BlockCircuitDatabase;
import com.bluepowermod.block.machine.BlockIgniter;
import com.bluepowermod.block.machine.BlockKineticGenerator;
import com.bluepowermod.block.machine.BlockLamp;
import com.bluepowermod.block.machine.BlockLampRGB;
import com.bluepowermod.block.machine.BlockLampRGBSurface;
import com.bluepowermod.block.machine.BlockLampSurface;
import com.bluepowermod.block.machine.BlockProjectTable;
import com.bluepowermod.block.machine.BlockRejecting;
import com.bluepowermod.block.machine.BlockSortron;
import com.bluepowermod.block.machine.BlockTube;
import com.bluepowermod.block.power.BlockBattery;
import com.bluepowermod.block.power.BlockBlulectricAlloyFurnace;
import com.bluepowermod.block.power.BlockBlulectricCable;
import com.bluepowermod.block.power.BlockBlulectricFurnace;
import com.bluepowermod.block.power.BlockEngine;
import com.bluepowermod.block.power.BlockSolarPanel;
import com.bluepowermod.block.power.BlockThermopile;
import com.bluepowermod.block.worldgen.BlockBPGlass;
import com.bluepowermod.block.worldgen.BlockBasalt;
import com.bluepowermod.block.worldgen.BlockCrackedBasalt;
import com.bluepowermod.block.worldgen.BlockCrop;
import com.bluepowermod.block.worldgen.BlockCustomFlower;
import com.bluepowermod.block.worldgen.BlockItemOre;
import com.bluepowermod.block.worldgen.BlockRubberLeaves;
import com.bluepowermod.block.worldgen.BlockRubberLog;
import com.bluepowermod.block.worldgen.BlockRubberSapling;
import com.bluepowermod.block.worldgen.BlockStoneOre;
import com.bluepowermod.block.worldgen.BlockStoneOreConnected;
import com.bluepowermod.init.BPCreativeTabs;
import com.bluepowermod.item.ItemBPPart;
import com.bluepowermod.reference.Refs;
import com.bluepowermod.tile.tier1.TileBlockBreaker;
import com.bluepowermod.tile.tier1.TileBuffer;
import com.bluepowermod.tile.tier1.TileDeployer;
import com.bluepowermod.tile.tier1.TileEjector;
import com.bluepowermod.tile.tier1.TileFilter;
import com.bluepowermod.tile.tier1.TileItemDetector;
import com.bluepowermod.tile.tier1.TileRelay;
import com.bluepowermod.tile.tier1.TileTransposer;
import com.bluepowermod.tile.tier2.TileAutoProjectTable;
import com.bluepowermod.tile.tier2.TileCircuitTable;
import com.bluepowermod.tile.tier2.TileRegulator;
import com.bluepowermod.tile.tier2.TileRetriever;
import com.bluepowermod.tile.tier2.TileSortingMachine;
import com.bluepowermod.tile.tier3.TileCircuitDatabase;
import com.bluepowermod.tile.tier3.TileManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BushBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.trees.OakTree;
import net.minecraft.block.trees.Tree;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="bluepower", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BPBlocks {
    public static List<Block> blockList = new ArrayList<Block>();
    public static List<Block> microblocks = new ArrayList<Block>();
    public static Block basalt;
    public static Block marble;
    public static Block basalt_cobble;
    public static Block basalt_brick;
    public static Block marble_brick;
    public static Block cracked_basalt_lava;
    public static Block half_block;
    public static Block panel;
    public static Block cover;
    public static Block basaltbrick_cracked;
    public static Block basalt_brick_small;
    public static Block marble_brick_small;
    public static Block fancy_basalt;
    public static Block fancy_marble;
    public static Block marble_tile;
    public static Block basalt_tile;
    public static Block marble_paver;
    public static Block basalt_paver;
    public static Block tiles;
    public static Block teslatite_ore;
    public static Block ruby_ore;
    public static Block sapphire_ore;
    public static Block amethyst_ore;
    public static Block copper_ore;
    public static Block silver_ore;
    public static Block zinc_ore;
    public static Block tungsten_ore;
    public static Block malachite_ore;
    public static Block ruby_block;
    public static Block sapphire_block;
    public static Block amethyst_block;
    public static Block teslatite_block;
    public static Block copper_block;
    public static Block silver_block;
    public static Block zinc_block;
    public static Block tungsten_block;
    public static Block malachite_block;
    public static Block rubber_log;
    public static Block rubber_leaves;
    public static Block rubber_sapling;
    public static Block sapphire_glass;
    public static Block reinforced_sapphire_glass;
    public static Block flax_crop;
    public static BushBlock indigo_flower;
    public static Block alloyfurnace;
    public static Block block_breaker;
    public static Block igniter;
    public static Block buffer;
    public static Block deployer;
    public static Block transposer;
    public static Block tube;
    public static Block sorting_machine;
    public static Block project_table;
    public static Block auto_project_table;
    public static Block[] project_tables;
    public static Block circuit_table;
    public static Block circuit_database;
    public static Block ejector;
    public static Block relay;
    public static Block filter;
    public static Block retriever;
    public static Block regulator;
    public static Block item_detector;
    public static Block manager;
    public static Block battery;
    public static Block blulectric_cable;
    public static Block blulectric_alloyfurnace;
    public static Block blulectric_furnace;
    public static Block engine;
    public static Block kinetic_generator;
    public static Block windmill;
    public static Block solarpanel;
    public static Block thermopile;
    public static Block multipart;
    public static List<Block> allLamps;
    public static Block[] blockLamp;
    public static Block[] blockLampInverted;
    public static Block[] cagedLamp;
    public static Block[] cagedLampInverted;
    public static Block[] fixedLamp;
    public static Block[] fixedLampInverted;
    public static Block blockLampRGB;
    public static Block blockLampRGBInverted;
    public static Block cagedLampRGB;
    public static Block cagedLampRGBInverted;
    public static Block fixedLampRGB;
    public static Block fixedLampRGBInverted;
    public static Block blockGateAND;
    public static Block blockGateNAND;
    public static Block[] blockAlloyWire;
    public static Block sortron;

    public static void init() {
        BPBlocks.instantiateBlocks();
        BPBlocks.initModDependantBlocks();
    }

    private static void instantiateBlocks() {
        int i;
        basalt = new BlockBasalt("basalt");
        marble = new BlockStoneOre("marble");
        basalt_cobble = new BlockStoneOre("basalt_cobble");
        basalt_brick = new BlockStoneOre("basalt_brick");
        marble_brick = new BlockStoneOre("marble_brick");
        cracked_basalt_lava = new BlockCrackedBasalt("cracked_basalt_lava");
        basaltbrick_cracked = new BlockStoneOre("basaltbrick_cracked");
        basalt_brick_small = new BlockStoneOre("basalt_brick_small");
        marble_brick_small = new BlockStoneOre("marble_brick_small");
        fancy_basalt = new BlockStoneOre("fancy_basalt");
        fancy_marble = new BlockStoneOre("fancy_marble");
        marble_tile = new BlockStoneOreConnected("marble_tile");
        basalt_tile = new BlockStoneOreConnected("basalt_tile");
        marble_paver = new BlockStoneOre("marble_paver");
        basalt_paver = new BlockStoneOre("basalt_paver");
        tiles = new BlockStoneOre("tiles");
        teslatite_ore = new BlockItemOre("teslatite_ore");
        ruby_ore = new BlockItemOre("ruby_ore");
        sapphire_ore = new BlockItemOre("sapphire_ore");
        amethyst_ore = new BlockItemOre("amethyst_ore");
        malachite_ore = new BlockItemOre("malachite_ore");
        copper_ore = new BlockStoneOre("copper_ore");
        silver_ore = new BlockStoneOre("silver_ore");
        zinc_ore = new BlockStoneOre("zinc_ore");
        tungsten_ore = new BlockStoneOre("tungsten_ore");
        ruby_block = new BlockStoneOre("ruby_block");
        sapphire_block = new BlockStoneOre("sapphire_block");
        amethyst_block = new BlockStoneOre("amethyst_block");
        teslatite_block = new BlockStoneOre("teslatite_block");
        malachite_block = new BlockStoneOre("malachite_block");
        copper_block = new BlockStoneOre("copper_block");
        silver_block = new BlockStoneOre("silver_block");
        zinc_block = new BlockStoneOre("zinc_block");
        tungsten_block = new BlockStoneOre("tungsten_block");
        multipart = new BlockBPMultipart();
        rubber_leaves = new BlockRubberLeaves(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_226896_b_());
        rubber_log = new BlockRubberLog(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d));
        rubber_sapling = new BlockRubberSapling((Tree)new OakTree(), AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k));
        sapphire_glass = new BlockBPGlass("sapphire_glass");
        reinforced_sapphire_glass = new BlockBPGlass("reinforced_sapphire_glass", true);
        flax_crop = new BlockCrop(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k));
        indigo_flower = new BlockCustomFlower("indigo_flower", AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k));
        alloyfurnace = new BlockAlloyFurnace();
        block_breaker = (Block)new BlockContainerFacingBase(Material.field_151576_e, TileBlockBreaker.class).setRegistryName("bluepower", "block_breaker");
        igniter = new BlockIgniter();
        buffer = (Block)new BlockContainerHorizontalFacingBase(Material.field_151576_e, TileBuffer.class){

            @Override
            protected boolean canRotateVertical() {
                return false;
            }
        }.setRegistryName("bluepower", "buffer");
        deployer = (Block)new BlockContainerFacingBase(Material.field_151576_e, TileDeployer.class).setRegistryName("bluepower", "deployer");
        transposer = (Block)new BlockContainerFacingBase(Material.field_151576_e, TileTransposer.class).setRegistryName("bluepower", "transposer");
        tube = (Block)new BlockTube().setRegistryName("bluepower", "tube");
        sorting_machine = (Block)new BlockContainerFacingBase(Material.field_151576_e, TileSortingMachine.class).setWIP(true).setRegistryName("bluepower", "sorting_machine");
        BPBlocks.project_tables[0] = project_table = new BlockProjectTable();
        BPBlocks.project_tables[1] = auto_project_table = (Block)new BlockProjectTable(TileAutoProjectTable.class).setWIP(true).setRegistryName("bluepower", "auto_project_table");
        circuit_table = (Block)new BlockProjectTable(TileCircuitTable.class).setWIP(true).setRegistryName("bluepower", "circuit_table");
        circuit_database = (Block)new BlockCircuitDatabase(TileCircuitDatabase.class).setWIP(true).setRegistryName("bluepower", "circuit_database");
        ejector = (Block)new BlockContainerFacingBase(Material.field_151576_e, TileEjector.class).setRegistryName("bluepower", "ejector");
        relay = (Block)new BlockContainerFacingBase(Material.field_151576_e, TileRelay.class).setWIP(true).setRegistryName("bluepower", "relay");
        filter = (Block)new BlockContainerFacingBase(Material.field_151576_e, TileFilter.class).setWIP(true).setRegistryName("bluepower", "filter");
        retriever = (Block)new BlockContainerFacingBase(Material.field_151576_e, TileRetriever.class).setWIP(true).setRegistryName("bluepower", "retriever");
        regulator = (Block)new BlockContainerFacingBase(Material.field_151576_e, TileRegulator.class).emitsRedstone().setWIP(true).setRegistryName("bluepower", "regulator");
        item_detector = (Block)new BlockContainerFacingBase(Material.field_151576_e, TileItemDetector.class).emitsRedstone().setWIP(true).setRegistryName("bluepower", "item_detector");
        manager = (Block)new BlockRejecting(Material.field_151576_e, TileManager.class).emitsRedstone().setWIP(true).setRegistryName("bluepower", "manager");
        battery = new BlockBattery();
        blulectric_cable = new BlockBlulectricCable();
        blulectric_furnace = new BlockBlulectricFurnace();
        blulectric_alloyfurnace = new BlockBlulectricAlloyFurnace();
        engine = new BlockEngine().setWIP(true);
        kinetic_generator = new BlockKineticGenerator().setWIP(true);
        solarpanel = new BlockSolarPanel();
        thermopile = new BlockThermopile().setWIP(true);
        half_block = (Block)new BlockBPMicroblock(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0)).setRegistryName("bluepower:half_block");
        panel = (Block)new BlockBPMicroblock(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0)).setRegistryName("bluepower:panel");
        cover = (Block)new BlockBPMicroblock(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0)).setRegistryName("bluepower:cover");
        microblocks.add(half_block);
        microblocks.add(panel);
        microblocks.add(cover);
        blockLamp = new Block[MinecraftColor.VALID_COLORS.length];
        blockLampInverted = new Block[MinecraftColor.VALID_COLORS.length];
        cagedLamp = new Block[MinecraftColor.VALID_COLORS.length];
        cagedLampInverted = new Block[MinecraftColor.VALID_COLORS.length];
        fixedLamp = new Block[MinecraftColor.VALID_COLORS.length];
        fixedLampInverted = new Block[MinecraftColor.VALID_COLORS.length];
        blockLampRGB = new BlockLampRGB("lamp", false).setWIP(true);
        for (i = 0; i < MinecraftColor.VALID_COLORS.length; ++i) {
            BPBlocks.blockLamp[i] = new BlockLamp("lamp", false, MinecraftColor.VALID_COLORS[i]);
        }
        blockLampRGBInverted = new BlockLampRGB("lamp", true).setWIP(true);
        for (i = 0; i < MinecraftColor.VALID_COLORS.length; ++i) {
            BPBlocks.blockLampInverted[i] = new BlockLamp("lamp", true, MinecraftColor.VALID_COLORS[i]);
        }
        allLamps = new ArrayList<Block>();
        allLamps.addAll(Arrays.asList(blockLamp));
        allLamps.addAll(Arrays.asList(blockLampInverted));
        allLamps.add(blockLampRGB);
        allLamps.add(blockLampRGBInverted);
        cagedLampRGB = new BlockLampRGBSurface("cagelamp", false, Refs.CAGELAMP_AABB).setWIP(true);
        for (i = 0; i < MinecraftColor.VALID_COLORS.length; ++i) {
            BPBlocks.cagedLamp[i] = new BlockLampSurface("cagelamp", false, MinecraftColor.VALID_COLORS[i], Refs.CAGELAMP_AABB);
        }
        cagedLampRGBInverted = new BlockLampRGBSurface("cagelamp", true, Refs.CAGELAMP_AABB).setWIP(true);
        for (i = 0; i < MinecraftColor.VALID_COLORS.length; ++i) {
            BPBlocks.cagedLampInverted[i] = new BlockLampSurface("cagelamp", true, MinecraftColor.VALID_COLORS[i], Refs.CAGELAMP_AABB);
        }
        allLamps.addAll(Arrays.asList(cagedLamp));
        allLamps.addAll(Arrays.asList(cagedLampInverted));
        allLamps.add(cagedLampRGB);
        allLamps.add(cagedLampRGBInverted);
        fixedLampRGB = new BlockLampRGBSurface("fixture", false, Refs.FIXTURELAMP_AABB).setWIP(true);
        for (i = 0; i < MinecraftColor.VALID_COLORS.length; ++i) {
            BPBlocks.fixedLamp[i] = new BlockLampSurface("fixture", false, MinecraftColor.VALID_COLORS[i], Refs.FIXTURELAMP_AABB);
        }
        fixedLampRGBInverted = new BlockLampRGBSurface("fixture", true, Refs.FIXTURELAMP_AABB).setWIP(true);
        for (i = 0; i < MinecraftColor.VALID_COLORS.length; ++i) {
            BPBlocks.fixedLampInverted[i] = new BlockLampSurface("fixture", true, MinecraftColor.VALID_COLORS[i], Refs.FIXTURELAMP_AABB);
        }
        allLamps.addAll(Arrays.asList(fixedLamp));
        allLamps.addAll(Arrays.asList(fixedLampInverted));
        allLamps.add(fixedLampRGB);
        allLamps.add(fixedLampRGBInverted);
        blockGateAND = (Block)new BlockGateBase("gate_and").setRegistryName("bluepower:gate_and");
        blockGateNAND = (Block)new BlockGateBase("gate_nand"){

            @Override
            public byte computeRedstone(byte back, byte left, byte right) {
                return (byte)(left == 0 || right == 0 || back == 0 ? 16 : 0);
            }
        }.setRegistryName("bluepower:gate_nand");
        blockAlloyWire = new Block[2];
        BPBlocks.blockAlloyWire[0] = new BlockAlloyWire(RedwireType.BLUESTONE.getName()).setWIP(true);
        BPBlocks.blockAlloyWire[1] = new BlockAlloyWire(RedwireType.RED_ALLOY.getName()).setWIP(true);
    }

    private static void initModDependantBlocks() {
        if (ModList.get().isLoaded("computercraft") || ModList.get().isLoaded("opencomputers")) {
            sortron = new BlockSortron();
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Block block : blockList) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
    }

    @SubscribeEvent
    public static void registerBlockItems(RegistryEvent.Register<Item> event) {
        for (Block block : blockList) {
            if (block.getRegistryName() == null || block instanceof BlockCrop) continue;
            if (block instanceof BlockBase && ((BlockBase)block).getWIP() || block instanceof BlockBPMultipart || block instanceof BlockTube) {
                event.getRegistry().register(new BlockItem(block, new Item.Properties()).setRegistryName(block.getRegistryName()));
                continue;
            }
            ItemGroup group = BPCreativeTabs.blocks;
            if (block instanceof BlockContainerBase) {
                group = BPCreativeTabs.machines;
            }
            if (block instanceof BlockLamp) {
                group = BPCreativeTabs.lighting;
            }
            if (block instanceof BlockAlloyWire) {
                group = BPCreativeTabs.wiring;
            }
            if (block instanceof BlockBlulectricCable) {
                group = BPCreativeTabs.wiring;
            }
            if (block instanceof BlockGateBase) {
                group = BPCreativeTabs.circuits;
            }
            if (block instanceof IBPPartBlock) {
                event.getRegistry().register(new ItemBPPart(block, new Item.Properties().func_200916_a(group)).setRegistryName(block.getRegistryName()));
                continue;
            }
            event.getRegistry().register(new BlockItem(block, new Item.Properties().func_200916_a(group)).setRegistryName(block.getRegistryName()));
        }
    }

    static {
        project_tables = new Block[2];
    }
}

