/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.recipe;

import com.bluepowermod.BluePower;
import com.bluepowermod.api.recipe.IAlloyFurnaceRecipe;
import com.bluepowermod.api.recipe.IAlloyFurnaceRegistry;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.init.BPConfig;
import com.bluepowermod.init.BPRecipeSerializer;
import com.bluepowermod.tile.tier1.TileAlloyFurnace;
import com.bluepowermod.util.DatapackUtils;
import com.bluepowermod.util.ItemStackUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class AlloyFurnaceRegistry
implements IAlloyFurnaceRegistry {
    private static AlloyFurnaceRegistry INSTANCE = new AlloyFurnaceRegistry();
    public static final IRecipeType ALLOYFURNACE_RECIPE = IRecipeType.func_222147_a((String)"bluepower:alloy_smelting");
    private List<IAlloyFurnaceRecipe> alloyFurnaceRecipes = new ArrayList<IAlloyFurnaceRecipe>();
    private List<ItemStack> bufferedRecyclingItems = new ArrayList<ItemStack>();
    private Map<ItemStack, ItemStack> moltenDownMap = new HashMap<ItemStack, ItemStack>();
    private List<String> blacklist = new ArrayList<String>();

    private AlloyFurnaceRegistry() {
    }

    public static AlloyFurnaceRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public void addRecipe(IAlloyFurnaceRecipe recipe) {
        this.alloyFurnaceRecipes.add(recipe);
    }

    public void generateRecipeDatapack(MinecraftServer server) {
        if (server != null) {
            String path = server.func_240776_a_(FolderName.field_237251_g_).toString();
            DatapackUtils.createBPDatapack(path);
            DatapackUtils.clearBPAlloyFurnaceDatapack(path);
            for (IAlloyFurnaceRecipe recipe : this.alloyFurnaceRecipes) {
                DatapackUtils.generateAlloyFurnaceRecipe(recipe, path);
            }
        }
    }

    @Override
    public void addRecipe(ResourceLocation resourceLocation, ItemStack craftingResult, Ingredient ... requiredItems) {
        if (craftingResult == null || craftingResult.func_77973_b() == Items.field_190931_a) {
            throw new NullPointerException("Can't register an Alloy Furnace recipe with a null output stack or item");
        }
        if (craftingResult.func_190926_b()) {
            throw new NullPointerException("Can't register an Alloy Furnace recipe with a invalid output stack or item");
        }
        NonNullList requiredStacks = NonNullList.func_191196_a();
        NonNullList requiredCount = NonNullList.func_191196_a();
        for (Ingredient requiredItem : requiredItems) {
            requiredStacks.add((Object)requiredItem);
            requiredCount.add((Object)1);
        }
        this.addRecipe(new StandardAlloyFurnaceRecipe(resourceLocation, "", craftingResult, requiredStacks, requiredCount));
    }

    @Override
    public void addRecyclingRecipe(ItemStack recycledItem, String ... blacklist) {
        if (recycledItem.func_190926_b()) {
            throw new NullPointerException("Recycled item can't be null!");
        }
        this.bufferedRecyclingItems.add(recycledItem);
        if (blacklist.length > 0) {
            BluePower.log.info("Added to the Alloy Furnace recycling blacklist: " + Arrays.toString(blacklist));
            Collections.addAll(this.blacklist, blacklist);
        }
    }

    @Override
    public void addRecyclingRecipe(ItemStack recycledItem, ItemStack moltenDownItem, String ... blacklist) {
        if (moltenDownItem.func_190926_b()) {
            throw new NullPointerException("Molten down item can't be null!");
        }
        this.addRecyclingRecipe(recycledItem, blacklist);
        this.moltenDownMap.put(recycledItem, moltenDownItem);
    }

    public void generateRecyclingRecipes(RecipeManager recipeManager) {
        this.blacklist = Arrays.asList(((String)BPConfig.CONFIG.alloyFurnaceBlacklist.get()).split(","));
        ArrayList<Item> blacklist = new ArrayList<Item>();
        for (String configString : this.blacklist) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(configString));
            if (item != null) {
                blacklist.add(item);
                continue;
            }
            BluePower.log.info("BPConfig entry \"" + configString + "\" not an existing item/block name! Will not be added to the blacklist");
        }
        for (IRecipe recipe : recipeManager.func_199510_b()) {
            ArrayList<ItemStack> registeredRecycledItems = new ArrayList<ItemStack>();
            ArrayList<ItemStack> registeredResultItems = new ArrayList<ItemStack>();
            int recyclingAmount = 0;
            ItemStack currentlyRecycledInto = ItemStack.field_190927_a;
            for (ItemStack recyclingItem : this.bufferedRecyclingItems) {
                try {
                    if (!(recipe instanceof ICraftingRecipe) || recipe.func_192400_c().isEmpty()) continue;
                    for (Ingredient input : ((ICraftingRecipe)recipe).func_192400_c()) {
                        Ingredient ingredient;
                        if (input.func_203189_d() || !(ingredient = Ingredient.func_199802_a((JsonElement)input.func_200304_c())).test(recyclingItem)) continue;
                        ItemStack moltenDownItem = this.getRecyclingStack(recyclingItem);
                        if (!currentlyRecycledInto.func_190926_b() && !ItemStackUtils.isItemFuzzyEqual(currentlyRecycledInto, moltenDownItem)) continue;
                        currentlyRecycledInto = moltenDownItem;
                        recyclingAmount += moltenDownItem.func_190916_E();
                    }
                }
                catch (Throwable e) {
                    BluePower.log.error("Error when generating an Alloy Furnace recipe for item " + recyclingItem.func_200301_q() + ", recipe output: " + recipe.func_77571_b().func_200301_q());
                    e.printStackTrace();
                }
            }
            if (recyclingAmount > 0 && recipe.func_77571_b().func_190916_E() > 0) {
                if (blacklist.contains(recipe.func_77571_b().func_77973_b())) {
                    BluePower.log.info("Skipped adding item/block " + recipe.func_77571_b().func_200301_q() + " to the Alloy Furnace recipes.");
                    continue;
                }
                ItemStack resultItem = new ItemStack((IItemProvider)currentlyRecycledInto.func_77973_b(), Math.min(64, recyclingAmount / recipe.func_77571_b().func_190916_E()));
                registeredResultItems.add(resultItem);
                registeredRecycledItems.add(recipe.func_77571_b());
            }
            for (int i = 0; i < registeredResultItems.size(); ++i) {
                if (((ItemStack)registeredResultItems.get(i)).func_190916_E() <= 0) continue;
                this.addRecipe(((ItemStack)registeredResultItems.get(i)).func_77973_b().getRegistryName(), (ItemStack)registeredResultItems.get(i), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)registeredRecycledItems.get(i)}));
            }
        }
    }

    private ItemStack getRecyclingStack(ItemStack original) {
        ItemStack moltenDownStack = this.moltenDownMap.get(original);
        return moltenDownStack != null ? moltenDownStack : original;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<IAlloyFurnaceRecipe> {
        public IAlloyFurnaceRecipe read(ResourceLocation recipeId, JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> nonnulllist = Serializer.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            NonNullList<Integer> countlist = Serializer.readCount(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for alloy furnace recipe");
            }
            if (nonnulllist.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe the max is 9");
            }
            ItemStack itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new StandardAlloyFurnaceRecipe(recipeId, s, itemstack, nonnulllist, countlist);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray jsonArray) {
            NonNullList nonnulllist = NonNullList.func_191196_a();
            for (int i = 0; i < jsonArray.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)jsonArray.get(i));
                if (ingredient.func_203189_d()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        private static NonNullList<Integer> readCount(JsonArray jsonArray) {
            NonNullList countlist = NonNullList.func_191196_a();
            for (int i = 0; i < jsonArray.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)jsonArray.get(i));
                int count = jsonArray.get(i).isJsonObject() && ((JsonObject)jsonArray.get(i)).has("count") ? ((JsonObject)jsonArray.get(i)).get("count").getAsInt() : 1;
                if (ingredient.func_203189_d()) continue;
                countlist.add(i, (Object)count);
            }
            return countlist;
        }

        public IAlloyFurnaceRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            int j;
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            int i = buffer.func_150792_a();
            NonNullList nonnulllist = NonNullList.func_191197_a((int)i, (Object)Ingredient.field_193370_a);
            NonNullList countlist = NonNullList.func_191197_a((int)i, (Object)0);
            for (j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            for (j = 0; j < nonnulllist.size(); ++j) {
                countlist.set(j, (Object)buffer.readInt());
            }
            ItemStack itemstack = buffer.func_150791_c();
            return new StandardAlloyFurnaceRecipe(recipeId, s, itemstack, nonnulllist, countlist);
        }

        public void write(PacketBuffer buffer, IAlloyFurnaceRecipe recipe) {
            if (recipe instanceof StandardAlloyFurnaceRecipe) {
                buffer.func_180714_a(((StandardAlloyFurnaceRecipe)recipe).group);
                buffer.func_150787_b(((StandardAlloyFurnaceRecipe)recipe).requiredItems.size());
                for (Ingredient ingredient : ((StandardAlloyFurnaceRecipe)recipe).requiredItems) {
                    ingredient.func_199564_a(buffer);
                }
                Iterator iterator = ((StandardAlloyFurnaceRecipe)recipe).requiredCount.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    buffer.writeInt(i);
                }
                buffer.func_150788_a(((StandardAlloyFurnaceRecipe)recipe).craftingResult);
            }
        }
    }

    public static class StandardAlloyFurnaceRecipe
    implements IAlloyFurnaceRecipe {
        private final ItemStack craftingResult;
        private final NonNullList<Ingredient> requiredItems;
        private final NonNullList<Integer> requiredCount;
        private final ResourceLocation id;
        private final String group;

        private StandardAlloyFurnaceRecipe(ResourceLocation id, String group, ItemStack craftingResult, NonNullList<Ingredient> requiredItems, NonNullList<Integer> requiredCount) {
            if (craftingResult == null || craftingResult.func_190926_b()) {
                throw new IllegalArgumentException("Alloy Furnace crafting result can't be null!");
            }
            if (requiredItems.size() > 9) {
                throw new IllegalArgumentException("There can't be more than 9 crafting ingredients for the Alloy Furnace!");
            }
            for (Ingredient requiredItem : requiredItems) {
                if (!requiredItem.func_203189_d()) continue;
                throw new NullPointerException("An Alloy Furnace crafting ingredient can't be null!");
            }
            this.craftingResult = craftingResult;
            this.requiredItems = requiredItems;
            this.requiredCount = requiredCount;
            this.id = id;
            this.group = group;
        }

        public boolean matches(ISidedInventory inv, World worldIn) {
            NonNullList input = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
            if (inv instanceof TileAlloyFurnace) {
                for (int i = 2; i < 11; ++i) {
                    input.set(i - 2, (Object)inv.func_70301_a(i));
                }
            } else {
                for (int i = 1; i < 10; ++i) {
                    input.set(i - 1, (Object)inv.func_70301_a(i));
                }
            }
            return this.matches((NonNullList<ItemStack>)input);
        }

        public ItemStack getCraftingResult(ISidedInventory inv) {
            NonNullList input = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
            if (inv instanceof TileAlloyFurnace) {
                for (int i = 2; i < 12; ++i) {
                    input.set(i - 2, (Object)inv.func_70301_a(i));
                }
            } else {
                for (int i = 1; i < 11; ++i) {
                    input.set(i - 1, (Object)inv.func_70301_a(i));
                }
            }
            return this.getCraftingResult((NonNullList<ItemStack>)input);
        }

        public boolean func_194133_a(int width, int height) {
            return width <= 3 && height <= 3;
        }

        public ItemStack func_77571_b() {
            return this.craftingResult;
        }

        public ResourceLocation func_199560_c() {
            return this.id;
        }

        public String func_193358_e() {
            return this.group;
        }

        public ItemStack func_222128_h() {
            return new ItemStack((IItemProvider)BPBlocks.alloyfurnace);
        }

        public IRecipeSerializer<?> func_199559_b() {
            return BPRecipeSerializer.ALLOYSMELTING;
        }

        public IRecipeType<?> func_222127_g() {
            return ALLOYFURNACE_RECIPE;
        }

        @Override
        public boolean matches(NonNullList<ItemStack> input) {
            for (int i = 0; i < this.requiredItems.size(); ++i) {
                int itemsNeeded = (Integer)this.requiredCount.get(i);
                for (ItemStack inputStack : input) {
                    if (!((Ingredient)this.requiredItems.get(i)).test(inputStack) || (itemsNeeded -= inputStack.func_190916_E()) > 0) continue;
                    break;
                }
                if (itemsNeeded <= 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public void useItems(NonNullList<ItemStack> input) {
            for (int j = 0; j < this.requiredItems.size(); ++j) {
                int itemsNeeded = (Integer)this.requiredCount.get(j);
                for (int i = 0; i < input.size(); ++i) {
                    ItemStack inputStack = (ItemStack)input.get(i);
                    if (!((Ingredient)this.requiredItems.get(j)).test(inputStack)) continue;
                    int itemsSubstracted = Math.min(inputStack.func_190916_E(), itemsNeeded);
                    inputStack.func_190920_e(inputStack.func_190916_E() - itemsSubstracted);
                    if (inputStack.func_190916_E() <= 0) {
                        input.set(i, (Object)ItemStack.field_190927_a);
                    }
                    if ((itemsNeeded -= itemsSubstracted) <= 0) break;
                }
                if (itemsNeeded <= 0) continue;
                throw new IllegalArgumentException("Alloy Furnace recipe using items, after using still items required?? This is a bug!");
            }
        }

        @Override
        public ItemStack getCraftingResult(NonNullList<ItemStack> input) {
            return this.craftingResult;
        }

        @Override
        public NonNullList<Ingredient> getRequiredItems() {
            return this.requiredItems;
        }

        @Override
        public NonNullList<Integer> getRequiredCount() {
            return this.requiredCount;
        }
    }
}

