/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier1;

import com.bluepowermod.BluePower;
import com.bluepowermod.block.BlockContainerFacingBase;
import com.bluepowermod.container.ContainerDeployer;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.tile.BPTileEntityType;
import com.bluepowermod.tile.IEjectAnimator;
import com.bluepowermod.tile.TileBase;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class TileDeployer
extends TileBase
implements ISidedInventory,
IEjectAnimator,
INamedContainerProvider {
    private static final List<Item> blacklistedItems = new ArrayList<Item>();
    private static final GameProfile FAKE_PLAYER_PROFILE = new GameProfile(UUID.randomUUID(), "[BP Deployer]");
    public static final int SLOTS = 10;
    private final NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)10, (Object)ItemStack.field_190927_a);

    public TileDeployer() {
        super(BPTileEntityType.DEPLOYER);
    }

    private boolean canDeployItem(ItemStack stack) {
        return !stack.func_190926_b() && !blacklistedItems.contains(stack.func_77973_b());
    }

    @Override
    protected void redstoneChanged(boolean newValue) {
        super.redstoneChanged(newValue);
        if (!this.field_145850_b.field_72995_K && newValue) {
            ItemStack stack;
            int i;
            this.sendUpdatePacket();
            FakePlayer player = FakePlayerFactory.get((ServerWorld)((ServerWorld)this.field_145850_b), (GameProfile)FAKE_PLAYER_PROFILE);
            for (i = 0; i < this.inventory.size(); ++i) {
                stack = (ItemStack)this.inventory.get(i);
                player.field_71071_by.func_70299_a(i, stack);
            }
            this.rightClick(player, 9);
            for (i = 0; i < this.inventory.size(); ++i) {
                stack = player.field_71071_by.func_70301_a(i);
                if (stack.func_190926_b() || stack.func_190916_E() <= 0) {
                    this.inventory.set(i, (Object)ItemStack.field_190927_a);
                } else {
                    this.inventory.set(i, (Object)stack);
                }
                player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
            }
            for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                stack = player.field_71071_by.func_70301_a(i);
                if (stack.func_190926_b() || stack.func_190916_E() <= 0) continue;
                ItemStack remainder = IOHelper.insert(this, stack, this.getFacingDirection().func_176734_d(), false);
                if (!remainder.func_190926_b()) {
                    this.field_145850_b.func_217376_c((Entity)new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, remainder));
                }
                player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
            }
        }
    }

    protected boolean rightClick(FakePlayer player, int useItems) {
        if (useItems > 9) {
            throw new IllegalArgumentException("Hotbar is 9 items in width! You're trying " + useItems + "!");
        }
        Direction faceDir = this.getFacingDirection();
        int dx = faceDir.func_82601_c();
        int dy = faceDir.func_96559_d();
        int dz = faceDir.func_82599_e();
        int x = this.field_174879_c.func_177958_n() + dx;
        int y = this.field_174879_c.func_177956_o() + dy;
        int z = this.field_174879_c.func_177952_p() + dz;
        player.func_70107_b((double)x + 0.5, (double)y + 0.5 - (double)player.func_70047_e(), (double)z + 0.5);
        player.field_70125_A = faceDir.func_96559_d() * -90;
        switch (faceDir) {
            case NORTH: {
                player.field_70177_z = 180.0f;
                break;
            }
            case SOUTH: {
                player.field_70177_z = 0.0f;
                break;
            }
            case WEST: {
                player.field_70177_z = 90.0f;
                break;
            }
            case EAST: {
                player.field_70177_z = -90.0f;
            }
        }
        try {
            ItemStack stack;
            int i;
            Entity entity;
            PlayerInteractEvent.RightClickEmpty event = new PlayerInteractEvent.RightClickEmpty((PlayerEntity)player, Hand.MAIN_HAND);
            if (event.isCanceled()) {
                return false;
            }
            Block block = this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            List detectedEntities = this.field_145850_b.func_217357_a(LivingEntity.class, new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)));
            Entity entity2 = entity = detectedEntities.isEmpty() ? null : (Entity)detectedEntities.get(this.field_145850_b.field_73012_v.nextInt(detectedEntities.size()));
            if (entity != null) {
                for (i = 0; i < useItems; ++i) {
                    player.field_71071_by.field_70461_c = i;
                    stack = player.func_184614_ca();
                    if (this.canDeployItem(stack) && stack.func_77973_b().func_111207_a(stack, (PlayerEntity)player, (LivingEntity)entity, Hand.MAIN_HAND).func_226247_b_()) {
                        return true;
                    }
                    if (!(entity instanceof AnimalEntity) || !((AnimalEntity)entity).func_230254_b_((PlayerEntity)player, Hand.MAIN_HAND).func_226247_b_()) continue;
                    return true;
                }
            }
            for (i = 0; i < useItems; ++i) {
                player.field_71071_by.field_70461_c = i;
                stack = player.func_184614_ca();
                if (!this.canDeployItem(stack) || stack.func_77973_b().onItemUseFirst(stack, new ItemUseContext((PlayerEntity)player, Hand.MAIN_HAND, new BlockRayTraceResult(new Vector3d((double)dx, (double)dy, (double)dz), faceDir, new BlockPos(x, y, z), false))) != ActionResultType.SUCCESS) continue;
                return true;
            }
            for (i = 0; i < useItems; ++i) {
                player.field_71071_by.field_70461_c = i;
                if (this.field_145850_b.func_175623_d(new BlockPos(x, y, z)) || block.func_225533_a_(this.field_145850_b.func_180495_p(new BlockPos(x, y, z)), this.field_145850_b, new BlockPos(x, y, z), (PlayerEntity)player, Hand.MAIN_HAND, new BlockRayTraceResult(new Vector3d((double)dx, (double)dy, (double)dz), faceDir, new BlockPos(x, y, z), false)) != ActionResultType.SUCCESS) continue;
                return true;
            }
            for (i = 0; i < useItems; ++i) {
                int useZ;
                player.field_71071_by.field_70461_c = i;
                stack = player.func_184614_ca();
                boolean isGoingToShift = false;
                if (!(stack.func_190926_b() || stack.func_77973_b() != Items.field_222065_kN && stack.func_77973_b() != Items.field_151137_ax)) {
                    isGoingToShift = true;
                }
                int useX = isGoingToShift ? this.field_174879_c.func_177958_n() : x;
                int useY = isGoingToShift ? this.field_174879_c.func_177956_o() : y;
                int n = useZ = isGoingToShift ? this.field_174879_c.func_177952_p() : z;
                if (!this.canDeployItem(stack) || stack.func_77973_b().func_195939_a(new ItemUseContext((PlayerEntity)player, Hand.MAIN_HAND, new BlockRayTraceResult(new Vector3d((double)dx, (double)dy, (double)dz), faceDir, new BlockPos(x, y, z), false))) != ActionResultType.SUCCESS) continue;
                return true;
            }
            for (i = 0; i < useItems; ++i) {
                player.field_71071_by.field_70461_c = i;
                stack = player.func_184614_ca();
                if (!this.canDeployItem(stack)) continue;
                ItemStack copy = stack.func_77946_l();
                player.func_184611_a(Hand.MAIN_HAND, (ItemStack)stack.func_77973_b().func_77659_a(this.field_145850_b, (PlayerEntity)player, Hand.MAIN_HAND).func_188398_b());
                if (copy.func_77969_a(stack)) continue;
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            BluePower.log.error("Deployer crashed! Stacktrace: ");
            e.printStackTrace();
            return true;
        }
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT tCompound) {
        super.func_230337_a_(blockState, tCompound);
        for (int i = 0; i < 9; ++i) {
            CompoundNBT tc = tCompound.func_74775_l("inventory" + i);
            this.inventory.set(i, (Object)ItemStack.func_199557_a((CompoundNBT)tc));
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tCompound) {
        super.func_189515_b(tCompound);
        for (int i = 0; i < 9; ++i) {
            CompoundNBT tc = new CompoundNBT();
            ((ItemStack)this.inventory.get(i)).func_77955_b(tc);
            tCompound.func_218657_a("inventory" + i, (INBT)tc);
        }
        return tCompound;
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public ItemStack func_70301_a(int i) {
        return (ItemStack)this.inventory.get(i);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (!itemStack.func_190926_b()) {
            if (itemStack.func_190916_E() <= amount) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            } else if ((itemStack = itemStack.func_77979_a(amount)).func_190916_E() == 0) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int i) {
        return this.func_70301_a(i);
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.inventory.set(i, (Object)itemStack);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return player.func_233580_cy_().func_218141_a((Vector3i)this.field_174879_c, 64.0);
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return true;
    }

    @Override
    public NonNullList<ItemStack> getDrops() {
        NonNullList<ItemStack> drops = super.getDrops();
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            drops.add((Object)stack);
        }
        return drops;
    }

    public int[] func_180463_a(Direction side) {
        Direction direction = this.getFacingDirection();
        if (side == direction) {
            return new int[0];
        }
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        for (int i : this.func_180463_a(direction)) {
            if (index != i) continue;
            return true;
        }
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        for (int i : this.func_180463_a(direction)) {
            if (index != i) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEjecting() {
        return (Boolean)this.func_195044_w().func_177229_b((Property)BlockContainerFacingBase.ACTIVE);
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    public boolean func_191420_l() {
        return this.inventory.size() == 0;
    }

    public void func_174888_l() {
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("deployer");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity playerEntity) {
        return new ContainerDeployer(id, inventory, (IInventory)this);
    }

    static {
        blacklistedItems.add(Items.field_151079_bi);
    }
}

