/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier3;

import com.bluepowermod.api.item.IDatabaseSaveable;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.helper.ItemStackDatabase;
import com.bluepowermod.init.BPConfig;
import com.bluepowermod.tile.tier2.TileCircuitTable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TileCircuitDatabase
extends TileCircuitTable {
    public IInventory copyInventory = new Inventory(2){

        public void func_70299_a(int slot, ItemStack itemStack) {
            super.func_70299_a(slot, itemStack);
            if (slot == 0 && !itemStack.func_190926_b()) {
                TileCircuitDatabase.this.nameTextField = itemStack.func_200301_q().getString();
            }
        }
    };
    public int clientCurrentTab;
    public int curUploadProgress;
    public int curCopyProgress;
    public int selectedShareOption;
    public static final int UPLOAD_AND_COPY_TIME = 20;
    public final ItemStackDatabase stackDatabase = new ItemStackDatabase();
    public static List<ItemStack> serverDatabaseStacks = new ArrayList<ItemStack>();
    private PlayerEntity triggeringPlayer;
    public String nameTextField = "";

    public static boolean hasPermissions(PlayerEntity player) {
        if (((Boolean)BPConfig.CONFIG.serverCircuitSavingOpOnly.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    @Override
    public void setText(int textFieldID, String text) {
        if (textFieldID == 1) {
            this.nameTextField = text;
            if (!this.copyInventory.func_70301_a(0).func_190926_b()) {
                this.copyInventory.func_70301_a(0).func_200302_a((ITextComponent)new StringTextComponent(this.nameTextField));
            }
        } else {
            super.setText(textFieldID, text);
        }
    }

    @Override
    public String getText(int textFieldID) {
        return textFieldID == 1 ? this.nameTextField : super.getText(textFieldID);
    }

    public boolean copy(PlayerEntity player, ItemStack template, ItemStack target, boolean simulate) {
        IDatabaseSaveable saveable;
        if (!template.func_190926_b() && !target.func_190926_b() && template.func_77969_a(target) && (saveable = (IDatabaseSaveable)template.func_77973_b()).canCopy(template, target)) {
            if (!player.func_184812_l_()) {
                List<ItemStack> stacksInTemplate = saveable.getItemsOnStack(template);
                List<ItemStack> stacksInOutput = saveable.getItemsOnStack(target);
                if (stacksInTemplate.isEmpty()) {
                    stacksInTemplate = new ArrayList<ItemStack>();
                }
                if (stacksInOutput.isEmpty()) {
                    stacksInOutput = new ArrayList<ItemStack>();
                }
                ArrayList<ItemStack> traversedItems = new ArrayList<ItemStack>();
                ArrayList<ItemStack> allApplicableItems = new ArrayList<ItemStack>();
                allApplicableItems.addAll(stacksInTemplate);
                allApplicableItems.addAll(stacksInOutput);
                for (ItemStack templateStack : allApplicableItems) {
                    boolean alreadyTraversed = false;
                    for (ItemStack itemStack : traversedItems) {
                        if (!itemStack.func_77969_a(templateStack) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)templateStack)) continue;
                        alreadyTraversed = true;
                        break;
                    }
                    if (alreadyTraversed) continue;
                    traversedItems.add(templateStack);
                    int count = 0;
                    for (ItemStack stack : stacksInTemplate) {
                        if (!stack.func_77969_a(templateStack) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)templateStack)) continue;
                        count += stack.func_190916_E();
                    }
                    for (ItemStack stack : stacksInOutput) {
                        if (!stack.func_77969_a(templateStack) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)templateStack)) continue;
                        count -= stack.func_190916_E();
                    }
                    if ((count *= target.func_190916_E()) > 0) {
                        ItemStack itemStack = templateStack.func_77946_l();
                        itemStack.func_190920_e(count);
                        ItemStack itemStack2 = IOHelper.extract(this, null, itemStack, true, simulate, 2);
                        if (!itemStack2.func_190926_b() && itemStack2.func_190916_E() >= count) continue;
                        return false;
                    }
                    if (count >= 0) continue;
                    ItemStack itemStack = templateStack.func_77946_l();
                    itemStack.func_190920_e(-count);
                    ItemStack itemStack3 = IOHelper.insert(this, itemStack, null, simulate);
                    if (itemStack3.func_190926_b() || simulate) continue;
                    IOHelper.spawnItemInWorld(this.field_145850_b, itemStack3, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
                }
            }
            if (!simulate) {
                ItemStack copyStack = template.func_77946_l();
                copyStack.func_190920_e(target.func_190916_E());
                this.copyInventory.func_70299_a(1, copyStack);
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.copyInventory.func_70301_a(0).func_190926_b()) {
                if (this.curCopyProgress >= 0 && ++this.curCopyProgress > 20) {
                    this.curCopyProgress = -1;
                    if (this.copy(this.triggeringPlayer, this.copyInventory.func_70301_a(0), this.copyInventory.func_70301_a(1), true)) {
                        this.copy(this.triggeringPlayer, this.copyInventory.func_70301_a(0), this.copyInventory.func_70301_a(1), false);
                    }
                }
                if (this.curUploadProgress >= 0 && ++this.curUploadProgress > 20) {
                    this.curUploadProgress = -1;
                    if (this.selectedShareOption == 1 && this.triggeringPlayer != null && this.selectedShareOption == 2) {
                        this.stackDatabase.saveItemStack(this.copyInventory.func_70301_a(0));
                    }
                    this.selectedShareOption = 0;
                }
            } else {
                this.curCopyProgress = -1;
                this.curUploadProgress = -1;
                this.selectedShareOption = 0;
            }
        }
    }

    public void saveToPrivateLibrary(ItemStack stack) {
        this.stackDatabase.saveItemStack(stack);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        CompoundNBT stackTag;
        super.func_189515_b(tag);
        if (!this.copyInventory.func_70301_a(0).func_190926_b()) {
            stackTag = new CompoundNBT();
            this.copyInventory.func_70301_a(0).func_77955_b(stackTag);
            tag.func_218657_a("copyTemplateStack", (INBT)stackTag);
        }
        if (!this.copyInventory.func_70301_a(1).func_190926_b()) {
            stackTag = new CompoundNBT();
            this.copyInventory.func_70301_a(1).func_77955_b(stackTag);
            tag.func_218657_a("copyOutputStack", (INBT)stackTag);
        }
        tag.func_74768_a("curUploadProgress", this.curUploadProgress);
        tag.func_74768_a("curCopyProgress", this.curCopyProgress);
        tag.func_74774_a("selectedShareOption", (byte)this.selectedShareOption);
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        if (tag.func_74764_b("copyTemplateStack")) {
            this.copyInventory.func_70299_a(0, ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("copyTemplateStack")));
        } else {
            this.copyInventory.func_70299_a(0, ItemStack.field_190927_a);
        }
        if (tag.func_74764_b("copyOutputStack")) {
            this.copyInventory.func_70299_a(1, ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("copyOutputStack")));
        } else {
            this.copyInventory.func_70299_a(1, ItemStack.field_190927_a);
        }
        this.curUploadProgress = tag.func_74762_e("curUploadProgress");
        this.curCopyProgress = tag.func_74762_e("curCopyProgress");
        this.selectedShareOption = tag.func_74771_c("selectedShareOption");
    }
}

