/*
 * Decompiled with CFR 0.152.
 */
package astavie.bookdisplay;

import astavie.bookdisplay.EventHandler;
import astavie.bookdisplay.wrapper.IBookWrapper;
import astavie.bookdisplay.wrapper.bibliocraft.BiblioCraftWrapper;
import astavie.bookdisplay.wrapper.botania.BotaniaWrapper;
import astavie.bookdisplay.wrapper.immersiveengineering.IEWrapper;
import astavie.bookdisplay.wrapper.mantle.MantleWrapper;
import astavie.bookdisplay.wrapper.minecraft.VanillaWrapper;
import astavie.bookdisplay.wrapper.opencomputers.OCWrapper;
import astavie.bookdisplay.wrapper.patchouli.PatchouliWrapper;
import astavie.bookdisplay.wrapper.tis3d.TIS3DWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;

@Mod(modid="bookdisplay", name="Book Display", clientSideOnly=true, acceptedMinecraftVersions="[1.12.2]")
public class BookDisplay {
    static final KeyBinding key = new KeyBinding("key.bookdisplay.display", 19, "key.categories.book");
    static final KeyBinding left = new KeyBinding("key.bookdisplay.left", 203, "key.categories.book");
    static final KeyBinding right = new KeyBinding("key.bookdisplay.right", 205, "key.categories.book");
    private static final Map<Predicate<ItemStack>, Function<ItemStack, IBookWrapper>> registry = new HashMap<Predicate<ItemStack>, Function<ItemStack, IBookWrapper>>();

    public static void register(Predicate<ItemStack> predicate, Function<ItemStack, IBookWrapper> factory) {
        registry.put(predicate, factory);
    }

    static boolean has(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (Map.Entry<Predicate<ItemStack>, Function<ItemStack, IBookWrapper>> entry : registry.entrySet()) {
            if (!entry.getKey().test(stack)) continue;
            return true;
        }
        return false;
    }

    static IBookWrapper find(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        for (Map.Entry<Predicate<ItemStack>, Function<ItemStack, IBookWrapper>> entry : registry.entrySet()) {
            if (!entry.getKey().test(stack)) continue;
            return entry.getValue().apply(stack);
        }
        return null;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        key.setKeyConflictContext((IKeyConflictContext)KeyConflictContext.IN_GAME);
        left.setKeyConflictContext((IKeyConflictContext)KeyConflictContext.IN_GAME);
        right.setKeyConflictContext((IKeyConflictContext)KeyConflictContext.IN_GAME);
        ClientRegistry.registerKeyBinding((KeyBinding)key);
        ClientRegistry.registerKeyBinding((KeyBinding)left);
        ClientRegistry.registerKeyBinding((KeyBinding)right);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        BookDisplay.register(item -> item.func_77973_b() == Items.field_151099_bA || item.func_77973_b() == Items.field_151164_bB, VanillaWrapper::new);
        if (Loader.isModLoaded((String)"bibliocraft")) {
            BiblioCraftWrapper.register();
        }
        if (Loader.isModLoaded((String)"botania")) {
            BotaniaWrapper.register();
        }
        if (Loader.isModLoaded((String)"immersiveengineering")) {
            IEWrapper.register();
        }
        if (Loader.isModLoaded((String)"mantle")) {
            MantleWrapper.register();
        }
        if (Loader.isModLoaded((String)"opencomputers")) {
            OCWrapper.register();
        }
        if (Loader.isModLoaded((String)"tis3d")) {
            TIS3DWrapper.register();
        }
        if (Loader.isModLoaded((String)"patchouli")) {
            PatchouliWrapper.register();
        }
    }
}

