/*
 * Decompiled with CFR 0.152.
 */
package astavie.bookdisplay;

import astavie.bookdisplay.BookDisplay;
import astavie.bookdisplay.wrapper.BookWrapper;
import astavie.bookdisplay.wrapper.IBookWrapper;
import astavie.bookdisplay.wrapper.mantle.MantleWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;

public class EventHandler {
    private boolean enabled = false;
    private Pair<ItemStack, IBookWrapper> mainhand;
    private Pair<ItemStack, IBookWrapper> offhand;
    private int cachedWidth;
    private int cachedHeight;

    private void mainhand() {
        EntityPlayerSP player;
        ItemStack stack;
        IBookWrapper wrapper;
        if (this.mainhand != null) {
            ((IBookWrapper)this.mainhand.getRight()).onClose();
        }
        if ((wrapper = BookDisplay.find(stack = (player = Minecraft.func_71410_x().field_71439_g).func_184614_ca().func_77946_l())) != null) {
            ScaledResolution size = new ScaledResolution(Minecraft.func_71410_x());
            wrapper.setSize(size.func_78326_a(), size.func_78328_b(), player.func_184591_cq());
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
            wrapper.onOpen();
            this.mainhand = Pair.of((Object)stack, (Object)wrapper);
        } else {
            this.mainhand = null;
        }
    }

    private void offhand() {
        EntityPlayerSP player;
        ItemStack stack;
        IBookWrapper wrapper;
        if (this.offhand != null) {
            ((IBookWrapper)this.offhand.getRight()).onClose();
        }
        if ((wrapper = BookDisplay.find(stack = (player = Minecraft.func_71410_x().field_71439_g).func_184592_cb().func_77946_l())) != null) {
            ScaledResolution size = new ScaledResolution(Minecraft.func_71410_x());
            wrapper.setSize(size.func_78326_a(), size.func_78328_b(), player.func_184591_cq().func_188468_a());
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
            wrapper.onOpen();
            this.offhand = Pair.of((Object)stack, (Object)wrapper);
        } else {
            this.offhand = null;
        }
    }

    @SubscribeEvent
    public void onKey(InputEvent.KeyInputEvent event) {
        if (BookDisplay.key.func_151468_f()) {
            if (this.shouldDisplay()) {
                this.disable();
            } else {
                this.enable();
            }
        }
        if (this.shouldDisplay()) {
            if (BookDisplay.left.func_151468_f()) {
                if (this.mainhand != null) {
                    ((IBookWrapper)this.mainhand.getRight()).left();
                }
                if (this.offhand != null) {
                    ((IBookWrapper)this.offhand.getRight()).left();
                }
            }
            if (BookDisplay.right.func_151468_f()) {
                if (this.mainhand != null) {
                    ((IBookWrapper)this.mainhand.getRight()).right();
                }
                if (this.offhand != null) {
                    ((IBookWrapper)this.offhand.getRight()).right();
                }
            }
        }
    }

    private void disable() {
        if (this.mainhand != null) {
            ((IBookWrapper)this.mainhand.getRight()).onClose();
        }
        if (this.offhand != null) {
            ((IBookWrapper)this.offhand.getRight()).onClose();
        }
        this.mainhand = null;
        this.offhand = null;
        this.enabled = false;
    }

    private void enable() {
        this.mainhand();
        this.offhand();
        this.enabled = true;
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.CLIENT && event.phase == TickEvent.Phase.END && this.shouldDisplay()) {
            if (this.mainhand == null && !event.player.func_184614_ca().func_190926_b() || this.mainhand != null && !ItemStack.func_77989_b((ItemStack)((ItemStack)this.mainhand.getLeft()), (ItemStack)event.player.func_184614_ca())) {
                Minecraft.func_71410_x().func_152344_a(this::mainhand);
            }
            if (this.offhand == null && !event.player.func_184592_cb().func_190926_b() || this.offhand != null && !ItemStack.func_77989_b((ItemStack)((ItemStack)this.offhand.getLeft()), (ItemStack)event.player.func_184592_cb())) {
                Minecraft.func_71410_x().func_152344_a(this::offhand);
            }
            if (this.mainhand != null) {
                ((IBookWrapper)this.mainhand.getRight()).onTick();
            }
            if (this.offhand != null) {
                ((IBookWrapper)this.offhand.getRight()).onTick();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDrawBackground(GuiScreenEvent.BackgroundDrawnEvent event) {
        BookWrapper.onDrawBackground();
    }

    private boolean shouldDisplay() {
        return this.enabled;
    }

    @SubscribeEvent
    public void onOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && this.shouldDisplay()) {
            ScaledResolution size = new ScaledResolution(Minecraft.func_71410_x());
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (this.mainhand != null) {
                GlStateManager.func_179094_E();
                if (this.cachedWidth != size.func_78326_a() || this.cachedHeight != size.func_78328_b()) {
                    ((IBookWrapper)this.mainhand.getRight()).setSize(size.func_78326_a(), size.func_78328_b(), player.func_184591_cq());
                }
                ((IBookWrapper)this.mainhand.getRight()).draw(player.func_184591_cq(), event.getPartialTicks());
                GlStateManager.func_179121_F();
            }
            if (this.offhand != null) {
                GlStateManager.func_179094_E();
                if (this.cachedWidth != size.func_78326_a() || this.cachedHeight != size.func_78328_b()) {
                    ((IBookWrapper)this.offhand.getRight()).setSize(size.func_78326_a(), size.func_78328_b(), player.func_184591_cq().func_188468_a());
                }
                ((IBookWrapper)this.offhand.getRight()).draw(player.func_184591_cq().func_188468_a(), event.getPartialTicks());
                GlStateManager.func_179121_F();
            }
            this.cachedWidth = size.func_78326_a();
            this.cachedHeight = size.func_78328_b();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onUseItem(PlayerInteractEvent.RightClickItem event) {
        if (this.shouldDisplay() && BookDisplay.has(event.getItemStack())) {
            this.disable();
        }
    }

    @SubscribeEvent
    public void onOpenGui(GuiOpenEvent event) {
        if (event.getGui() != null && this.shouldDisplay()) {
            this.disable();
        }
        if (event.getGui() != null && Loader.isModLoaded((String)"mantle")) {
            MantleWrapper.register(event.getGui());
        }
    }
}

