/*
 * Decompiled with CFR 0.152.
 */
package astavie.bookdisplay.wrapper;

import astavie.bookdisplay.wrapper.IBookWrapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.EnumHandSide;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class BookWrapper<T extends GuiScreen>
implements IBookWrapper {
    private static final Method keyTyped = ReflectionHelper.findMethod(GuiScreen.class, (String)"keyTyped", (String)"func_73869_a", (Class[])new Class[]{Character.TYPE, Integer.TYPE});
    private static BookWrapper drawing = null;
    protected final T book;
    protected final boolean drawsBackground;
    protected int width;
    protected int height;

    public BookWrapper(T book, boolean drawsBackground) {
        this.book = book;
        this.drawsBackground = drawsBackground;
    }

    public BookWrapper(T book) {
        this(book, false);
    }

    public static void onDrawBackground() {
        if (drawing != null) {
            GlStateManager.func_179109_b((float)0.0f, (float)(-BookWrapper.drawing.height), (float)0.0f);
        }
    }

    @Override
    public void draw(EnumHandSide side, float partialTicks) {
        GlStateManager.func_179109_b((float)(this.width / (side == EnumHandSide.RIGHT ? 4 : -4)), (float)0.0f, (float)0.0f);
        if (this.drawsBackground) {
            drawing = this;
            GlStateManager.func_179109_b((float)0.0f, (float)this.height, (float)0.0f);
            this.book.func_73863_a(0, 0, partialTicks);
            drawing = null;
        } else {
            this.book.func_73863_a(0, 0, partialTicks);
        }
    }

    @Override
    public void left() {
    }

    @Override
    public void right() {
    }

    @Override
    public void onOpen() {
    }

    @Override
    public void onTick() {
        this.book.func_73876_c();
    }

    @Override
    public void onClose() {
        try {
            keyTyped.invoke(this.book, Character.valueOf('\u001b'), 1);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        this.book.func_146281_b();
    }

    @Override
    public void setSize(int width, int height, EnumHandSide side) {
        this.width = width;
        this.height = height;
        this.book.func_146280_a(Minecraft.func_71410_x(), width, height);
        for (GuiButton button : ((GuiScreen)this.book).field_146292_n) {
            if (!this.makeButtonInvisible(button)) continue;
            button.field_146125_m = false;
        }
    }

    protected boolean makeButtonInvisible(GuiButton button) {
        return false;
    }
}

