/*
 * Decompiled with CFR 0.152.
 */
package astavie.bookdisplay.wrapper.mantle;

import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.client.book.BookHelper;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.gui.book.GuiBook;
import slimeknights.mantle.client.gui.book.element.BookElement;

public class GuiMantleBook
extends GuiScreen {
    private static final ResourceLocation TEX_BOOK = new ResourceLocation("bookdisplay", "textures/gui/book.png");
    private static final int PAGE_WIDTH_UNSCALED = 214;
    private static final int PAGE_HEIGHT_UNSCALED = 200;
    private static final int PAGE_PADDING_TOP = 4;
    private static final int PAGE_PADDING_LEFT = 8;
    private static final int PAGE_MARGIN = 8;
    private static final int PAGE_WIDTH = 190;
    private static final int PAGE_HEIGHT = 176;
    private final BookData book;
    private final ArrayList<BookElement> elements = new ArrayList();
    private final GuiBook gui;
    private final ItemStack item;
    private int page;

    public GuiMantleBook(BookData book, ItemStack item) {
        this.book = book;
        this.gui = new GuiBook(book, item);
        this.item = item;
        this.page = book.findPageNumber(BookHelper.getSavedPage((ItemStack)item), this.gui.advancementCache);
        if (this.page < 0) {
            this.page = 0;
        }
        this.reload();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        BookElement element;
        int i;
        FontRenderer fontRenderer = this.book.fontRenderer;
        if (fontRenderer == null) {
            fontRenderer = this.field_146297_k.field_71466_p;
        }
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179094_E();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        float coverR = (float)(this.book.appearance.coverColor >> 16 & 0xFF) / 255.0f;
        float coverG = (float)(this.book.appearance.coverColor >> 8 & 0xFF) / 255.0f;
        float coverB = (float)(this.book.appearance.coverColor & 0xFF) / 255.0f;
        TextureManager render = this.field_146297_k.field_71446_o;
        render.func_110577_a(TEX_BOOK);
        RenderHelper.func_74518_a();
        GlStateManager.func_179124_c((float)coverR, (float)coverG, (float)coverB);
        GuiMantleBook.func_146110_a((int)(this.field_146294_l / 2 - 107), (int)(this.field_146295_m / 2 - 100), (float)0.0f, (float)0.0f, (int)214, (int)200, (float)512.0f, (float)512.0f);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GuiMantleBook.func_146110_a((int)(this.field_146294_l / 2 - 107), (int)(this.field_146295_m / 2 - 100), (float)0.0f, (float)200.0f, (int)214, (int)200, (float)512.0f, (float)512.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(this.field_146294_l / 2 - 107 + 16), (float)(this.field_146295_m / 2 - 100 + 4 + 8), (float)0.0f);
        if (this.book.appearance.drawPageNumbers) {
            fontRenderer.func_175065_a(this.page + 1 + "", (float)(95 - fontRenderer.func_78256_a(this.page + 1 + "") / 2), 166.0f, -5592406, false);
        }
        for (i = 0; i < this.elements.size(); ++i) {
            element = this.elements.get(i);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            element.draw(0, 0, partialTicks, fontRenderer);
        }
        for (i = 0; i < this.elements.size(); ++i) {
            element = this.elements.get(i);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            element.drawOverlay(0, 0, partialTicks, fontRenderer);
        }
        GlStateManager.func_179121_F();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179121_F();
    }

    public void left() {
        if (this.page > 0) {
            --this.page;
            this.reload();
        }
    }

    public void right() {
        if (this.page < this.book.getPageCount(this.gui.advancementCache) - 1) {
            ++this.page;
            this.reload();
        }
    }

    private void reload() {
        this.elements.clear();
        this.book.findPage((int)this.page, (GuiBook.AdvancementCache)this.gui.advancementCache).content.build(this.book, this.elements, true);
        for (BookElement element : this.elements) {
            element.parent = this.gui;
        }
    }

    public void func_146281_b() {
        PageData page = this.book.findPage(this.page - 1, this.gui.advancementCache);
        if (page != null && page.parent != null) {
            BookLoader.updateSavedPage((EntityPlayer)this.field_146297_k.field_71439_g, (ItemStack)this.item, (String)(page.parent.name + "." + page.name));
        }
    }
}

