/*
 * Decompiled with CFR 0.152.
 */
package astavie.bookdisplay.wrapper;

import astavie.bookdisplay.wrapper.IBookWrapper;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.HandSide;

public class BookWrapper<T extends Screen>
implements IBookWrapper {
    private static BookWrapper drawing = null;
    protected final T book;
    private final boolean drawsBackground;
    protected int width;
    protected int height;

    public BookWrapper(T book, boolean drawsBackground) {
        this.book = book;
        this.drawsBackground = drawsBackground;
    }

    public BookWrapper(T book) {
        this(book, false);
    }

    public static void onDrawBackground() {
        if (drawing != null) {
            GlStateManager.translatef((float)0.0f, (float)(-BookWrapper.drawing.height), (float)0.0f);
        }
    }

    @Override
    public void draw(HandSide side, float partialTicks) {
        GlStateManager.translatef((float)(this.width / (side == HandSide.RIGHT ? 4 : -4)), (float)0.0f, (float)0.0f);
        if (this.drawsBackground) {
            drawing = this;
            GlStateManager.translatef((float)0.0f, (float)this.height, (float)0.0f);
            this.book.render(0, 0, partialTicks);
            drawing = null;
        } else {
            this.book.render(0, 0, partialTicks);
        }
    }

    @Override
    public void left() {
    }

    @Override
    public void right() {
    }

    @Override
    public void onOpen() {
    }

    @Override
    public void onTick() {
        this.book.tick();
    }

    @Override
    public void onClose() {
        this.book.charTyped('\u001b', 1);
        this.book.onClose();
    }

    @Override
    public void setSize(int width, int height, HandSide side) {
        this.width = width;
        this.height = height;
        this.book.init(Minecraft.func_71410_x(), width, height);
        for (Widget button : ((Screen)this.book).buttons) {
            if (!this.makeButtonInvisible(button)) continue;
            button.visible = false;
        }
    }

    protected boolean makeButtonInvisible(Widget button) {
        return false;
    }
}

