/*
 * Decompiled with CFR 0.152.
 */
package astavie.bookdisplay.wrapper.mantle;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.client.book.BookHelper;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.screen.book.BookScreen;
import slimeknights.mantle.client.screen.book.element.BookElement;

public class GuiMantleBook
extends Screen {
    private static final ResourceLocation TEX_BOOK = new ResourceLocation("bookdisplay", "textures/gui/book.png");
    private static final int PAGE_WIDTH_UNSCALED = 214;
    private static final int PAGE_HEIGHT_UNSCALED = 200;
    private static final int PAGE_PADDING_TOP = 4;
    private static final int PAGE_PADDING_LEFT = 8;
    private static final int PAGE_MARGIN = 8;
    private static final int PAGE_WIDTH = 190;
    private static final int PAGE_HEIGHT = 176;
    private final BookData book;
    private final ArrayList<BookElement> elements = new ArrayList();
    private final BookScreen gui;
    private final ItemStack item;
    private int page;

    public GuiMantleBook(BookData book, ItemStack item) {
        super(NarratorChatListener.field_216868_a);
        this.book = book;
        this.gui = new BookScreen(NarratorChatListener.field_216868_a, book, item);
        this.item = item;
        this.page = book.findPageNumber(BookHelper.getSavedPage((ItemStack)item), this.gui.advancementCache);
        if (this.page < 0) {
            this.page = 0;
        }
        this.reload();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        BookElement element;
        int i;
        FontRenderer fontRenderer = this.book.fontRenderer;
        if (fontRenderer == null) {
            fontRenderer = this.minecraft.field_71466_p;
        }
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.pushMatrix();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        float coverR = (float)(this.book.appearance.coverColor >> 16 & 0xFF) / 255.0f;
        float coverG = (float)(this.book.appearance.coverColor >> 8 & 0xFF) / 255.0f;
        float coverB = (float)(this.book.appearance.coverColor & 0xFF) / 255.0f;
        TextureManager render = this.minecraft.field_71446_o;
        render.func_110577_a(TEX_BOOK);
        RenderHelper.func_74518_a();
        RenderSystem.color3f((float)coverR, (float)coverG, (float)coverB);
        GuiMantleBook.blit((int)(this.width / 2 - 107), (int)(this.height / 2 - 100), (float)0.0f, (float)0.0f, (int)214, (int)200, (int)512, (int)512);
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        GuiMantleBook.blit((int)(this.width / 2 - 107), (int)(this.height / 2 - 100), (float)0.0f, (float)200.0f, (int)214, (int)200, (int)512, (int)512);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)(this.width / 2 - 107 + 16), (float)(this.height / 2 - 100 + 4 + 8), (float)0.0f);
        if (this.book.appearance.drawPageNumbers) {
            fontRenderer.func_211126_b(this.page + 1 + "", (float)(95 - fontRenderer.func_78256_a(this.page + 1 + "") / 2), 166.0f, -5592406);
        }
        for (i = 0; i < this.elements.size(); ++i) {
            element = this.elements.get(i);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            element.draw(0, 0, partialTicks, fontRenderer);
        }
        for (i = 0; i < this.elements.size(); ++i) {
            element = this.elements.get(i);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            element.drawOverlay(0, 0, partialTicks, fontRenderer);
        }
        RenderSystem.popMatrix();
        super.render(mouseX, mouseY, partialTicks);
        RenderSystem.popMatrix();
    }

    public void left() {
        if (this.page > 0) {
            --this.page;
            this.reload();
        }
    }

    public void right() {
        if (this.page < this.book.getPageCount(this.gui.advancementCache) - 1) {
            ++this.page;
            this.reload();
        }
    }

    private void reload() {
        this.elements.clear();
        this.book.findPage((int)this.page, (BookScreen.AdvancementCache)this.gui.advancementCache).content.build(this.book, this.elements, true);
        for (BookElement element : this.elements) {
            element.parent = this.gui;
        }
    }

    public void onClose() {
        PageData page = this.book.findPage(this.page - 1, this.gui.advancementCache);
        if (page != null && page.parent != null) {
            BookLoader.updateSavedPage((PlayerEntity)this.minecraft.field_71439_g, (ItemStack)this.item, (String)(page.parent.name + "." + page.name));
        }
    }
}

