/*
 * Decompiled with CFR 0.152.
 */
package astavie.bookdisplay;

import astavie.bookdisplay.BookDisplay;
import astavie.bookdisplay.wrapper.BookWrapper;
import astavie.bookdisplay.wrapper.IBookWrapper;
import astavie.bookdisplay.wrapper.mantle.MantleWrapper;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.tuple.Pair;

public class EventHandler {
    private boolean enabled = false;
    private Pair<ItemStack, IBookWrapper> mainhand;
    private Pair<ItemStack, IBookWrapper> offhand;
    private int cachedWidth;
    private int cachedHeight;

    private void mainhand() {
        ClientPlayerEntity player;
        ItemStack stack;
        IBookWrapper wrapper;
        if (this.mainhand != null) {
            ((IBookWrapper)this.mainhand.getRight()).onClose();
        }
        if ((wrapper = BookDisplay.find(stack = (player = Minecraft.func_71410_x().field_71439_g).func_184614_ca().func_77946_l())) != null) {
            MainWindow size = Minecraft.func_71410_x().func_228018_at_();
            wrapper.setSize(size.func_198107_o(), size.func_198087_p(), player.func_184591_cq());
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
            wrapper.onOpen();
            this.mainhand = Pair.of((Object)stack, (Object)wrapper);
        } else {
            this.mainhand = null;
        }
    }

    private void offhand() {
        ClientPlayerEntity player;
        ItemStack stack;
        IBookWrapper wrapper;
        if (this.offhand != null) {
            ((IBookWrapper)this.offhand.getRight()).onClose();
        }
        if ((wrapper = BookDisplay.find(stack = (player = Minecraft.func_71410_x().field_71439_g).func_184592_cb().func_77946_l())) != null) {
            MainWindow size = Minecraft.func_71410_x().func_228018_at_();
            wrapper.setSize(size.func_198107_o(), size.func_198087_p(), player.func_184591_cq().func_188468_a());
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
            wrapper.onOpen();
            this.offhand = Pair.of((Object)stack, (Object)wrapper);
        } else {
            this.offhand = null;
        }
    }

    @SubscribeEvent
    public void onKey(InputEvent.KeyInputEvent event) {
        if (BookDisplay.key.func_151468_f()) {
            if (this.shouldDisplay()) {
                this.disable();
            } else {
                this.enable();
            }
        }
        if (this.shouldDisplay()) {
            if (BookDisplay.left.func_151468_f()) {
                if (this.mainhand != null) {
                    ((IBookWrapper)this.mainhand.getRight()).left();
                }
                if (this.offhand != null) {
                    ((IBookWrapper)this.offhand.getRight()).left();
                }
            }
            if (BookDisplay.right.func_151468_f()) {
                if (this.mainhand != null) {
                    ((IBookWrapper)this.mainhand.getRight()).right();
                }
                if (this.offhand != null) {
                    ((IBookWrapper)this.offhand.getRight()).right();
                }
            }
        }
    }

    private void disable() {
        if (this.mainhand != null) {
            ((IBookWrapper)this.mainhand.getRight()).onClose();
        }
        if (this.offhand != null) {
            ((IBookWrapper)this.offhand.getRight()).onClose();
        }
        this.mainhand = null;
        this.offhand = null;
        this.enabled = false;
    }

    private void enable() {
        this.mainhand();
        this.offhand();
        this.enabled = true;
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (this.shouldDisplay()) {
            if (this.mainhand == null && !event.player.func_184614_ca().func_190926_b() || this.mainhand != null && !ItemStack.func_77989_b((ItemStack)((ItemStack)this.mainhand.getLeft()), (ItemStack)event.player.func_184614_ca())) {
                Minecraft.func_71410_x().func_212871_a_(this::mainhand);
            }
            if (this.offhand == null && !event.player.func_184592_cb().func_190926_b() || this.offhand != null && !ItemStack.func_77989_b((ItemStack)((ItemStack)this.offhand.getLeft()), (ItemStack)event.player.func_184592_cb())) {
                Minecraft.func_71410_x().func_212871_a_(this::offhand);
            }
            if (this.mainhand != null) {
                ((IBookWrapper)this.mainhand.getRight()).onTick();
            }
            if (this.offhand != null) {
                ((IBookWrapper)this.offhand.getRight()).onTick();
            }
        }
    }

    @SubscribeEvent
    public void onOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && this.shouldDisplay()) {
            MainWindow size = Minecraft.func_71410_x().func_228018_at_();
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (this.mainhand != null) {
                event.getMatrixStack().func_227860_a_();
                if (this.cachedWidth != size.func_198107_o() || this.cachedHeight != size.func_198087_p()) {
                    ((IBookWrapper)this.mainhand.getRight()).setSize(size.func_198107_o(), size.func_198087_p(), player.func_184591_cq());
                }
                ((IBookWrapper)this.mainhand.getRight()).draw(event.getMatrixStack(), player.func_184591_cq(), event.getPartialTicks());
                event.getMatrixStack().func_227865_b_();
            }
            if (this.offhand != null) {
                event.getMatrixStack().func_227860_a_();
                if (this.cachedWidth != size.func_198107_o() || this.cachedHeight != size.func_198087_p()) {
                    ((IBookWrapper)this.offhand.getRight()).setSize(size.func_198107_o(), size.func_198087_p(), player.func_184591_cq().func_188468_a());
                }
                ((IBookWrapper)this.offhand.getRight()).draw(event.getMatrixStack(), player.func_184591_cq().func_188468_a(), event.getPartialTicks());
                event.getMatrixStack().func_227865_b_();
            }
            this.cachedWidth = size.func_198107_o();
            this.cachedHeight = size.func_198087_p();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDrawBackground(GuiScreenEvent.BackgroundDrawnEvent event) {
        BookWrapper.onDrawBackground(event.getMatrixStack());
    }

    private boolean shouldDisplay() {
        return this.enabled;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onUseItem(PlayerInteractEvent.RightClickItem event) {
        if (this.shouldDisplay() && BookDisplay.has(event.getItemStack())) {
            this.disable();
        }
    }

    @SubscribeEvent
    public void onGui(GuiOpenEvent event) {
        if (event.getGui() != null && this.shouldDisplay()) {
            this.disable();
        }
        if (event.getGui() != null && ModList.get().isLoaded("mantle")) {
            MantleWrapper.register(event.getGui());
        }
    }
}

