/*
 * Decompiled with CFR 0.152.
 */
package com.github.phylogeny.boundtotems;

import com.github.phylogeny.boundtotems.BoundTotems;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class Config {
    private static final String LANG_KEY = "config.boundtotems";
    public static final Server SERVER = new Server();

    private static String format(String comment) {
        return String.format(comment, "upon being saved from death by a non-held bound totem of undying");
    }

    @SubscribeEvent
    public void onLoad(ModConfig.Loading configEvent) {
        BoundTotems.LOGGER.debug("Loaded forge config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public void onFileChange(ModConfig.Reloading configEvent) {
        BoundTotems.LOGGER.fatal("Forge config just got changed on the file system!");
    }

    public static void register() {
        SERVER.register();
        FMLJavaModLoadingContext.get().getModEventBus().register(Config.class);
    }

    private static class ConfigBase {
        protected final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        private final ModConfig.Type type;
        private ForgeConfigSpec spec;

        public ConfigBase(String category, String description, ModConfig.Type type) {
            this.builder.comment(description).push(category);
            this.type = type;
        }

        protected void build() {
            this.builder.pop();
            this.spec = this.builder.build();
        }

        public void register() {
            ModLoadingContext.get().registerConfig(this.type, this.spec);
        }
    }

    public static class Server
    extends ConfigBase {
        private static final String LANG_KEY = "config.boundtotems.server.";
        public final ForgeConfigSpec.ConfigValue<InventorySearch> inventorySearch;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> potionEffects;
        public final ForgeConfigSpec.DoubleValue health;
        public final ForgeConfigSpec.DoubleValue maxDistanceToShelf;
        public final ForgeConfigSpec.BooleanValue preventCreativeModeDeath;
        public final ForgeConfigSpec.BooleanValue clearPotionEffects;
        public final ForgeConfigSpec.BooleanValue spawnParticles;
        public final ForgeConfigSpec.BooleanValue playSound;
        public final ForgeConfigSpec.BooleanValue playAnimation;
        public final ForgeConfigSpec.BooleanValue setHealthToPercentageOfMax;
        public final ForgeConfigSpec.IntValue maxBoundShelves;

        Server() {
            super("Server", "Contains configs only accessed by the server", ModConfig.Type.SERVER);
            this.inventorySearch = this.builder.comment("1) If set to WHOLE_INVENTORY, the entire inventory will be searched for totems; 2) If set to HOTBAR_ONLY, only the hotbar of the inventory will be searched for totems; 3) If set to HELD_ONLY, only totems that the player is holding will save them from death.").translation("config.boundtotems.server.search").defineEnum("Inventory Search Location", (Enum)InventorySearch.WHOLE_INVENTORY);
            this.preventCreativeModeDeath = this.builder.comment("If set to true, non-held bound totems of undying can save the player from death even from damage sources that harm players in creative mode (such as void damage and /kill command damage).").translation("config.boundtotems.server.prevent.death.all").define("Prevent All Death", true);
            this.clearPotionEffects = this.builder.comment(Config.format("If set to true, all pre-existing potion effects will be cleared from the player %s.")).translation("config.boundtotems.server.effects.clear").define("Clear Potion Effects", true);
            this.potionEffects = this.builder.comment(Config.format("These potion effects will be applied to the player %s. Each string specifies a potion effect in exactly the same way the /effect command does (e.i. the required first argument specifies a potion by id or by modId:name, and the second/third optional arguments are duration in seconds and amplification). These effects will be applied whether or not pre-existing effects were previously cleared.")).translation("config.boundtotems.server.effects.apply").defineList("Apply Potion Effects", (List)ImmutableList.of((Object)"minecraft:regeneration 45 1", (Object)"minecraft:absorption 5 1"), obj -> obj instanceof String);
            this.spawnParticles = this.builder.comment(Config.format("If set to true, totem particles will spawn for all nearby players %s.")).translation("config.boundtotems.server.result.particles").define("Spawn Particles", true);
            this.playSound = this.builder.comment(Config.format("If set to true, totem sound will play for all nearby players %s.")).translation("config.boundtotems.server.result.sound").define("Play Sound", true);
            this.playAnimation = this.builder.comment(Config.format("If set to true, the large floating totem animation will that takes up the screen will play upon %s.")).translation("config.boundtotems.server.result.animation").define("Play Animation", false);
            this.setHealthToPercentageOfMax = this.builder.comment(Config.format("If set to true, 'New Health Value' will specify the percent of the player's max heath to set the new health value to %s. If set to false, it will specify the number of hearts (1 = 1/2 heart) to set the new health value to.")).translation("config.boundtotems.server.health.percentage").define("Set Health To Percentage Of Max", false);
            this.health = this.builder.comment(Config.format("Specifies the value (either percentage of max health, or absolute value (1 = 1/2 heart), depending on what 'Set Health To Percentage Of Max' is set to) that the players heath will be set to %s.")).translation("config.boundtotems.server.health.value").defineInRange("New Health Value", 1.0, 0.0, Double.MAX_VALUE);
            this.maxDistanceToShelf = this.builder.comment(Config.format("Specifies the maximum distance in meters from a totem shelf an entity must be when binding that shelf to that entity for the binding to be successful.")).translation("config.boundtotems.server.shelf.distance").defineInRange("Max Distance To Shelf", 10.0, 0.0, Double.MAX_VALUE);
            this.maxBoundShelves = this.builder.comment(Config.format("Specifies the maximum number of shelves that can be bound to an entity at a time. If an additional shelf is bound once the max has been reached, a randomly selected currently bound shelf will be struck with lightning and converted into a useless charred shelf. Items can be taken from a charred shelf but cannot be placed in it, and any totems it will have no effect as long as they remain in it.")).translation("config.boundtotems.server.shelf.max").defineInRange("Max Bound Shelves", 10, 1, Integer.MAX_VALUE);
            this.build();
        }

        public static enum InventorySearch {
            WHOLE_INVENTORY,
            HOTBAR_ONLY,
            HELD_ONLY;

        }
    }

    public static class Client
    extends ConfigBase {
        private static final String LANG_KEY = "config.boundtotems.client.";

        Client() {
            super("Client", "Contains configs only accessed by the client", ModConfig.Type.CLIENT);
            this.build();
        }
    }
}

