/*
 * Decompiled with CFR 0.152.
 */
package com.github.phylogeny.boundtotems;

import com.github.phylogeny.boundtotems.Config;
import com.github.phylogeny.boundtotems.block.BlockStrippedOakLog;
import com.github.phylogeny.boundtotems.block.BlockTotemShelf;
import com.github.phylogeny.boundtotems.block.PositionsTotemShelf;
import com.github.phylogeny.boundtotems.item.ItemBoundTotem;
import com.github.phylogeny.boundtotems.item.ItemBoundTotemTeleporting;
import com.github.phylogeny.boundtotems.item.ItemCarvingKnife;
import com.github.phylogeny.boundtotems.network.PacketNetwork;
import com.github.phylogeny.boundtotems.network.packet.PacketTotemAnimation;
import com.github.phylogeny.boundtotems.network.packet.PacketTotemParticlesAndSound;
import com.github.phylogeny.boundtotems.tileentity.TileEntityTotemShelf;
import com.github.phylogeny.boundtotems.util.EntityUtil;
import com.github.phylogeny.boundtotems.util.NBTUtil;
import com.github.phylogeny.boundtotems.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class ServerEvents {
    private static final Field DURABILITY_REMAINING_ON_BLOCK = ObfuscationReflectionHelper.findField(PlayerInteractionManager.class, (String)"field_73094_o");
    private static final Hashtable<BlockPos, Boolean> BREAKING_SHELVES = new Hashtable();
    private static final Set<Runnable> END_OF_TICK_TASKS = ConcurrentHashMap.newKeySet();

    @SubscribeEvent
    public static void addTotemShelfBreakingOverlay(PlayerInteractEvent.LeftClickBlock event) {
        PositionsTotemShelf positions = ServerEvents.getPositionsTotemShelf(event.getPlayer(), event.getWorld().func_180495_p(event.getPos()), event.getPos());
        if (positions == null) {
            return;
        }
        BlockPos pos = positions.getPosOffset();
        Boolean initialized = BREAKING_SHELVES.get(pos);
        if (initialized == null) {
            BREAKING_SHELVES.put(pos, false);
        } else {
            BREAKING_SHELVES.remove(pos);
        }
        event.getPlayer().field_70170_p.func_175715_c(-1, pos, -1);
    }

    @SubscribeEvent
    public static void addTotemShelfBreakingOverlay(PlayerEvent.BreakSpeed event) {
        PositionsTotemShelf positions = ServerEvents.getPositionsTotemShelf(event.getPlayer(), event.getState(), event.getPos());
        if (positions == null) {
            return;
        }
        BlockPos pos = positions.getPosOffset();
        Boolean initialized = BREAKING_SHELVES.get(pos);
        if (initialized == null) {
            return;
        }
        if (!initialized.booleanValue()) {
            BREAKING_SHELVES.put(pos, true);
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        int progress = (Integer)ReflectionUtil.getValue(DURABILITY_REMAINING_ON_BLOCK, player.field_71134_c);
        player.field_70170_p.func_175715_c(-1, pos, progress - 1);
    }

    @Nullable
    public static PositionsTotemShelf getPositionsTotemShelf(PlayerEntity player, BlockState state, BlockPos pos2) {
        if (!(player instanceof ServerPlayerEntity) || !(state.func_177230_c() instanceof BlockTotemShelf) && !(state.func_177230_c() instanceof BlockStrippedOakLog)) {
            return null;
        }
        return BlockTotemShelf.getTotemShelfPositions(state, (IWorld)player.field_70170_p, pos2);
    }

    @SubscribeEvent(receiveCanceled=true)
    public static void sculptTotemShelf(BlockEvent.BreakEvent event) {
        ItemStack knife = event.getPlayer().func_184614_ca();
        if (!(knife.func_77973_b() instanceof ItemCarvingKnife) || !(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        PositionsTotemShelf positions = BlockTotemShelf.getTotemShelfPositions(event.getState(), event.getWorld(), event.getPos(), event.getPlayer());
        if (positions == null) {
            return;
        }
        Integer stage = positions.getNextStage();
        if (stage == null || stage > 6) {
            return;
        }
        event.setCanceled(true);
        positions.advanceStage((ServerWorld)event.getWorld());
        knife.func_222118_a(1, (LivingEntity)event.getPlayer(), p -> p.func_213334_d(Hand.MAIN_HAND));
    }

    @SubscribeEvent
    public static void performEndOfTickTasks(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !END_OF_TICK_TASKS.isEmpty()) {
            END_OF_TICK_TASKS.forEach(Runnable::run);
            END_OF_TICK_TASKS.clear();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void preventDeath(LivingDeathEvent event) {
        ServerPlayerEntity player;
        LivingEntity entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        if (!((Boolean)Config.SERVER.preventCreativeModeDeath.get()).booleanValue() && source.func_76357_e()) {
            return;
        }
        ItemStack totem = ServerEvents.findBoundTotem(entity);
        if (totem.func_190926_b()) {
            return;
        }
        ServerPlayerEntity serverPlayerEntity = player = entity instanceof ServerPlayerEntity ? (ServerPlayerEntity)entity : null;
        if (player != null) {
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)totem.func_77973_b()));
            CriteriaTriggers.field_193130_A.func_193187_a(player, totem);
        }
        float heath = ((Double)Config.SERVER.health.get()).floatValue();
        entity.func_70606_j((Boolean)Config.SERVER.setHealthToPercentageOfMax.get() != false ? heath * entity.func_110138_aP() : heath);
        if (((Boolean)Config.SERVER.clearPotionEffects.get()).booleanValue()) {
            entity.func_195061_cb();
        }
        for (String potionEffect : (List)Config.SERVER.potionEffects.get()) {
            try {
                ServerEvents.addPotionEffect(entity, potionEffect);
            }
            catch (IllegalPotionEffectArgumentException e) {
                entity.func_145747_a((ITextComponent)new TranslationTextComponent(String.format("potion_effect.%s.error", "boundtotems"), new Object[]{potionEffect, e.getMessage()}));
            }
        }
        boolean teleporting = totem.func_77973_b() instanceof ItemBoundTotemTeleporting;
        if (teleporting) {
            END_OF_TICK_TASKS.add(() -> {
                EntityUtil.LocationTeleport location = NBTUtil.getBoundLocation(totem);
                if (location != null) {
                    location.teleportEntity((Entity)entity);
                }
            });
        }
        if (((Boolean)Config.SERVER.spawnParticles.get()).booleanValue() || ((Boolean)Config.SERVER.playSound.get()).booleanValue()) {
            PacketNetwork.sendToAllTrackingAndSelf(new PacketTotemParticlesAndSound((Entity)entity), (Entity)entity);
        }
        if (player != null && ((Boolean)Config.SERVER.playAnimation.get()).booleanValue()) {
            PacketNetwork.sendTo(new PacketTotemAnimation(teleporting), player);
        }
        event.setCanceled(true);
    }

    private static void addPotionEffect(LivingEntity entity, String potionEffect) throws IllegalPotionEffectArgumentException {
        int amplifier;
        int duration;
        String[] args = potionEffect.split(" ");
        Effect potion = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(args[0]));
        if (potion == null) {
            throw new IllegalPotionEffectArgumentException("not_found", args[0]);
        }
        int n = duration = potion.func_76403_b() ? 1 : 600;
        if (args.length >= 2) {
            duration = ServerEvents.parseInt(args[1], 0, 1000000);
            if (!potion.func_76403_b()) {
                duration *= 20;
            }
        }
        int n2 = amplifier = args.length >= 3 ? ServerEvents.parseInt(args[2], 0, 255) : 0;
        if (duration > 0) {
            entity.func_195064_c(new EffectInstance(potion, duration, amplifier, false, args.length < 4 || !"true".equalsIgnoreCase(args[3])));
        }
    }

    public static int parseInt(String input, int min, int max) throws IllegalPotionEffectArgumentException {
        int i;
        try {
            i = Integer.parseInt(input);
        }
        catch (NumberFormatException e) {
            throw new IllegalPotionEffectArgumentException("num.invalid", input);
        }
        if (i < min) {
            throw new IllegalPotionEffectArgumentException("num.too_small", i, min);
        }
        if (i > max) {
            throw new IllegalPotionEffectArgumentException("num.too_big", i, max);
        }
        return i;
    }

    private static boolean isValidTotem(ItemStack stack, LivingEntity entity) {
        return stack.func_77973_b() instanceof ItemBoundTotem && NBTUtil.matchesBoundEntity(stack, entity);
    }

    private static ItemStack findBoundTotem(LivingEntity entity) {
        ItemStack totem = !(entity instanceof ServerPlayerEntity) || Config.SERVER.inventorySearch.get() == Config.Server.InventorySearch.HELD_ONLY ? ServerEvents.getHeldTotem(entity) : ServerEvents.getTotemFromInventory((ServerPlayerEntity)entity);
        if (totem.func_190926_b()) {
            totem = ServerEvents.getTotemFromShelf(entity);
        }
        return totem;
    }

    private static ItemStack getTotemFromInventory(ServerPlayerEntity player) {
        int i;
        boolean hotbarOnly = Config.SERVER.inventorySearch.get() == Config.Server.InventorySearch.HOTBAR_ONLY;
        ItemStack totem = ItemStack.field_190927_a;
        for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack;
            if (hotbarOnly && !PlayerInventory.func_184435_e((int)i) || !ServerEvents.isValidTotem(stack = player.field_71071_by.func_70301_a(i), (LivingEntity)player)) continue;
            totem = stack.func_77946_l();
            player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
            return totem;
        }
        for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            if (hotbarOnly && !PlayerInventory.func_184435_e((int)i) || (totem = ServerEvents.getTotemFromStack((LivingEntity)player, player.field_71071_by.func_70301_a(i))).func_190926_b()) continue;
            return totem;
        }
        return totem;
    }

    private static ItemStack getHeldTotem(LivingEntity entity) {
        for (Hand hand : Hand.values()) {
            ItemStack stack = entity.func_184586_b(hand);
            if (!ServerEvents.isValidTotem(stack, entity)) continue;
            ItemStack totem = stack.func_77946_l();
            stack.func_190918_g(1);
            return totem;
        }
        for (Hand hand : Hand.values()) {
            ItemStack totem = ServerEvents.getTotemFromStack(entity, entity.func_184586_b(hand));
            if (totem.func_190926_b()) continue;
            return totem;
        }
        return ItemStack.field_190927_a;
    }

    private static ItemStack getTotemFromStack(LivingEntity entity, ItemStack stack) {
        IItemHandler itemInventory;
        ItemStack stack2;
        CompoundNBT nbt;
        if (stack.func_77973_b() instanceof BlockItem && ((BlockItem)stack.func_77973_b()).func_179223_d() instanceof ShulkerBoxBlock && (nbt = stack.func_179543_a("BlockEntityTag")) != null && nbt.func_150297_b("Items", 9)) {
            NonNullList stacks = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)nbt, (NonNullList)stacks);
            for (int j = 0; j < stacks.size(); ++j) {
                stack2 = (ItemStack)stacks.get(j);
                if (!ServerEvents.isValidTotem(stack2, entity)) continue;
                ItemStack totem = stack2.func_77946_l();
                stacks.set(j, (Object)ItemStack.field_190927_a);
                boolean isEmpty = true;
                for (int k = 0; k < stacks.size(); ++k) {
                    if (((ItemStack)stacks.get(k)).func_190926_b()) continue;
                    ItemStackHelper.func_191281_a((CompoundNBT)nbt, (NonNullList)stacks, (boolean)false);
                    isEmpty = false;
                    break;
                }
                if (isEmpty) {
                    nbt.func_82580_o("Items");
                }
                return totem;
            }
        }
        if ((itemInventory = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null)) != null) {
            for (int j = 0; j < itemInventory.getSlots(); ++j) {
                stack2 = itemInventory.getStackInSlot(j);
                if (!ServerEvents.isValidTotem(stack2, entity)) continue;
                ItemStack totem = stack2.func_77946_l();
                stack2 = itemInventory.extractItem(j, 1, false);
                if (stack2.func_190926_b()) continue;
                return totem;
            }
        }
        return ItemStack.field_190927_a;
    }

    private static ItemStack getTotemFromShelf(LivingEntity entity) {
        AtomicReference<ItemStack> stackRef = new AtomicReference<ItemStack>(ItemStack.field_190927_a);
        boolean performAudit = entity.field_70170_p.field_73012_v.nextInt(20) == 0;
        TileEntityTotemShelf.visitTotemShelves(entity, (world, shelf) -> {
            if (((ItemStack)stackRef.get()).func_190926_b()) {
                ItemStackHandler inventory = shelf.getInventory();
                for (int i = 0; i < inventory.getSlots(); ++i) {
                    ItemStack stack = inventory.extractItem(i, 1, true);
                    if (!(stack.func_77973_b() instanceof ItemBoundTotem) || !entity.func_110124_au().equals(NBTUtil.getBoundEntityId(stack))) continue;
                    stackRef.set(inventory.extractItem(i, 1, false));
                    if (performAudit) continue;
                    return new TileEntityTotemShelf.ShelfVisitationResult(false, false);
                }
            }
            return new TileEntityTotemShelf.ShelfVisitationResult(false, true);
        });
        return stackRef.get();
    }

    private static class IllegalPotionEffectArgumentException
    extends IllegalArgumentException {
        private final TranslationTextComponent message;

        public IllegalPotionEffectArgumentException(String translationKeySuffix, Object ... args) {
            this.message = new TranslationTextComponent(String.join((CharSequence)".", "potion_effect", "boundtotems", translationKeySuffix), args);
        }

        @Override
        public String getMessage() {
            return this.message.func_150254_d();
        }
    }
}

