/*
 * Decompiled with CFR 0.152.
 */
package com.github.phylogeny.boundtotems.block;

import com.github.phylogeny.boundtotems.block.BlockStrippedOakLog;
import com.github.phylogeny.boundtotems.block.BlockWaterLoggable;
import com.github.phylogeny.boundtotems.block.PositionsTotemShelf;
import com.github.phylogeny.boundtotems.init.ItemsMod;
import com.github.phylogeny.boundtotems.init.SoundsMod;
import com.github.phylogeny.boundtotems.item.ItemPlank;
import com.github.phylogeny.boundtotems.network.PacketNetwork;
import com.github.phylogeny.boundtotems.network.packet.PacketShelfSmokeParticles;
import com.github.phylogeny.boundtotems.tileentity.TileEntityTotemShelf;
import com.github.phylogeny.boundtotems.tileentity.TileEntityTotemShelfBinding;
import com.github.phylogeny.boundtotems.util.CapabilityUtil;
import com.github.phylogeny.boundtotems.util.EntityUtil;
import com.github.phylogeny.boundtotems.util.VoxelShapeUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LogBlock;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;

public class BlockTotemShelf
extends BlockWaterLoggable {
    public static final String NAME = "totem_shelf";
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    public static final EnumProperty<BindingState> BINDING_STATE = EnumProperty.func_177709_a((String)"binding_state", BindingState.class);
    public static final IntegerProperty STAGE = IntegerProperty.func_177719_a((String)"stage", (int)0, (int)10);
    public static final BooleanProperty CHARRED = BooleanProperty.func_177716_a((String)"charred");
    public static final VoxelShape SHAPE_KNIFE = VoxelShapes.func_197873_a((double)-0.15, (double)-0.15, (double)-0.15, (double)0.15, (double)0.15, (double)0.15);
    public static final EnumMap<Direction, EnumMap<DoubleBlockHalf, VoxelShape[]>> SHAPES_TOTEMS;
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;
    public final ImmutableMap<BlockState, VoxelShape> SHAPES_RAYTRACE;
    private boolean preventPostPlacementCheck;

    private static <K extends Enum<K>, V> EnumMap<K, V> createEnumMap(Class<K> classEnum, Function<? super K, ? extends V> valueMapper) {
        return Arrays.stream(classEnum.getEnumConstants()).collect(Collectors.toMap(enumValue -> enumValue, valueMapper, (v1, v2) -> v2, () -> new EnumMap(classEnum)));
    }

    public BlockTotemShelf(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getBaseState().func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a(BINDING_STATE, (Comparable)((Object)BindingState.NOT_BOUND))).func_206870_a((IProperty)STAGE, (Comparable)Integer.valueOf(10))).func_206870_a((IProperty)CHARRED, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = VoxelShapeUtil.generateShapes((ImmutableList<BlockState>)this.func_176194_O().func_177619_a(), FACING, state -> {
            boolean isUpper;
            assert (state != null);
            int stage = (Integer)state.func_177229_b((IProperty)STAGE);
            boolean bl = isUpper = state.func_177229_b(HALF) == DoubleBlockHalf.UPPER;
            if (stage < 5) {
                return Collections.singletonList(Block.func_208617_a((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)16.0, (double)(14 - 2 * stage)).func_197751_a(0.0, isUpper ? 0.0 : 1.0, 0.0));
            }
            List<Object> shapes = Lists.newArrayList((Object[])new VoxelShape[]{Block.func_208617_a((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)14.0, (double)(stage == 5 ? 4.0 : 1.0)), Block.func_208617_a((double)0.0, (double)-16.0, (double)1.0, (double)2.0, (double)14.0, (double)5.0), Block.func_208617_a((double)14.0, (double)-16.0, (double)1.0, (double)16.0, (double)14.0, (double)5.0)});
            if (stage > 6) {
                shapes.add(Block.func_208617_a((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)-14.0, (double)5.0));
            }
            if (stage > 7) {
                shapes.add(Block.func_208617_a((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)5.0));
            }
            if (stage > 8) {
                shapes.add(Block.func_208617_a((double)0.0, (double)-6.0, (double)0.0, (double)16.0, (double)-4.0, (double)5.0));
            }
            if (stage == 10) {
                shapes.add(Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)6.0, (double)5.0));
            }
            if (!isUpper) {
                shapes = shapes.stream().map(shape -> shape.func_197751_a(0.0, 1.0, 0.0)).collect(Collectors.toList());
            }
            return shapes;
        });
        this.SHAPES_RAYTRACE = VoxelShapeUtil.getTransformedShapes(this.SHAPES, shape -> VoxelShapes.func_197881_a((AxisAlignedBB)shape.func_197752_a()));
    }

    @Nullable
    public static PositionsTotemShelf getTotemShelfPositions(BlockState state, IWorld world, BlockPos pos) {
        return BlockTotemShelf.getTotemShelfPositions(state, world, pos, null);
    }

    @Nullable
    public static PositionsTotemShelf getTotemShelfPositions(BlockState state, IWorld world, BlockPos pos, @Nullable PlayerEntity player) {
        boolean isTotemShelf = state.func_177230_c() instanceof BlockTotemShelf;
        if (!isTotemShelf && BlockTotemShelf.isInvalid(state)) {
            return null;
        }
        if (isTotemShelf) {
            BlockPos posLower;
            boolean isUpper = state.func_177229_b(HALF) == DoubleBlockHalf.UPPER;
            BlockPos posOffset = posLower = pos.func_177977_b();
            if (!isUpper) {
                posLower = pos;
                pos = posOffset = pos.func_177984_a();
            }
            return !(world.func_180495_p(posOffset).func_177230_c() instanceof BlockTotemShelf) ? null : new PositionsTotemShelf(state, pos, posLower, !isUpper, null);
        }
        boolean isReversed = false;
        BlockPos posLower = pos.func_177977_b();
        BlockState stateLower = world.func_180495_p(posLower);
        if (BlockTotemShelf.isInvalid(stateLower)) {
            isReversed = true;
            posLower = pos;
            state = world.func_180495_p(pos = posLower.func_177984_a());
            if (BlockTotemShelf.isInvalid(state)) {
                return null;
            }
        }
        return new PositionsTotemShelf(state, pos, posLower, isReversed, player);
    }

    private static boolean isInvalid(BlockState state) {
        return state.func_177230_c() != Blocks.field_203204_R && !(state.func_177230_c() instanceof BlockStrippedOakLog) || state.func_177229_b((IProperty)LogBlock.field_176298_M) != Direction.Axis.Y;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        int stage;
        if (!(context.getEntity() instanceof LivingEntity)) {
            return (VoxelShape)this.SHAPES.get((Object)state);
        }
        if (context.func_216375_a((Item)ItemsMod.PLANK.get()) && (stage = ((Integer)state.func_177229_b((IProperty)STAGE)).intValue()) > 5 && stage < 10) {
            return (VoxelShape)this.SHAPES.get(state.func_206870_a((IProperty)STAGE, (Comparable)Integer.valueOf(stage + 1)));
        }
        TileEntity te = reader.func_175625_s(pos);
        BlockPos posTE = pos;
        DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b(HALF);
        if (half == DoubleBlockHalf.LOWER) {
            posTE = pos.func_177984_a();
            te = reader.func_175625_s(posTE);
        }
        if (te instanceof TileEntityTotemShelf) {
            IItemHandler inventory;
            Vec3d startPos = context.getEntity().func_174824_e(1.0f);
            Vec3d endPos = startPos.func_178787_e(context.getEntity().func_70040_Z().func_186678_a(10.0));
            VoxelShape shape = (VoxelShape)this.SHAPES.get((Object)state);
            BlockRayTraceResult targetShelf = shape.func_212433_a(startPos, endPos, pos);
            VoxelShape shapeClosest = null;
            double distanceShortest = Double.MAX_VALUE;
            TileEntityTotemShelf totemShelf = (TileEntityTotemShelf)te;
            Vec3d knifePos = totemShelf.getKnifePos();
            if (knifePos != null) {
                VoxelShape shapeKnife = SHAPE_KNIFE.func_197751_a(knifePos.field_72450_a - (double)pos.func_177958_n(), knifePos.field_72448_b - (double)pos.func_177956_o(), knifePos.field_72449_c - (double)pos.func_177952_p());
                BlockRayTraceResult targetKnife = shapeKnife.func_212433_a(startPos, endPos, pos);
                if (targetKnife != null) {
                    distanceShortest = targetKnife.func_216347_e().func_72436_e(startPos);
                    shapeClosest = shapeKnife;
                }
            } else if (context.getEntity() != null && (context.func_216375_a((Item)ItemsMod.BOUND_TOTEM.get()) || context.func_216375_a((Item)ItemsMod.BOUND_TOTEM_TELEPORTING.get()) || context.func_216375_a(Items.field_190931_a)) && (inventory = CapabilityUtil.getInventory(totemShelf)).isItemValid(0, ((LivingEntity)context.getEntity()).func_184614_ca())) {
                for (int i = 0; i < inventory.getSlots(); ++i) {
                    double distance;
                    EnumMap<DoubleBlockHalf, VoxelShape[]> shapes;
                    BlockRayTraceResult targetTotem;
                    ItemStack stack = inventory.getStackInSlot(i);
                    if (context.func_216375_a(Items.field_190931_a) == stack.func_190926_b() || (targetTotem = (shapes = SHAPES_TOTEMS.get(state.func_177229_b((IProperty)FACING))).get(DoubleBlockHalf.UPPER)[i].func_212433_a(startPos, endPos, posTE)) == null || !((distance = targetTotem.func_216347_e().func_72436_e(startPos)) < distanceShortest)) continue;
                    distanceShortest = distance;
                    shapeClosest = shapes.get(half)[i];
                }
            }
            if (shapeClosest != null && (targetShelf == null || distanceShortest < targetShelf.func_216347_e().func_72436_e(startPos))) {
                return VoxelShapes.func_197882_b((VoxelShape)shape, shapeClosest, (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
        }
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader world, BlockPos pos) {
        return (VoxelShape)this.SHAPES_RAYTRACE.get((Object)state);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        return (Integer)state.func_177229_b((IProperty)STAGE) < 6 ? BlockStrippedOakLog.getSoundType(state, entity) : super.getSoundType(state, world, pos, entity);
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        boolean isUp;
        super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
        if (this.preventPostPlacementCheck) {
            return state;
        }
        DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b(HALF);
        boolean isLower = half == DoubleBlockHalf.LOWER;
        boolean bl = isUp = facing == Direction.UP;
        if (facing.func_176740_k() == Direction.Axis.Y && isLower == isUp) {
            return facingState.func_177230_c() == this && facingState.func_177229_b(HALF) != half ? (BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)FACING, facingState.func_177229_b((IProperty)FACING))).func_206870_a(BINDING_STATE, facingState.func_177229_b(BINDING_STATE))).func_206870_a((IProperty)STAGE, facingState.func_177229_b((IProperty)STAGE)) : Blocks.field_150350_a.func_176223_P();
        }
        return isLower && !isUp && !state.func_196955_c((IWorldReader)world, currentPos) ? Blocks.field_150350_a.func_176223_P() : state;
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        if (context.func_195995_a().func_177956_o() < 255 && context.func_195991_k().func_180495_p(context.func_195995_a().func_177984_a()).func_196953_a(context)) {
            return (BlockState)super.func_196258_a(context).func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d());
        }
        return null;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        world.func_175656_a(pos.func_177984_a(), (BlockState)state.func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER));
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, Blocks.field_150350_a.func_176223_P(), te, stack);
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b(HALF);
        boolean isLower = half == DoubleBlockHalf.LOWER;
        BlockPos posOffset = isLower ? pos.func_177984_a() : pos.func_177977_b();
        BlockState stateOffset = world.func_180495_p(posOffset);
        if (stateOffset.func_177230_c() == this && stateOffset.func_177229_b(HALF) != half) {
            this.preventPostPlacementCheck = true;
            world.func_180501_a(posOffset, Blocks.field_150350_a.func_176223_P(), 35);
            this.preventPostPlacementCheck = false;
            if (!world.field_72995_K && !player.func_184812_l_() && (Integer)state.func_177229_b((IProperty)STAGE) == 10 && state.func_177229_b(BINDING_STATE) != BindingState.BOUND) {
                ItemStack stackHeld = player.func_184614_ca();
                BlockTotemShelf.func_220054_a((BlockState)state, (World)world, (BlockPos)pos, null, (Entity)player, (ItemStack)stackHeld);
                BlockTotemShelf.func_220054_a((BlockState)stateOffset, (World)world, (BlockPos)posOffset, null, (Entity)player, (ItemStack)stackHeld);
            }
        }
        if (state.func_177229_b(BINDING_STATE) != BindingState.NOT_BOUND && !world.field_72995_K) {
            BlockTotemShelf.addShelfBreakingEffects(world, pos, state, false);
        }
        super.func_176208_a(world, pos, state, player);
    }

    public static void addShelfBreakingEffects(World world, BlockPos pos, BlockState state, boolean addFlames) {
        world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (SoundEvent)SoundsMod.EXHALE.get(), SoundCategory.MASTER, 1.0f, 2.4f - world.field_73012_v.nextFloat() * 1.0f);
        PacketNetwork.sendToAllAround(new PacketShelfSmokeParticles(state.func_215685_b((IBlockReader)world, pos, null).func_197752_a().func_186670_a(pos).func_186662_g(0.1), addFlames), world, pos);
    }

    public static void spawnShelfSmokeParticles(World world, AxisAlignedBB box, boolean addFlames) {
        for (int i = 0; i < (addFlames ? 36 : 24); ++i) {
            world.func_195594_a((IParticleData)(addFlames && i % 3 == 0 ? ParticleTypes.field_197631_x : ParticleTypes.field_197594_E), box.field_72340_a + (box.field_72336_d - box.field_72340_a) * world.field_73012_v.nextDouble(), box.field_72338_b + (box.field_72337_e - box.field_72338_b) * world.field_73012_v.nextDouble(), box.field_72339_c + (box.field_72334_f - box.field_72339_c) * world.field_73012_v.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{FACING, HALF, BINDING_STATE, STAGE, CHARRED});
    }

    public boolean hasTileEntity(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)STAGE) == 10;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return state.func_177229_b(HALF) == DoubleBlockHalf.UPPER && ((BindingState)((Object)state.func_177229_b(BINDING_STATE))).isTransitioning() ? new TileEntityTotemShelfBinding() : new TileEntityTotemShelf();
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        TileEntity te;
        BindingState bindingState = (BindingState)((Object)state.func_177229_b(BINDING_STATE));
        if (bindingState == BindingState.HEATING) {
            EntityUtil.spawnLightning(state, world, pos);
        }
        if (!((te = world.func_175625_s(pos)) instanceof TileEntityTotemShelf)) {
            return;
        }
        BindingState bindingStateNext = bindingState.getNext();
        if (bindingStateNext != null) {
            ((TileEntityTotemShelf)te).setBindingState(world.func_180495_p(pos), bindingStateNext, 3);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        ItemStack stackMain;
        TileEntity te;
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof ItemPlank) {
            PositionsTotemShelf positions;
            int stage = (Integer)state.func_177229_b((IProperty)STAGE);
            if (stage > 5 && stage < 10 && (positions = BlockTotemShelf.getTotemShelfPositions(state, (IWorld)world, pos)) != null) {
                if (world instanceof ServerWorld) {
                    positions.advanceStage((ServerWorld)world);
                    stack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            pos = pos.func_177984_a();
            state = world.func_180495_p(pos);
        }
        if (!((te = world.func_175625_s(pos)) instanceof TileEntityTotemShelf)) {
            return ActionResultType.PASS;
        }
        TileEntityTotemShelf totemShelf = (TileEntityTotemShelf)te;
        if (totemShelf.giveOrTakeKnife(state, world, pos, player, hand, stack, result)) {
            return ActionResultType.SUCCESS;
        }
        IItemHandler inventory = CapabilityUtil.getInventory(totemShelf);
        if (inventory.isItemValid(0, stackMain = player.func_184614_ca())) {
            VoxelShape[] totemShapes = SHAPES_TOTEMS.get(state.func_177229_b((IProperty)FACING)).get(DoubleBlockHalf.UPPER);
            for (int i = 0; i < inventory.getSlots(); ++i) {
                if (TileEntityTotemShelf.getHitShape(totemShapes[i], pos, result) == null || stackMain.func_190926_b() == this.transferTotem(inventory, stackMain, i, true).func_190926_b()) continue;
                if (!world.field_72995_K) {
                    player.func_184611_a(Hand.MAIN_HAND, this.transferTotem(inventory, stackMain, i, false));
                    float modifier = stackMain.func_190926_b() ? 2.0f : 1.0f;
                    world.func_184133_a(null, pos, SoundEvents.field_219618_ai, SoundCategory.MASTER, 2.0f, 1.0f * modifier);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public ItemStack transferTotem(IItemHandler inventory, ItemStack stack, int index, boolean simulate) {
        ItemStack stackShelf = inventory.extractItem(index, 1, simulate);
        inventory.insertItem(index, stack, simulate);
        return stackShelf;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return state.func_177229_b(HALF) == DoubleBlockHalf.LOWER || world.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() == newState.func_177230_c()) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityTotemShelf) {
            TileEntityTotemShelf totemShelf = (TileEntityTotemShelf)te;
            ItemStack knife = totemShelf.getKnife();
            if (!knife.func_190926_b()) {
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)knife);
            }
            IItemHandler inventory = CapabilityUtil.getInventory((TileEntityTotemShelf)te);
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            }
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return mirror == Mirror.NONE ? state : state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public float func_176195_g(BlockState state, IBlockReader world, BlockPos pos) {
        return (Integer)state.func_177229_b((IProperty)STAGE) > 5 ? 5.0f : 1.5f;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? pos.func_177984_a() : pos);
        if (!(te instanceof TileEntityTotemShelf)) {
            return 0;
        }
        IItemHandler inventory = CapabilityUtil.getInventory((TileEntityTotemShelf)te);
        double input = 0.0;
        double size = inventory.getSlots();
        int i = 0;
        while ((double)i < size) {
            input += inventory.getStackInSlot(i).func_190926_b() ? 0.0 : 15.0 / size;
            ++i;
        }
        return MathHelper.func_76128_c((double)input);
    }

    static {
        VoxelShape shape = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)5.5, (double)6.0, (double)3.0).func_197751_a(0.15625, 0.375, 0.0625);
        SHAPES_TOTEMS = BlockTotemShelf.createEnumMap(Direction.class, dir -> BlockTotemShelf.createEnumMap(DoubleBlockHalf.class, half -> (VoxelShape[])IntStream.range(0, 6).mapToObj(i -> dir.func_176740_k() == Direction.Axis.Y ? null : VoxelShapeUtil.rotateShape(shape.func_197751_a((double)(i % 2) * 0.34375, (double)(-(i / 2)) * 0.625 + (double)half.ordinal(), 0.0), dir.func_176735_f())).toArray(VoxelShape[]::new)));
    }

    public static enum BindingState implements IStringSerializable
    {
        NOT_BOUND,
        HEATING,
        COOLING,
        BOUND;


        public boolean isTransitioning() {
            return this == HEATING || this == COOLING;
        }

        public boolean hasNext() {
            return this.ordinal() < BindingState.values().length - 1;
        }

        @Nullable
        public BindingState getNext() {
            return this.hasNext() ? BindingState.values()[this.ordinal() + 1] : null;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

