/*
 * Decompiled with CFR 0.152.
 */
package com.github.phylogeny.boundtotems.block;

import com.github.phylogeny.boundtotems.block.BlockTotemShelf;
import com.github.phylogeny.boundtotems.init.BlocksMod;
import com.github.phylogeny.boundtotems.init.ItemsMod;
import com.github.phylogeny.boundtotems.network.PacketNetwork;
import com.github.phylogeny.boundtotems.network.packet.PacketTotemShelfCarveEffects;
import com.github.phylogeny.boundtotems.util.EntityUtil;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PositionsTotemShelf {
    private final BlockPos posUpper;
    private final BlockPos posLower;
    private final boolean isReversed;
    private final Integer stageNext;
    private final Direction facingTotemShelf;

    public PositionsTotemShelf(BlockState state, BlockPos posUpper, BlockPos posLower, boolean isReversed, @Nullable PlayerEntity player) {
        this.posUpper = posUpper;
        this.posLower = posLower;
        this.isReversed = isReversed;
        if (!(state.func_177230_c() instanceof BlockTotemShelf)) {
            BlockRayTraceResult result;
            this.stageNext = 0;
            this.facingTotemShelf = player == null ? Direction.NORTH : ((result = EntityUtil.rayTraceBlocks(player)).func_216346_c() == RayTraceResult.Type.MISS ? null : (result.func_216354_b().func_176740_k() == Direction.Axis.Y ? player.func_174811_aO().func_176734_d() : result.func_216354_b()));
        } else {
            int stage = (Integer)state.func_177229_b((IProperty)BlockTotemShelf.STAGE);
            this.stageNext = stage == BlockTotemShelf.STAGE.func_177700_c().size() - 1 ? null : Integer.valueOf(stage + 1);
            this.facingTotemShelf = (Direction)state.func_177229_b((IProperty)BlockTotemShelf.FACING);
        }
    }

    public void advanceStage(ServerWorld world) {
        if (this.stageNext == null) {
            return;
        }
        PacketNetwork.sendToAllAround(new PacketTotemShelfCarveEffects(this.stageNext, this.posLower, this.facingTotemShelf), (World)world, this.posUpper);
        BlockState stateNew = (BlockState)((BlockState)((BlockTotemShelf)BlocksMod.TOTEM_SHELF.get()).func_176223_P().func_206870_a((IProperty)BlockTotemShelf.STAGE, (Comparable)this.stageNext)).func_206870_a((IProperty)BlockTotemShelf.FACING, (Comparable)this.facingTotemShelf);
        world.func_175656_a(this.posUpper, (BlockState)stateNew.func_206870_a(BlockTotemShelf.HALF, (Comparable)DoubleBlockHalf.UPPER));
        world.func_175656_a(this.posLower, (BlockState)stateNew.func_206870_a(BlockTotemShelf.HALF, (Comparable)DoubleBlockHalf.LOWER));
        if (this.stageNext >= 7 || this.stageNext % 2 != 0) {
            return;
        }
        AxisAlignedBB box = (this.stageNext == 0 ? VoxelShapes.func_197868_b() : (VoxelShape)((BlockTotemShelf)BlocksMod.TOTEM_SHELF.get()).SHAPES.get(stateNew.func_206870_a((IProperty)BlockTotemShelf.STAGE, (Comparable)Integer.valueOf(this.stageNext - 1)))).func_197752_a();
        Direction facing = this.facingTotemShelf.func_176734_d();
        box = facing.func_176740_k() == Direction.Axis.X ? box.func_191195_a(facing.func_176743_c() == Direction.AxisDirection.POSITIVE ? box.field_72336_d - 0.125 : box.field_72340_a - 0.875, 0.0, 0.0) : box.func_191195_a(0.0, 0.0, facing.func_176743_c() == Direction.AxisDirection.POSITIVE ? box.field_72334_f - 0.125 : box.field_72339_c - 0.875);
        double x = (double)this.posLower.func_177958_n() + box.field_72340_a + (double)world.field_73012_v.nextFloat() * (box.field_72336_d - box.field_72340_a);
        double y = (float)this.posLower.func_177956_o() + world.field_73012_v.nextFloat() * 2.0f;
        double z = (double)this.posLower.func_177952_p() + box.field_72339_c + (double)world.field_73012_v.nextFloat() * (box.field_72334_f - box.field_72339_c);
        ItemEntity ItemEntity2 = new ItemEntity((World)world, x, y, z, new ItemStack((IItemProvider)ItemsMod.PLANK.get()));
        ItemEntity2.func_174869_p();
        world.func_217376_c((Entity)ItemEntity2);
    }

    public BlockPos getPosOffset() {
        return this.isReversed ? this.posUpper : this.posLower;
    }

    @Nullable
    public Integer getNextStage() {
        return this.stageNext;
    }
}

