/*
 * Decompiled with CFR 0.152.
 */
package com.github.phylogeny.boundtotems.client;

import com.github.phylogeny.boundtotems.block.BlockTotemShelf;
import com.github.phylogeny.boundtotems.client.Ghost;
import com.github.phylogeny.boundtotems.init.BlocksMod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    private static final Map<DimensionType, List<Ghost>> GHOSTS = new HashMap<DimensionType, List<Ghost>>();

    public static void addGhost(World world, Entity entity, float velocity, int maxLife, @Nullable Vec3d targetPos, @Nullable Entity targetEntity) {
        DimensionType dimension = world.field_73011_w.getDimension().func_186058_p();
        List<Ghost> ghosts = GHOSTS.get(dimension);
        if (ghosts == null) {
            ghosts = new ArrayList<Ghost>();
        }
        ghosts.add(new Ghost(entity, velocity, maxLife, targetPos, targetEntity));
        GHOSTS.put(dimension, ghosts);
    }

    @SubscribeEvent
    public static void updateGhosts(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START || ClientEvents.getWorld() == null || Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        DimensionType dimension = ClientEvents.getWorld().field_73011_w.getDimension().func_186058_p();
        List<Ghost> ghosts = GHOSTS.get(dimension);
        if (ghosts == null) {
            return;
        }
        ghosts.removeIf(Ghost::update);
        if (ghosts.isEmpty()) {
            GHOSTS.remove(dimension);
        }
    }

    @SubscribeEvent
    public static void renderGhosts(RenderWorldLastEvent event) {
        List<Ghost> ghosts = GHOSTS.get(ClientEvents.getWorld().field_73011_w.getDimension().func_186058_p());
        if (ghosts != null) {
            ghosts.forEach(ghost -> ghost.render(event));
        }
    }

    public static void playSoundAtEntity(Entity entity, SoundEvent sound, float pitch) {
        ClientEvents.getWorld().func_184134_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), sound, entity.func_184176_by(), 1.0f, pitch, false);
    }

    public static World getWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    public static PlayerEntity getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static void addKnifeRemovalEffects(Vec3d knifePos, BlockState state) {
        BlockPos pos = new BlockPos(knifePos);
        double x = knifePos.field_72450_a - (double)pos.func_177958_n();
        double y = knifePos.field_72448_b - (double)pos.func_177956_o();
        double z = knifePos.field_72449_c - (double)pos.func_177952_p();
        float pitch = ClientEvents.getPlayer().field_70125_A;
        float yaw = ClientEvents.getPlayer().field_70177_z;
        float radToDeg = (float)Math.PI / 180;
        double motionX = -MathHelper.func_76126_a((float)(yaw * radToDeg)) * MathHelper.func_76134_b((float)(pitch * radToDeg));
        double motionY = -MathHelper.func_76126_a((float)(pitch * radToDeg));
        double motionZ = MathHelper.func_76134_b((float)(yaw * radToDeg)) * MathHelper.func_76134_b((float)(pitch * radToDeg));
        float f = MathHelper.func_76133_a((double)(motionX * motionX + motionY * motionY + motionZ * motionZ));
        motionX /= (double)f;
        motionY /= (double)f;
        motionZ /= (double)f;
        double inaccuracy = 0.75;
        double velocity = 0.05;
        Random rand = ClientEvents.getWorld().field_73012_v;
        for (int i = 0; i < 4; ++i) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a(new DiggingParticleExtended(pos, x + rand.nextDouble() * 0.1 - 0.05, y + rand.nextDouble() * 0.1 - 0.05, z + rand.nextDouble() * 0.1 - 0.05, -(motionX + rand.nextGaussian() * inaccuracy) * velocity, -(motionY + rand.nextGaussian() * inaccuracy) * velocity, -(motionZ + rand.nextGaussian() * inaccuracy) * velocity, state, true).func_70541_f(0.5f));
        }
    }

    public static void addTotemShelfCarveEffects(BlockPos pos, int stageNext, Direction facing) {
        BlockState stateNew = (BlockState)((BlockState)((BlockTotemShelf)BlocksMod.TOTEM_SHELF.get()).func_176223_P().func_206870_a((IProperty)BlockTotemShelf.STAGE, (Comparable)Integer.valueOf(stageNext))).func_206870_a((IProperty)BlockTotemShelf.FACING, (Comparable)facing);
        SoundType sound = ((BlockTotemShelf)BlocksMod.TOTEM_SHELF.get()).func_220072_p(stateNew);
        boolean placing = stageNext >= 7;
        ((ClientWorld)ClientEvents.getWorld()).func_184156_a(pos, placing ? sound.func_185841_e() : SoundEvents.field_203255_y, SoundCategory.BLOCKS, (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f, false);
        if (!placing) {
            VoxelShape shapeOld = stageNext == 0 ? VoxelShapes.func_197868_b() : (VoxelShape)((BlockTotemShelf)BlocksMod.TOTEM_SHELF.get()).SHAPES.get(stateNew.func_206870_a((IProperty)BlockTotemShelf.STAGE, (Comparable)Integer.valueOf(stageNext - 1)));
            VoxelShape shapeRemoved = VoxelShapes.func_197882_b((VoxelShape)((VoxelShape)((BlockTotemShelf)BlocksMod.TOTEM_SHELF.get()).SHAPES.get((Object)stateNew)), (VoxelShape)shapeOld, (IBooleanFunction)IBooleanFunction.field_223236_g_);
            ClientEvents.addBlockDestroyEffects(pos, stateNew, shapeRemoved);
        }
    }

    private static void addBlockDestroyEffects(BlockPos pos, BlockState state, VoxelShape shape) {
        if (state.isAir((IBlockReader)ClientEvents.getWorld(), pos)) {
            return;
        }
        shape.func_197755_b((minX, minY, minZ, maxX, maxY, maxZ) -> {
            double dx = Math.min(1.0, maxX - minX);
            double dy = Math.min(2.0, maxY - minY);
            double dz = Math.min(1.0, maxZ - minZ);
            int countX = Math.max(2, MathHelper.func_76143_f((double)(dx / 0.25)));
            int countY = Math.max(2, MathHelper.func_76143_f((double)(dy / 0.25)));
            int countZ = Math.max(2, MathHelper.func_76143_f((double)(dz / 0.25)));
            for (int l = 0; l < countX; ++l) {
                for (int i1 = 0; i1 < countY; ++i1) {
                    for (int j1 = 0; j1 < countZ; ++j1) {
                        double x = ((double)l + 0.5) / (double)countX;
                        double y = ((double)i1 + 0.5) / (double)countY;
                        double z = ((double)j1 + 0.5) / (double)countZ;
                        double xCoord = x * dx + minX;
                        double yCoord = y * dy + minY;
                        double zCoord = z * dz + minZ;
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new DiggingParticleExtended(pos, xCoord, yCoord, zCoord, 0.0, 0.0, 0.0, state, false));
                    }
                }
            }
        });
    }

    private static class DiggingParticleExtended
    extends DiggingParticle {
        public DiggingParticleExtended(BlockPos pos, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, BlockState state, boolean exactVelocity) {
            super(ClientEvents.getWorld(), (double)pos.func_177958_n() + xCoord, (double)pos.func_177956_o() + yCoord, (double)pos.func_177952_p() + zCoord, xSpeed, ySpeed, zSpeed, state);
            this.func_174846_a(pos);
            if (exactVelocity) {
                this.field_187129_i = xSpeed;
                this.field_187130_j = ySpeed;
                this.field_187131_k = zSpeed;
            }
        }
    }
}

