/*
 * Decompiled with CFR 0.152.
 */
package com.github.phylogeny.boundtotems.client;

import com.github.phylogeny.boundtotems.client.BufferBuilderTransparent;
import com.github.phylogeny.boundtotems.client.ClientEvents;
import com.github.phylogeny.boundtotems.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class Ghost {
    private static final Field LAYER_RENDERERS = ObfuscationReflectionHelper.findField(LivingRenderer.class, (String)"field_177097_h");
    public static final Field GAME_TYPE = ObfuscationReflectionHelper.findField(NetworkPlayerInfo.class, (String)"field_178866_b");
    private final Entity entity;
    private final Entity targetEntity;
    private final float velocity;
    private final float maxLife;
    private Vec3d pos;
    private Vec3d motion;
    private Vec3d targetPos;
    private int life;
    private int alpha;

    public Ghost(Entity entity, float velocity, int maxLife, @Nullable Vec3d targetPos, @Nullable Entity targetEntity) {
        this.entity = entity;
        this.velocity = velocity;
        this.life = maxLife;
        this.maxLife = this.life;
        if (targetPos != null) {
            targetPos = this.offsetTarget(targetPos);
        }
        this.targetPos = targetPos;
        this.targetEntity = targetEntity;
        this.pos = entity.func_174791_d();
        this.updateMotion();
    }

    public boolean update() {
        this.updateMotion();
        this.pos = this.pos.func_178787_e(this.motion);
        return this.life-- == 0;
    }

    private void updateMotion() {
        if (this.targetEntity != null) {
            this.targetPos = this.offsetTarget(this.targetEntity.func_174824_e(1.0f));
        }
        Vec3d dir = this.targetPos.func_178788_d(this.pos);
        this.motion = dir.func_72432_b().func_186678_a((double)this.velocity);
        this.alpha = (int)Math.max(150.0 - 150.0 * Math.max(1.0 - dir.func_72433_c() + 0.1, 0.0), 0.0);
    }

    private Vec3d offsetTarget(Vec3d target) {
        return target.func_178786_a(0.0, (double)this.entity.func_213302_cg() * (this.entity instanceof ItemEntity ? 1.0 : 0.5), 0.0);
    }

    public void render(RenderWorldLastEvent event) {
        IRenderTypeBuffer.Impl typeBuffer = BufferBuilderTransparent.getRenderTypeBuffer();
        float partialTicks = event.getPartialTicks();
        Vec3d pos = this.pos.func_178787_e(this.motion.func_186678_a((double)partialTicks));
        Vec3d posCamera = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        double dx = pos.field_72450_a - posCamera.field_72450_a;
        double dy = pos.field_72448_b - posCamera.field_72448_b;
        double dz = pos.field_72449_c - posCamera.field_72449_c;
        float f = this.entity.field_70126_B + (this.entity.field_70177_z - this.entity.field_70126_B) * partialTicks;
        BufferBuilderTransparent.alpha = (int)((float)this.alpha * ((float)this.life / this.maxLife));
        EntityRendererManager rendererManager = Minecraft.func_71410_x().func_175598_ae();
        rendererManager.func_178633_a(false);
        int packedLight = 0xF000F0;
        if (this.entity instanceof ItemEntity) {
            rendererManager.func_229084_a_(this.entity, dx, dy, dz, f, partialTicks, event.getMatrixStack(), (IRenderTypeBuffer)typeBuffer, packedLight);
        } else {
            EntityRenderer renderer = rendererManager.func_78713_a(this.entity);
            if (renderer instanceof LivingRenderer) {
                LivingRenderer rendererLiving = (LivingRenderer)renderer;
                List layers = (List)ReflectionUtil.getValue(LAYER_RENDERERS, rendererLiving);
                ReflectionUtil.setValue(LAYER_RENDERERS, rendererLiving, new ArrayList());
                RenderType renderType = rendererLiving.func_217764_d().func_228282_a_(rendererLiving.func_110775_a(this.entity));
                if (this.entity instanceof PlayerEntity && !renderType.toString().contains("cutout")) {
                    rendererManager.func_229084_a_(this.entity, dx, dy, dz, f, partialTicks, event.getMatrixStack(), (IRenderTypeBuffer)typeBuffer, packedLight);
                } else {
                    NetworkPlayerInfo playerInfo;
                    ClientPlayNetHandler connection = Minecraft.func_71410_x().func_147114_u();
                    if (connection != null && (playerInfo = connection.func_175102_a(ClientEvents.getPlayer().func_146103_bH().getId())) != null) {
                        GameType gameType = playerInfo.func_178848_b();
                        ReflectionUtil.setValue(GAME_TYPE, playerInfo, GameType.SPECTATOR);
                        boolean isInvisible = this.entity.func_82150_aj();
                        this.entity.func_82142_c(true);
                        rendererManager.func_229084_a_(this.entity, dx, dy, dz, f, partialTicks, event.getMatrixStack(), (IRenderTypeBuffer)typeBuffer, packedLight);
                        ReflectionUtil.setValue(GAME_TYPE, playerInfo, gameType);
                        this.entity.func_82142_c(isInvisible);
                    }
                }
                ReflectionUtil.setValue(LAYER_RENDERERS, rendererLiving, layers);
            }
        }
        typeBuffer.func_228461_a_();
        rendererManager.func_178633_a(true);
    }
}

