/*
 * Decompiled with CFR 0.152.
 */
package com.github.phylogeny.boundtotems.client.jei;

import com.github.phylogeny.boundtotems.client.jei.InWorldRecipeCategory;
import com.github.phylogeny.boundtotems.util.LangUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class InWorldRecipe {
    private final String langKey;
    private Object[] langParameters;
    private List<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
    private List<List<ItemStack>> outputs;
    private final List<ResourceLocation> slides;
    private ITickTimer timer;

    protected InWorldRecipe(String name, IGuiHelper guiHelper, int slideCount, IItemProvider ... inputs) {
        this(name, guiHelper, slideCount, InWorldRecipe.itemsToStacks(inputs));
    }

    protected InWorldRecipe(String name, IGuiHelper guiHelper, int slideCount, ItemStack ... inputs) {
        this.inputs.add(Arrays.asList(inputs));
        this.langKey = LangUtil.join(InWorldRecipeCategory.LANG_KEY_PREFIX, "recipe", name);
        this.slides = IntStream.range(0, slideCount).mapToObj(i -> new ResourceLocation("boundtotems", "textures/jei/" + name + "_" + i + ".png")).collect(Collectors.toList());
        if (slideCount > 1) {
            this.timer = guiHelper.createTickTimer(slideCount * 15, slideCount - 1, false);
        }
    }

    public InWorldRecipe setLangParameters(Object ... langParameters) {
        this.langParameters = langParameters;
        return this;
    }

    public InWorldRecipe setOutputs(IItemProvider ... outputs) {
        return this.setOutputs(InWorldRecipe.itemsToStacks(outputs));
    }

    public InWorldRecipe setOutputs(ItemStack ... outputs) {
        this.outputs = Collections.singletonList(Arrays.asList(outputs));
        return this;
    }

    public InWorldRecipe setAdditionalInputs(IItemProvider ... inputs) {
        List inputsAdditional = Arrays.stream(inputs).map(provider -> Collections.singletonList(new ItemStack(provider))).collect(Collectors.toList());
        this.inputs = Stream.of(this.inputs, inputsAdditional).flatMap(Collection::stream).collect(Collectors.toList());
        return this;
    }

    private static ItemStack[] itemsToStacks(IItemProvider[] inputs) {
        return (ItemStack[])Arrays.stream(inputs).map(ItemStack::new).toArray(ItemStack[]::new);
    }

    public void setIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
        ingredients.setOutputLists(VanillaTypes.ITEM, this.outputs);
    }

    public ResourceLocation getCurrentSlide() {
        return this.slides.get(this.timer == null ? 0 : this.timer.getValue());
    }

    public List<String> getTooltip() {
        return Collections.singletonList(I18n.func_135052_a((String)this.langKey, (Object[])this.langParameters));
    }
}

